/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.handler;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.util.v1.EntityHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class BabyConversionHandler {
    private static final Map<class_1299<? extends class_1308>, class_1299<? extends class_1308>> BABY_MOB_CONVERSIONS = new HashMap<class_1299<? extends class_1308>, class_1299<? extends class_1308>>();

    public static void registerConversion(class_1299<? extends class_1308> targetMob, class_1299<? extends class_1308> convertsTo) {
        BABY_MOB_CONVERSIONS.put(targetMob, convertsTo);
    }

    public static EventResult onEntityLoad(class_1297 entity, class_3218 serverLevel, boolean isNewlySpawned) {
        class_1299<? extends class_1308> entityType;
        @Nullable class_3730 entitySpawnReason = EntityHelper.getMobSpawnReason((class_1297)entity);
        if (isNewlySpawned && entitySpawnReason != null && entitySpawnReason != class_3730.field_16462 && class_1642.method_29936((class_5819)serverLevel.method_8409()) && (entityType = BABY_MOB_CONVERSIONS.get(entity.method_5864())) != null && BabyConversionHandler.createAndSpawnBabyMob(serverLevel, entityType, entity, entitySpawnReason) != null) {
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static EventResultHolder<class_1269> onEntityInteract(class_1657 player, class_1937 level, class_1268 interactionHand, class_1297 target, class_243 hitVector) {
        class_1299 eggType;
        class_1299<? extends class_1308> babyType;
        class_1799 itemInHand = player.method_5998(interactionHand);
        if (target.method_5805() && itemInHand.method_7909() instanceof class_1826 && (babyType = BABY_MOB_CONVERSIONS.get(eggType = ((class_1826)itemInHand.method_7909()).method_8015(itemInHand))) != null && (target.method_5864() == babyType || target.method_5864() == eggType)) {
            class_1308 mob;
            if (!level.method_8608() && (mob = BabyConversionHandler.createAndSpawnBabyMob((class_3218)level, babyType, target, class_3730.field_16465)) != null) {
                BabyConversionHandler.finalizeSpawnEggMob(mob, itemInHand, player);
            }
            return EventResultHolder.interrupt((Object)InteractionResultHelper.sidedSuccess((boolean)level.method_8608()));
        }
        return EventResultHolder.pass();
    }

    private static void finalizeSpawnEggMob(class_1308 mob, class_1799 itemStack, class_1657 player) {
        mob.method_5966();
        if (itemStack.method_57826(class_9334.field_49631)) {
            mob.method_5665(itemStack.method_7964());
        }
        if (!player.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        player.method_7259(class_3468.field_15372.method_14956((Object)itemStack.method_7909()));
    }

    @Nullable
    private static class_1308 createAndSpawnBabyMob(class_3218 serverLevel, class_1299<? extends class_1308> entityType, class_1297 parent, class_3730 entitySpawnReason) {
        class_1308 mob;
        if (parent instanceof class_1296) {
            class_1296 ageableMob = (class_1296)parent;
            mob = ageableMob.method_5613(serverLevel, ageableMob);
        } else {
            mob = (class_1308)entityType.method_5883((class_1937)serverLevel, entitySpawnReason);
        }
        if (mob == null) {
            return null;
        }
        Preconditions.checkState((boolean)mob.method_6109(), (Object)"Baby mob must be a baby by default");
        mob.method_5808(parent.method_23317(), parent.method_23318(), parent.method_23321(), class_3532.method_15393((float)(serverLevel.field_9229.method_43057() * 360.0f)), 0.0f);
        mob.field_6241 = mob.method_36454();
        mob.field_6283 = mob.method_36454();
        class_1266 difficulty = serverLevel.method_8404(parent.method_24515());
        mob.method_5943((class_5425)serverLevel, difficulty, entitySpawnReason, null);
        serverLevel.method_30771((class_1297)mob);
        return mob;
    }
}

