/*
 * Decompiled with CFR 0.152.
 */
package xyz.dicedpixels.hardcover.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import xyz.dicedpixels.hardcover.Hardcover;
import xyz.dicedpixels.hardcover.config.BooleanConfig;
import xyz.dicedpixels.hardcover.config.Configs;

public final class ConfigManager {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(BooleanConfig.class, (Object)new BooleanConfig.Serializer()).excludeFieldsWithModifiers(new int[]{128}).setPrettyPrinting().create();
    private static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("hardcover.json");

    public static void readFile() {
        if (Files.exists(PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(PATH);){
                JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                for (Field field : Configs.class.getDeclaredFields()) {
                    Class<?> fieldType;
                    JsonElement value = jsonElement.getAsJsonObject().get(field.getName());
                    if (value == null || !BooleanConfig.class.isAssignableFrom(fieldType = field.getType())) continue;
                    boolean booleanValue = value.getAsBoolean();
                    ((BooleanConfig)field.get(null)).setValue(booleanValue);
                }
            }
            catch (Exception exception) {
                Hardcover.LOGGER.error("Failed to load configs at '{}'. Using default values.", (Object)PATH, (Object)exception);
            }
        } else {
            ConfigManager.writeFile();
        }
    }

    public static void writeFile() {
        try (BufferedWriter writer = Files.newBufferedWriter(PATH, new OpenOption[0]);){
            GSON.toJson((Object)new Configs(), (Appendable)writer);
        }
        catch (Exception exception) {
            Hardcover.LOGGER.error("Failed to save configs to '{}'.", (Object)PATH, (Object)exception);
        }
    }
}

