/*
 * Decompiled with CFR 0.152.
 */
package xyz.dicedpixels.hardcover.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10297;
import net.minecraft.class_10352;
import net.minecraft.class_10355;
import net.minecraft.class_10363;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_516;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import xyz.dicedpixels.hardcover.contract.ItemGroupProvider;

public final class CreativeTabs {
    private static final Map<CreativeTabsCategory, List<class_516>> categoryRecipeResultMap = new HashMap<CreativeTabsCategory, List<class_516>>();
    private static final Map<class_1761, CreativeTabsCategory> itemGroupCategoryMap = new HashMap<class_1761, CreativeTabsCategory>();
    private static boolean craftingScreen;

    public static Collection<CreativeTabsCategory> getItemGroupCategories() {
        ArrayList<CreativeTabsCategory> list = new ArrayList<CreativeTabsCategory>(itemGroupCategoryMap.values());
        list.sort(Comparator.comparing(category -> category.getName().getString()));
        return list;
    }

    public static List<class_516> getResultsForCategory(CreativeTabsCategory category) {
        return categoryRecipeResultMap.getOrDefault((Object)category, List.of());
    }

    public static void groupOrderedResults(class_1937 world, List<class_516> orderedResults) {
        categoryRecipeResultMap.clear();
        itemGroupCategoryMap.clear();
        class_7706.method_47330((class_7699)class_7701.field_40180.method_45383(), (boolean)false, (class_7225.class_7874)world.method_30349());
        class_10352 context = class_10363.method_65008((class_1937)world);
        for (Map.Entry entry : class_7923.field_44687.method_29722()) {
            class_1761 group;
            if (entry.getKey() == class_7706.field_41063 || (group = (class_1761)entry.getValue()).method_47312() != class_1761.class_7916.field_41052) continue;
            itemGroupCategoryMap.put(group, CreativeTabsCategory.of(group));
            for (class_1799 item : group.method_45414()) {
                ((ItemGroupProvider)item.method_7909()).hardcover$setItemGroup(group);
            }
        }
        for (class_516 resultCollection : orderedResults) {
            class_1792 item = ((class_1799)((class_10297)resultCollection.method_2650().getFirst()).method_64730(context).getFirst()).method_7909();
            class_1761 group = ((ItemGroupProvider)item).hardcover$getItemGroup();
            categoryRecipeResultMap.computeIfAbsent(itemGroupCategoryMap.get(group), key -> new ArrayList()).add(resultCollection);
        }
    }

    public static boolean isCraftingScreen() {
        return craftingScreen;
    }

    public static void setCraftingScreen(boolean craftingScreen) {
        CreativeTabs.craftingScreen = craftingScreen;
    }

    public static class CreativeTabsCategory
    extends class_10355 {
        private final class_1761 itemGroup;

        private CreativeTabsCategory(class_1761 itemGroup) {
            this.itemGroup = itemGroup;
        }

        public static CreativeTabsCategory of(class_1761 itemGroup) {
            return new CreativeTabsCategory(itemGroup);
        }

        public class_1792 getIconItem() {
            return this.itemGroup.method_7747().method_7909();
        }

        public class_2561 getName() {
            return this.itemGroup.method_7737();
        }
    }
}

