/*
 * Decompiled with CFR 0.152.
 */
package xyz.dicedpixels.hardcover.mixin.creativetabs;

import com.google.common.collect.Lists;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10287;
import net.minecraft.class_11909;
import net.minecraft.class_1729;
import net.minecraft.class_299;
import net.minecraft.class_332;
import net.minecraft.class_361;
import net.minecraft.class_507;
import net.minecraft.class_512;
import net.minecraft.class_516;
import net.minecraft.class_9884;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.dicedpixels.hardcover.config.Configs;
import xyz.dicedpixels.hardcover.contract.MouseScrollable;
import xyz.dicedpixels.hardcover.contract.TabPartitionProvider;
import xyz.dicedpixels.hardcover.contract.TooltipProvider;
import xyz.dicedpixels.hardcover.feature.CreativeTabs;
import xyz.dicedpixels.hardcover.gui.Textures;

@Mixin(value={class_507.class})
abstract class RecipeBookWidgetMixin<T extends class_1729>
implements MouseScrollable,
TabPartitionProvider {
    @Shadow
    @Nullable
    private class_512 field_3098;
    @Unique
    private int hardcover$currentTabPartition = 0;
    @Unique
    private class_361 hardcover$downButton;
    @Unique
    private List<List<class_512>> hardcover$tabPartitions = new ArrayList<List<class_512>>();
    @Unique
    private class_361 hardcover$upButton;
    @Shadow
    private int field_3102;
    @Shadow
    private int field_3100;
    @Shadow
    private int field_3101;
    @Shadow
    private class_299 field_3096;
    @Shadow
    @Final
    private List<class_512> field_3094;

    RecipeBookWidgetMixin() {
    }

    @Unique
    private class_361 hardcover$createButton(int x, int y, int width, int height, boolean toggled, Textures.SelectableTexture texture) {
        class_361 button = new class_361(x, y, width, height, toggled);
        button.method_1962(texture.asButtonTextures());
        return button;
    }

    @WrapOperation(method={"populateAllRecipes", "refreshResults"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/recipebook/ClientRecipeBook;getResultsForCategory(Lnet/minecraft/recipe/book/RecipeBookGroup;)Ljava/util/List;")})
    private List<class_516> hardcover$getCreativeTabsResultCollection(class_299 instance, class_10287 category, Operation<List<class_516>> original) {
        if (((Boolean)Configs.creativeTabs.getValue()).booleanValue() && CreativeTabs.isCraftingScreen() && category instanceof CreativeTabs.CreativeTabsCategory) {
            CreativeTabs.CreativeTabsCategory creativeTabsCategory = (CreativeTabs.CreativeTabsCategory)category;
            return CreativeTabs.getResultsForCategory(creativeTabsCategory);
        }
        return (List)original.call(new Object[]{instance, category});
    }

    @Unique
    private int hardcover$getDownButtonY(int y) {
        int tabHeight = 0;
        int partitionCount = this.hardcover$tabPartitions.get(this.hardcover$currentTabPartition).size();
        tabHeight = (Boolean)Configs.compactCreativeTabs.getValue() != false ? 22 : 26;
        return y + tabHeight * partitionCount + partitionCount + 1;
    }

    @Override
    public void hardcover$incrementTabPartition() {
        boolean refresh = false;
        if (this.hardcover$currentTabPartition < this.hardcover$tabPartitions.size() - 1) {
            ++this.hardcover$currentTabPartition;
            refresh = true;
        } else if (((Boolean)Configs.circularScrolling.getValue()).booleanValue()) {
            this.hardcover$currentTabPartition = 0;
            refresh = true;
        }
        if (refresh) {
            this.hardcover$resetCurrentTab();
            this.method_2606(this.method_62045());
        }
    }

    @Override
    public void hardcover$decrementTabPartition() {
        boolean refresh = false;
        if (this.hardcover$currentTabPartition > 0) {
            --this.hardcover$currentTabPartition;
            refresh = true;
        } else if (((Boolean)Configs.circularScrolling.getValue()).booleanValue()) {
            this.hardcover$currentTabPartition = this.hardcover$tabPartitions.size() - 1;
            refresh = true;
        }
        if (refresh) {
            this.hardcover$resetCurrentTab();
            this.method_2606(this.method_62045());
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/ToggleButtonWidget;mouseClicked(Lnet/minecraft/client/gui/Click;Z)Z")}, cancellable=true)
    private void hardcover$onUpDownButtonsClicked(class_11909 click, boolean doubled, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (CreativeTabs.isCraftingScreen() && ((Boolean)Configs.creativeTabs.getValue()).booleanValue()) {
            if (this.hardcover$downButton.method_25402(click, doubled)) {
                this.hardcover$decrementTabPartition();
                callbackInfoReturnable.setReturnValue((Object)true);
            }
            if (this.hardcover$upButton.method_25402(click, doubled)) {
                this.hardcover$incrementTabPartition();
                callbackInfoReturnable.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"refreshTabButtons"}, at={@At(value="HEAD")}, cancellable=true)
    private void hardcover$refreshTabButtons(boolean filteringCraftable, CallbackInfo callbackInfo) {
        if (CreativeTabs.isCraftingScreen() && ((Boolean)Configs.creativeTabs.getValue()).booleanValue()) {
            int initialX = (this.field_3101 - 147) / 2 - this.field_3102 - 30;
            if (((Boolean)Configs.centeredInventory.getValue()).booleanValue()) {
                initialX = initialX - 73 - 4;
            }
            int initialY = (this.field_3100 - 166) / 2 + 3;
            this.hardcover$setTabPartitions();
            this.hardcover$setUpUpDownButtons(initialX, initialY);
            this.hardcover$setUpTabButtons(filteringCraftable, initialX, initialY);
            callbackInfo.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/ToggleButtonWidget;render(Lnet/minecraft/client/gui/DrawContext;IIF)V")})
    private void hardcover$renderUpDownButtons(class_332 context, int mouseX, int mouseY, float deltaTicks, CallbackInfo callbackInfo) {
        if (CreativeTabs.isCraftingScreen() && ((Boolean)Configs.creativeTabs.getValue()).booleanValue() && this.hardcover$downButton != null && this.hardcover$upButton != null) {
            this.hardcover$downButton.method_25394(context, mouseX, mouseY, deltaTicks);
            this.hardcover$upButton.method_25394(context, mouseX, mouseY, deltaTicks);
        }
    }

    @Unique
    private void hardcover$resetCurrentTab() {
        for (class_512 tab : this.field_3094) {
            tab.method_1964(false);
        }
        this.field_3098 = this.hardcover$tabPartitions.get(this.hardcover$currentTabPartition).getFirst();
        this.field_3098.method_1964(true);
        this.method_2603(true, this.method_62045());
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void hardcover$setCraftingScreen(class_1729 craftingScreenHandler, List<class_507.class_10329> tabs, CallbackInfo callbackInfo) {
        CreativeTabs.setCraftingScreen(craftingScreenHandler instanceof class_9884);
    }

    @Unique
    private void hardcover$setTabPartitions() {
        for (class_512 widget : this.field_3094) {
            widget.field_22764 = false;
        }
        this.hardcover$tabPartitions = Lists.partition(this.field_3094, (int)((Boolean)Configs.compactCreativeTabs.getValue() != false ? 7 : 5));
    }

    @Unique
    private void hardcover$setUpTabButtons(boolean filteringCraftable, int x, int y) {
        int tabIndex = 0;
        for (class_512 tabButton : this.hardcover$tabPartitions.get(this.hardcover$currentTabPartition)) {
            class_10287 category = tabButton.method_2623();
            if (!(category instanceof CreativeTabs.CreativeTabsCategory)) continue;
            CreativeTabs.CreativeTabsCategory creativeTabsCategory = (CreativeTabs.CreativeTabsCategory)category;
            tabButton.field_22764 = true;
            if (((Boolean)Configs.compactCreativeTabs.getValue()).booleanValue()) {
                tabButton.method_48229(x + 8, y + 23 * tabIndex++);
            } else {
                tabButton.method_48229(x, y + 27 * tabIndex++);
            }
            ((TooltipProvider)tabButton).hardcover$setTooltip(creativeTabsCategory.getName());
            tabButton.method_2622(this.field_3096, filteringCraftable);
        }
    }

    @Unique
    private void hardcover$setUpUpDownButtons(int x, int y) {
        if (((Boolean)Configs.compactCreativeTabs.getValue()).booleanValue()) {
            this.hardcover$downButton = this.hardcover$createButton(x + 12, 0, 16, 7, true, Textures.TABS_DOWN_COMPACT);
            this.hardcover$upButton = this.hardcover$createButton(x + 12, y - 9, 16, 7, false, Textures.TABS_UP_COMPACT);
        } else {
            this.hardcover$downButton = this.hardcover$createButton(x + 7, 0, 17, 12, true, Textures.TABS_DOWN);
            this.hardcover$upButton = this.hardcover$createButton(x + 7, y - 14, 17, 12, false, Textures.TABS_UP);
        }
        this.hardcover$downButton.method_46419(this.hardcover$getDownButtonY(y));
        this.hardcover$downButton.field_22764 = this.hardcover$currentTabPartition > 0;
        this.hardcover$upButton.field_22764 = this.hardcover$currentTabPartition < this.hardcover$tabPartitions.size() - 1;
    }

    @Shadow
    protected abstract boolean method_62045();

    @Shadow
    protected abstract void method_2603(boolean var1, boolean var2);

    @Shadow
    protected abstract void method_2606(boolean var1);
}

