/*
 * Decompiled with CFR 0.152.
 */
package net.magicingredients;

import net.magicingredients.Helper;
import net.magicingredients.MagicIngredientsMod;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class LivingEntityInteractHandler {
    @SubscribeEvent
    private void onClick(PlayerInteractEvent.EntityInteract event) {
        Entity target = event.getTarget();
        Player player = event.getEntity();
        Level level = event.getLevel();
        Item item = player.getItemInHand(InteractionHand.MAIN_HAND).getItem();
        if (event.getLevel().isClientSide() || target.isRemoved() || player.getCooldowns().isOnCooldown(item)) {
            event.setCanceled(true);
            return;
        }
        EntityType entityType = target.getType();
        if (item == MagicIngredientsMod.PHIAL_ITEM.get()) {
            if (entityType == EntityType.VEX) {
                target.remove(Entity.RemovalReason.DISCARDED);
                Helper.reward(player, MagicIngredientsMod.PHIAL_ITEM, MagicIngredientsMod.VEX_SOUL_PHIAL_ITEM);
            } else if (entityType == EntityType.BREEZE_WIND_CHARGE) {
                target.remove(Entity.RemovalReason.DISCARDED);
                Helper.reward(player, MagicIngredientsMod.PHIAL_ITEM, MagicIngredientsMod.STORM_PHIAL_ITEM);
            }
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
            player.playSound(SoundEvents.BOTTLE_FILL, 1.0f, 1.0f);
            player.getCooldowns().addCooldown(item, 100);
        }
        if (item == MagicIngredientsMod.IRON_NEEDLE_ITEM.get()) {
            if (entityType == EntityType.PIGLIN_BRUTE) {
                DamageSource damageSource = new DamageSource(player.damageSources().generic().typeHolder());
                target.hurt(damageSource, 1.0f);
                ItemStack itemStack = Helper.reward(player, MagicIngredientsMod.PHIAL_ITEM, MagicIngredientsMod.PIGLIN_BRUTE_BLOOD_PHIAL_ITEM);
                if (itemStack != null) {
                    player.getItemInHand(InteractionHand.MAIN_HAND).hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(itemStack));
                    level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            }
            player.getCooldowns().addCooldown(item, 100);
        }
    }
}

