/*
 * Decompiled with CFR 0.152.
 */
package net.magicingredients;

import com.mojang.logging.LogUtils;
import net.magicingredients.LivingEntityInteractHandler;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="magicingredientsmod")
public class MagicIngredientsMod {
    public static final String MODID = "magicingredientsmod";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"magicingredientsmod");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"magicingredientsmod");
    public static final DeferredItem<Item> IRON_NEEDLE_ITEM = ITEMS.registerSimpleItem("iron_needle_item", new Item.Properties().stacksTo(1).durability(16));
    public static final DeferredItem<Item> CRIMSON_LEECH_ITEM = ITEMS.registerSimpleItem("crimson_leech_item", new Item.Properties());
    public static final DeferredItem<Item> WARPED_LEECH_ITEM = ITEMS.registerSimpleItem("warped_leech_item", new Item.Properties());
    public static final DeferredItem<Item> PHIAL_ITEM = ITEMS.registerSimpleItem("phial_item", new Item.Properties());
    public static final DeferredItem<Item> CRIMSON_LEECH_PHIAL_ITEM = ITEMS.registerSimpleItem("crimson_leech_phial_item", new Item.Properties());
    public static final DeferredItem<Item> WARPED_LEECH_PHIAL_ITEM = ITEMS.registerSimpleItem("warped_leech_phial_item", new Item.Properties());
    public static final DeferredItem<Item> PIGLIN_BRUTE_BLOOD_PHIAL_ITEM = ITEMS.registerSimpleItem("piglin_brute_blood_phial_item", new Item.Properties());
    public static final DeferredItem<Item> VEX_SOUL_PHIAL_ITEM = ITEMS.registerSimpleItem("vex_soul_phial_item", new Item.Properties());
    public static final DeferredItem<Item> WIND_PHIAL_ITEM = ITEMS.registerSimpleItem("wind_phial_item", new Item.Properties());
    public static final DeferredItem<Item> STORM_PHIAL_ITEM = ITEMS.registerSimpleItem("storm_phial_item", new Item.Properties());

    public MagicIngredientsMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register((Object)new LivingEntityInteractHandler());
        modEventBus.addListener(this::addCreative);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Hello from the Magic Ingredients Mod");
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept(IRON_NEEDLE_ITEM);
            event.accept(CRIMSON_LEECH_ITEM);
            event.accept(WARPED_LEECH_ITEM);
            event.accept(PHIAL_ITEM);
            event.accept(CRIMSON_LEECH_PHIAL_ITEM);
            event.accept(WARPED_LEECH_PHIAL_ITEM);
            event.accept(PIGLIN_BRUTE_BLOOD_PHIAL_ITEM);
            event.accept(VEX_SOUL_PHIAL_ITEM);
            event.accept(WIND_PHIAL_ITEM);
            event.accept(STORM_PHIAL_ITEM);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Hello from the Magic Ingredients Mod");
    }

    @EventBusSubscriber(modid="magicingredientsmod", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("Hello from the Magic Ingredients Mod");
        }
    }
}

