/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.seafarer.block.entity;

import com.mojang.logging.LogUtils;
import com.scouter.seafarer.block.entity.SFBlockEntities;
import com.scouter.seafarer.loot.SFLootTables;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_6908;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SFNetBlockEntity
extends class_2586 {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int MAX_SALT = 1;
    private static final int MAX_BRUSH_TIME = 40;
    private static final int SALT_GATHER_TIME = 24000;
    private int saltCount;
    private int gatherTicks;
    private long brushCountResetsAtTick;
    private long coolDownEndsAtTick;
    @Nullable
    private class_2350 hitDirection;
    private int brushCount;
    private class_1799 item = class_1799.field_8037;
    @Nullable
    private static final class_2960 LOOT_TABLE = SFLootTables.FISHING_NET;
    private final long lootTableSeed;

    public SFNetBlockEntity(class_2338 pPos, class_2680 pBlockState) {
        super(SFBlockEntities.NET_BLOCK_ENTITY, pPos, pBlockState);
        this.lootTableSeed = pPos.method_10063();
    }

    protected void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("count", this.saltCount);
        tag.method_10569("gatherTicks", this.gatherTicks);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.saltCount = nbt.method_10550("count");
        this.gatherTicks = nbt.method_10550("gatherTicks");
    }

    public int getGatherTicks() {
        return this.gatherTicks;
    }

    public int getSaltCount() {
        return this.saltCount;
    }

    public static void tick(class_1937 pLevel, class_2338 pPos, class_2680 pState, SFNetBlockEntity pBlockEntity) {
        if (!pLevel.method_23753(pPos).method_40220(class_6908.field_36509) || !pLevel.method_23753(pPos).method_40220(class_6908.field_36510) || pPos.method_10264() < 62) {
            return;
        }
        if (pBlockEntity.saltCount < 1 && pBlockEntity.gatherTicks < 24000) {
            ++pBlockEntity.gatherTicks;
        } else if (pBlockEntity.saltCount < 1) {
            ++pBlockEntity.saltCount;
        }
    }

    public boolean brush(long gameTime, class_1657 player, class_2350 direction) {
        if (this.hitDirection == null) {
            this.hitDirection = direction;
        }
        this.brushCountResetsAtTick = gameTime + 40L;
        if (gameTime >= this.coolDownEndsAtTick && this.field_11863 instanceof class_3218 && this.saltCount >= 1) {
            this.coolDownEndsAtTick = gameTime + 10L;
            this.unpackLootTable(player);
            int i = this.getCompletionState();
            if (++this.brushCount >= 5) {
                this.brushingCompleted(player);
                return true;
            }
            return false;
        }
        return false;
    }

    public void unpackLootTable(class_1657 player) {
        if (LOOT_TABLE != null && this.field_11863 != null && !this.field_11863.method_8608() && this.field_11863.method_8503() != null) {
            class_52 lootTable = this.field_11863.method_8503().method_3857().getLootTable(LOOT_TABLE);
            if (player instanceof class_3222) {
                class_3222 serverplayer = (class_3222)player;
                class_174.field_24479.method_27993(serverplayer, LOOT_TABLE);
            }
            class_8567 lootparams = new class_8567.class_8568((class_3218)this.field_11863).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)this.field_11867)).method_51871(player.method_7292()).method_51874(class_181.field_1226, (Object)player).method_51875(class_173.field_1179);
            ObjectArrayList objectarraylist = lootTable.method_51879(lootparams, this.lootTableSeed);
            this.item = switch (objectarraylist.size()) {
                case 0 -> class_1799.field_8037;
                case 1 -> (class_1799)objectarraylist.get(0);
                default -> {
                    LOGGER.warn("Expected max 1 loot from loot table " + LOOT_TABLE + " got " + objectarraylist.size());
                    yield (class_1799)objectarraylist.get(0);
                }
            };
            this.method_5431();
        }
    }

    private void brushingCompleted(class_1657 player) {
        if (this.field_11863 != null && this.field_11863.method_8503() != null) {
            this.dropContent(player);
            class_2680 blockstate = this.method_11010();
            this.field_11863.method_20290(3008, this.method_11016(), class_2248.method_9507((class_2680)blockstate));
            --this.saltCount;
            this.brushCount = 0;
            this.gatherTicks = 0;
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 8);
            this.method_5431();
        }
    }

    private void dropContent(class_1657 player) {
        if (this.field_11863 != null && this.field_11863.method_8503() != null) {
            this.unpackLootTable(player);
            if (!this.item.method_7960()) {
                double d0 = class_1299.field_6052.method_17685();
                double d1 = 1.0 - d0;
                double d2 = d0 / 2.0;
                class_2350 direction = Objects.requireNonNullElse(this.hitDirection, class_2350.field_11036);
                class_2338 blockpos = this.field_11867.method_10079(direction, 1);
                double d3 = (double)blockpos.method_10263() + 0.5 * d1 + d2;
                double d4 = (double)blockpos.method_10264() - 0.8 + (double)(class_1299.field_6052.method_17686() / 2.0f);
                double d5 = (double)blockpos.method_10260() + 0.5 * d1 + d2;
                class_1542 itementity = new class_1542(this.field_11863, d3, d4, d5, this.item.method_7971(this.field_11863.field_9229.method_43048(21) + 10));
                itementity.method_18799(class_243.field_1353);
                this.field_11863.method_8649((class_1297)itementity);
                this.item = class_1799.field_8037;
            }
        }
    }

    private int getCompletionState() {
        if (this.brushCount == 0) {
            return 0;
        }
        if (this.brushCount < 3) {
            return 1;
        }
        return this.brushCount < 6 ? 2 : 3;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10569("count", this.saltCount);
        return compoundTag;
    }
}

