/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.seafarer.config;

import com.scouter.seafarer.config.SFConfig;
import com.scouter.seafarer.config.helper.fileformats.FileFormat;
import com.scouter.seafarer.config.helper.fileformats.FileFormats;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFConfigManager {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"seafarer");
    private static SFConfig config;
    public static final String CONFIG_KEY = "seafarer_config";

    public static SFConfig getConfig() {
        if (config == null) {
            try {
                SFConfigManager.loadConfig();
            }
            catch (IOException e) {
                LOGGER.error("Error loading config; falling back to defaults", (Throwable)e);
                config = SFConfig.DEFAULT;
            }
        }
        return config;
    }

    private static void loadConfig() throws IOException {
        config = SFConfigManager.loadConfig(FileFormats.SEAFARER_CONFIG_FILE_FORMAT, FabricLoader.getInstance().getConfigDir(), CONFIG_KEY, SFConfig.DEFAULT);
    }

    private static <T> T loadConfig(FileFormat<T> format, Path configDir, String configName, T defaultValue) throws IOException {
        Path configFile = SFConfigManager.getConfigFilePath(configDir, "cobblemonoutbreaks", configName, format);
        if (!Files.exists(configFile = SFConfigManager.ensureFileExtension(configFile, format), new LinkOption[0])) {
            T config = defaultValue;
            Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            format.getExportStrategy().export(config, configFile);
            LOGGER.info("Default config created at {}", (Object)configFile);
            return defaultValue;
        }
        T loadedConfig = format.getImportStrategy().importData(configFile);
        if (loadedConfig != null) {
            LOGGER.info("Config successfully loaded from {}", (Object)configFile);
            return loadedConfig;
        }
        LOGGER.error("Failed to load config from {}. Falling back to default.", (Object)configFile);
        return defaultValue;
    }

    private static Path getConfigFilePath(Path configDir, String subDir, String fileName, FileFormat<?> format) {
        Path subDirPath = configDir.resolve(subDir);
        String fullName = fileName.endsWith(format.getExtension()) ? fileName : fileName + format.getExtension();
        return subDirPath.resolve(fullName);
    }

    private static <T> Path ensureFileExtension(Path filePath, FileFormat<T> format) {
        String extension = format.getExtension();
        if (!filePath.toString().endsWith(extension)) {
            return Paths.get(filePath.toString() + extension, new String[0]);
        }
        return filePath;
    }

    public static void loadAndReloadConfig() {
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> {
            try {
                SFConfigManager.loadConfig();
            }
            catch (IOException e) {
                LOGGER.error("Failed to load config during common setup", (Throwable)e);
            }
        });
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, succes) -> {
            try {
                SFConfigManager.loadConfig();
            }
            catch (IOException e) {
                LOGGER.error("Failed to load config during reload", (Throwable)e);
            }
        });
    }
}

