/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.seafarer.entity.entities;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.scouter.seafarer.block.SFBlocks;
import com.scouter.seafarer.entity.entities.VariantEntity;
import com.scouter.seafarer.entity.misc.StatedAnimal;
import com.scouter.seafarer.entity.misc.goal.GrazeAlgaeGoal;
import com.scouter.seafarer.entity.misc.state.EntityAction;
import com.scouter.seafarer.entity.misc.state.RandomStateGoal;
import com.scouter.seafarer.entity.misc.state.StateHelper;
import com.scouter.seafarer.entity.misc.state.WeightedState;
import com.scouter.seafarer.item.SFItems;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5761;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EntityCrab
extends StatedAnimal
implements GeoAnimatable,
class_5761,
VariantEntity {
    private static final class_2940<Boolean> FROM_BUCKET = class_2945.method_12791(EntityCrab.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation CRAB_IDLE = RawAnimation.begin().thenLoop("animation.crab.idle");
    private static final RawAnimation CRAB_WALK = RawAnimation.begin().thenLoop("animation.crab.walk");
    private static final RawAnimation CRAB_SPRINT_1 = RawAnimation.begin().thenLoop("animation.crab.sprint1");
    private static final RawAnimation CRAB_SPRINT_2 = RawAnimation.begin().thenLoop("animation.crab.sprint2");
    private static final RawAnimation CRAB_SWIM = RawAnimation.begin().thenLoop("animation.crab.swim");
    private static final RawAnimation CRAB_GRAZE = RawAnimation.begin().thenLoop("animation.crab.graze");
    private static final RawAnimation CRAB_DANCE = RawAnimation.begin().thenLoop("animation.crab.dance");
    private static final RawAnimation CRAB_BLINK = RawAnimation.begin().thenLoop("animation.crab.blink");
    private static final RawAnimation CRAB_CLAW = RawAnimation.begin().thenLoop("animation.crab.claw");
    private static final RawAnimation CRAB_WAVE = RawAnimation.begin().thenLoop("animation.crab.wave");
    private static final class_2940<Boolean> GRAZE = class_2945.method_12791(EntityCrab.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> WAVING = class_2945.method_12791(EntityCrab.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CRAB_CLAWING = class_2945.method_12791(EntityCrab.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CRAB_BLINKING = class_2945.method_12791(EntityCrab.class, (class_2941)class_2943.field_13323);
    private static final EntityAction CRAB_WAVE_ACTION = new EntityAction(0, e -> {}, 1);
    private static final StateHelper CRAB_WAVE_STATE = StateHelper.Builder.state(WAVING, "crab_waving").playTime(60).stopTime(100).affectsAI(true).affectedFlags(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406)).entityAction(CRAB_WAVE_ACTION).build();
    private static final EntityAction CRAB_CLAW_ACTION = new EntityAction(0, e -> {}, 1);
    private static final StateHelper CRAB_CLAW_STATE = StateHelper.Builder.state(CRAB_CLAWING, "crab_clawing").playTime(60).stopTime(100).affectsAI(true).entityAction(CRAB_CLAW_ACTION).build();
    private static final EntityAction CRAB_BLINK_ACTION = new EntityAction(0, e -> {}, 1);
    private static final StateHelper CRAB_BLINK_STATE = StateHelper.Builder.state(CRAB_BLINKING, "crab_blinking").playTime(60).stopTime(100).affectsAI(true).affectedFlags(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406)).entityAction(CRAB_BLINK_ACTION).build();
    private GrazeAlgaeGoal eatBlockGoal;
    private int eatAnimationTick;

    public EntityCrab(class_1299<? extends class_1429> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 5.0).method_26868(class_5134.field_23719, 0.15).method_26868(class_5134.field_23724, 3.0).method_26868(class_5134.field_23725, 2.0).method_26868(class_5134.field_23718, 0.5);
    }

    protected void method_5959() {
        this.eatBlockGoal = new GrazeAlgaeGoal((class_1308)this);
        this.field_6201.method_6277(2, (class_1352)this.eatBlockGoal);
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(1, (class_1352)new class_1338((class_1314)this, class_1657.class, 5.0f, 2.5, 2.7, class_1301.field_6155::test));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(3, new RandomStateGoal<EntityCrab>(this));
    }

    protected void method_5712(class_2338 p_28301_, class_2680 p_28302_) {
        this.method_5783(class_3417.field_14760, 0.15f, 1.0f);
    }

    public boolean method_6094() {
        return true;
    }

    @Nullable
    public class_1296 method_5613(class_3218 pLevel, class_1296 pOtherParent) {
        return null;
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_37908().field_9236) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
    }

    public class_1269 method_5992(class_1657 p_27477_, class_1268 p_27478_) {
        return class_5761.method_35169((class_1657)p_27477_, (class_1268)p_27478_, (class_1309)this).orElse(super.method_5992(p_27477_, p_27478_));
    }

    public void method_5711(byte pId) {
        if (pId == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.method_5711(pId);
        }
    }

    public boolean isEating() {
        return this.eatAnimationTick > 0;
    }

    private boolean isStillEnough() {
        return this.method_18798().method_37267() > 0.001;
    }

    public static boolean canDig(class_1309 entity) {
        class_2338 pos = entity.method_23312();
        return entity.method_37908().method_8320(pos).method_27852(SFBlocks.ALGAE_BLOCK);
    }

    protected <E extends EntityCrab> PlayState Controller(AnimationState<E> event) {
        if (this.isStillEnough() && !this.method_5799()) {
            if (this.method_5624()) {
                event.setAndContinue(CRAB_SPRINT_1);
                event.getController().setAnimationSpeed(2.0);
                return PlayState.CONTINUE;
            }
            event.setAndContinue(CRAB_WALK);
            return PlayState.CONTINUE;
        }
        if (this.method_5799()) {
            event.setAndContinue(CRAB_SWIM);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.getBooleanState(CRAB_BLINKING)) {
            return event.setAndContinue(CRAB_BLINK);
        }
        if (this.getBooleanState(CRAB_CLAWING)) {
            return event.setAndContinue(CRAB_CLAW);
        }
        if (this.getBooleanState(WAVING)) {
            return event.setAndContinue(CRAB_WAVE);
        }
        return event.setAndContinue(CRAB_IDLE);
    }

    protected <E extends EntityCrab> PlayState eatController(AnimationState<E> event) {
        if (this.isEating()) {
            event.setAndContinue(CRAB_GRAZE);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Graze", 5, this::eatController)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return this.field_6012;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FROM_BUCKET, (Object)false);
        this.field_6011.method_12784(CRAB_BLINKING, (Object)false);
        this.field_6011.method_12784(CRAB_CLAWING, (Object)false);
        this.field_6011.method_12784(WAVING, (Object)false);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("FromBucket", this.method_6453());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.method_6454(compound.method_10577("FromBucket"));
    }

    public boolean method_6453() {
        return (Boolean)this.field_6011.method_12789(FROM_BUCKET);
    }

    public void method_6454(boolean p_203706_1_) {
        this.field_6011.method_12778(FROM_BUCKET, (Object)p_203706_1_);
    }

    public void method_6455(class_1799 bucket) {
        class_2487 compoundnbt = bucket.method_7948();
        class_5761.method_35167((class_1308)this, (class_1799)bucket);
        compoundnbt.method_10548("Health", this.method_6032());
        if (this.method_16914()) {
            bucket.method_7977(this.method_5797());
        }
    }

    public void method_35170(class_2487 pTag) {
        class_5761.method_35168((class_1308)this, (class_2487)pTag);
    }

    public class_1799 method_6452() {
        class_1799 stack = new class_1799((class_1935)SFItems.SHORE_CRAB_BUCKET);
        if (this.method_16914()) {
            stack.method_7977(this.method_5797());
        }
        return stack;
    }

    public class_3414 method_35171() {
        return class_3417.field_14912;
    }

    @Nullable
    public class_1315 method_5943(class_5425 levelAccessor, class_1266 difficultyInstance, class_3730 spawnType, @Nullable class_1315 spawnGroupData, @Nullable class_2487 tag) {
        spawnGroupData = super.method_5943(levelAccessor, difficultyInstance, spawnType, spawnGroupData, tag);
        return spawnGroupData;
    }

    public static boolean checkCrabSpawnRules(class_1299<? extends EntityCrab> dino, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 p_186242_) {
        return EntityCrab.method_39448((class_1920)level, (class_2338)pos);
    }

    @Override
    public ImmutableMap<String, StateHelper> getStates() {
        return ImmutableMap.of((Object)CRAB_BLINK_STATE.getName(), (Object)CRAB_BLINK_STATE, (Object)CRAB_CLAW_STATE.getName(), (Object)CRAB_CLAW_STATE, (Object)CRAB_WAVE_STATE.getName(), (Object)CRAB_WAVE_STATE);
    }

    @Override
    public List<WeightedState<StateHelper>> getWeightedStatesToPerform() {
        return ImmutableList.of(WeightedState.of(CRAB_BLINK_STATE, 77), WeightedState.of(CRAB_CLAW_STATE, 15), WeightedState.of(CRAB_WAVE_STATE, 10));
    }

    @Override
    public int getVariant() {
        return 0;
    }
}

