/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.seafarer.entity.entities;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.scouter.seafarer.entity.entities.Brushable;
import com.scouter.seafarer.entity.entities.VariantEntity;
import com.scouter.seafarer.entity.entities.navigation.SmoothGroundNavigation;
import com.scouter.seafarer.entity.misc.StatedAnimal;
import com.scouter.seafarer.entity.misc.controller.WaterMoveController;
import com.scouter.seafarer.entity.misc.goal.CustomRandomStrollGoal;
import com.scouter.seafarer.entity.misc.goal.FindWaterGoal;
import com.scouter.seafarer.entity.misc.goal.GrazeAlgaeGoal;
import com.scouter.seafarer.entity.misc.goal.LeaveWaterGoal;
import com.scouter.seafarer.entity.misc.goal.SemiAquaticSwimmingGoal;
import com.scouter.seafarer.entity.misc.interfaces.SemiAquatic;
import com.scouter.seafarer.entity.misc.navigator.SemiAquaticPathNavigation;
import com.scouter.seafarer.entity.misc.state.EntityAction;
import com.scouter.seafarer.entity.misc.state.RandomStateGoal;
import com.scouter.seafarer.entity.misc.state.StateHelper;
import com.scouter.seafarer.entity.misc.state.WeightedState;
import com.scouter.seafarer.item.SFItems;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1266;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EntityMarineIguana
extends StatedAnimal
implements GeoAnimatable,
SemiAquatic,
Brushable,
VariantEntity {
    private static final class_2940<Integer> SALT = class_2945.method_12791(EntityMarineIguana.class, (class_2941)class_2943.field_13327);
    private static final RawAnimation MARINE_IGUANA_WALK = RawAnimation.begin().thenLoop("animation.marineiguana.walk");
    private static final RawAnimation MARINE_IGUANA_RUN = RawAnimation.begin().thenLoop("animation.marineiguana.run");
    private static final RawAnimation MARINE_IGUANA_IDLE = RawAnimation.begin().thenLoop("animation.marineiguana.idle");
    private static final RawAnimation MARINE_IGUANA_SIT1 = RawAnimation.begin().thenLoop("animation.marineiguana.sit1");
    private static final RawAnimation MARINE_IGUANA_SIT2 = RawAnimation.begin().thenLoop("animation.marineiguana.sit2");
    private static final RawAnimation MARINE_IGUANA_SIT3 = RawAnimation.begin().thenLoop("animation.marineiguana.sit3");
    private static final RawAnimation MARINE_IGUANA_SWIM = RawAnimation.begin().thenLoop("animation.marineiguana.swim");
    private static final RawAnimation MARINE_IGUANA_SWIM_IDLE = RawAnimation.begin().thenLoop("animation.marineiguana.swim_idle");
    private static final RawAnimation MARINE_IGUANA_SNEEZE = RawAnimation.begin().thenLoop("animation.marineiguana.sneeze");
    private static final RawAnimation MARINE_IGUANA_GRAZE = RawAnimation.begin().thenLoop("animation.marineiguana.graze");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public float prevSwimProgress;
    public float swimProgress;
    private int swimTimer = -1000;
    private boolean isLandNavigator;
    private GrazeAlgaeGoal eatBlockGoal;
    private int eatAnimationTick;
    private int SaltTime = 0;
    private static final class_2940<Boolean> SIT_1 = class_2945.method_12791(EntityMarineIguana.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SIT_2 = class_2945.method_12791(EntityMarineIguana.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SIT_3 = class_2945.method_12791(EntityMarineIguana.class, (class_2941)class_2943.field_13323);
    private static final EntityAction IGUANA_SIT_1_ACTION = new EntityAction(0, e -> {}, 1);
    private static final StateHelper IGUANA_SIT_1_STATE = StateHelper.Builder.state(SIT_1, "iguana_sit_1").playTime(70).stopTime(100).affectsAI(true).affectedFlags(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406)).entityAction(IGUANA_SIT_1_ACTION).build();
    private static final EntityAction IGUANA_SIT_2_ACTION = new EntityAction(0, e -> {}, 1);
    private static final StateHelper IGUANA_SIT_2_STATE = StateHelper.Builder.state(SIT_2, "iguana_sit_2").playTime(70).stopTime(100).affectsAI(true).affectedFlags(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406)).entityAction(IGUANA_SIT_2_ACTION).build();
    private static final EntityAction IGUANA_SIT_3_ACTION = new EntityAction(0, e -> {}, 1);
    private static final StateHelper IGUANA_SIT_3_STATE = StateHelper.Builder.state(SIT_3, "iguana_sit_3").playTime(70).stopTime(100).affectsAI(true).affectedFlags(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406)).entityAction(IGUANA_SIT_3_ACTION).build();

    public EntityMarineIguana(class_1299<? extends class_1429> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
        this.method_5941(class_7.field_18, 0.0f);
        this.method_5941(class_7.field_4, 0.0f);
        this.switchNavigator(false);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23721, 0.0).method_26868(class_5134.field_23724, 5.0).method_26868(class_5134.field_23719, 0.18).method_26868(class_5134.field_23718, 0.5);
    }

    protected void method_5959() {
        this.eatBlockGoal = new GrazeAlgaeGoal((class_1308)this);
        this.field_6201.method_6277(2, (class_1352)this.eatBlockGoal);
        this.field_6201.method_6277(7, (class_1352)new FindWaterGoal((class_1314)this));
        this.field_6201.method_6277(7, (class_1352)new LeaveWaterGoal((class_1314)this));
        this.field_6201.method_6277(9, (class_1352)new SemiAquaticSwimmingGoal(this, 1.0, 10));
        this.field_6201.method_6277(3, (class_1352)new CustomRandomStrollGoal((class_1314)this, 30, 1.0, 100, 34));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(3, new RandomStateGoal<EntityMarineIguana>(this));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_6207 = new class_1335((class_1308)this);
            this.field_6189 = new SmoothGroundNavigation((class_1308)this, this.method_37908());
            this.isLandNavigator = true;
        } else {
            this.field_6207 = new WaterMoveController((class_1314)this, 1.1f);
            this.field_6189 = new SemiAquaticPathNavigation((class_1308)this, this.method_37908());
            this.isLandNavigator = false;
        }
    }

    public void method_5773() {
        boolean ground;
        super.method_5773();
        this.prevSwimProgress = this.swimProgress;
        boolean bl = ground = !this.method_5816();
        if (!ground && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (ground && this.swimProgress > 0.0f) {
            this.swimProgress -= 1.0f;
        }
        if (!ground && this.swimProgress < 5.0f) {
            this.swimProgress += 1.0f;
        }
        if (!this.method_37908().field_9236) {
            this.swimTimer = this.method_5799() ? ++this.swimTimer : --this.swimTimer;
        }
        ++this.SaltTime;
        if (this.method_5805() && this.SaltTime > 2000) {
            this.SaltTime = 0;
            this.setSalt(Math.min(10, this.getSalt() + 1));
        }
    }

    @Override
    public void method_6091(class_243 travelVector) {
        if (this.method_6034() && this.method_5799()) {
            this.method_5724(this.method_6029(), travelVector);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
            if (this.method_5968() == null) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.005, 0.0));
            }
        } else {
            super.method_6091(travelVector);
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_37908().field_9236) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
    }

    public void method_5711(byte pId) {
        if (pId == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.method_5711(pId);
        }
    }

    public boolean isEating() {
        return this.eatAnimationTick > 0;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SALT, (Object)0);
        this.field_6011.method_12784(SIT_1, (Object)false);
        this.field_6011.method_12784(SIT_2, (Object)false);
        this.field_6011.method_12784(SIT_3, (Object)false);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("SwimTimer", this.swimTimer);
        compound.method_10569("SaltTime", this.SaltTime);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.swimTimer = compound.method_10550("SwimTimer");
        this.SaltTime = compound.method_10550("SaltTime");
    }

    public int getSalt() {
        return (Integer)this.field_6011.method_12789(SALT);
    }

    public void setSalt(int Salt) {
        this.field_6011.method_12778(SALT, (Object)Salt);
    }

    public boolean method_6094() {
        return true;
    }

    @Override
    public boolean shouldEnterWater() {
        return !this.shouldLeaveWater() && this.swimTimer <= -1000;
    }

    @Override
    public boolean shouldLeaveWater() {
        class_1309 target = this.method_5968();
        if (target != null && !target.method_5799()) {
            return true;
        }
        return this.swimTimer > 600;
    }

    @Override
    public int getWaterSearchRange() {
        return 12;
    }

    @Override
    public boolean shouldStopMoving() {
        return false;
    }

    @Nullable
    public class_1296 method_5613(class_3218 pLevel, class_1296 pOtherParent) {
        return null;
    }

    protected <E extends EntityMarineIguana> PlayState Controller(AnimationState<E> event) {
        if (!(event.getLimbSwingAmount() > -0.06f && event.getLimbSwingAmount() < 0.06f || this.method_5799())) {
            if (this.method_5624()) {
                event.setAndContinue(MARINE_IGUANA_RUN);
                event.getController().setAnimationSpeed(2.0);
                return PlayState.CONTINUE;
            }
            return event.setAndContinue(MARINE_IGUANA_WALK);
        }
        if (!(event.getLimbSwingAmount() > -0.06f && event.getLimbSwingAmount() < 0.06f || !this.method_5799())) {
            event.setAnimation(MARINE_IGUANA_SWIM);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.method_5799()) {
            event.setAnimation(MARINE_IGUANA_SWIM_IDLE);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.getBooleanState(SIT_1)) {
            return event.setAndContinue(MARINE_IGUANA_SIT1);
        }
        if (this.getBooleanState(SIT_2)) {
            return event.setAndContinue(MARINE_IGUANA_SIT2);
        }
        if (this.getBooleanState(SIT_3)) {
            return event.setAndContinue(MARINE_IGUANA_SIT3);
        }
        if (this.isEating()) {
            event.setAndContinue(MARINE_IGUANA_GRAZE);
            return PlayState.CONTINUE;
        }
        return event.setAndContinue(MARINE_IGUANA_IDLE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return this.field_6012;
    }

    @Nullable
    public class_1315 method_5943(class_5425 levelAccessor, class_1266 difficultyInstance, class_3730 spawnType, @Nullable class_1315 spawnGroupData, @Nullable class_2487 tag) {
        spawnGroupData = super.method_5943(levelAccessor, difficultyInstance, spawnType, spawnGroupData, tag);
        return spawnGroupData;
    }

    public static boolean checkMarineIguanaSpawnRules(class_1299<? extends EntityMarineIguana> dino, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 p_186242_) {
        return EntityMarineIguana.method_39448((class_1920)level, (class_2338)pos);
    }

    @Override
    public void startBrusing() {
    }

    @Override
    public void endBrushing() {
    }

    @Override
    public boolean isBrushable(class_1657 player, @NotNull class_1799 item, class_1937 level, class_2338 pos) {
        return this.canBeBrushed();
    }

    public boolean canBeBrushed() {
        return this.method_5805() && this.getSalt() > 0;
    }

    @Override
    public int getVariant() {
        return this.canBeBrushed() ? 1 : 0;
    }

    @Override
    public List<class_1799> brush(long gameTime, class_1657 player, class_2350 direction, class_1799 stack, class_1937 level, class_2338 pos, int fortune) {
        level.method_43129(null, (class_1297)this, class_3417.field_43155, player == null ? class_3419.field_15245 : class_3419.field_15248, 1.0f, 1.0f);
        this.method_32876(class_5712.field_28725);
        if (!level.method_8608() && this.field_5974.method_43057() < (float)this.getSalt() * 0.05f) {
            class_1799 stack1 = SFItems.SALT.method_7854();
            stack1.method_7939(this.getSalt());
            return Collections.singletonList(stack1);
        }
        this.setSalt(0);
        return Collections.emptyList();
    }

    @Override
    public class_3414 brushSound() {
        return class_3417.field_43155;
    }

    @Override
    public ImmutableMap<String, StateHelper> getStates() {
        return ImmutableMap.of((Object)IGUANA_SIT_1_STATE.getName(), (Object)IGUANA_SIT_1_STATE, (Object)IGUANA_SIT_2_STATE.getName(), (Object)IGUANA_SIT_2_STATE, (Object)IGUANA_SIT_3_STATE.getName(), (Object)IGUANA_SIT_3_STATE);
    }

    @Override
    public List<WeightedState<StateHelper>> getWeightedStatesToPerform() {
        return ImmutableList.of(WeightedState.of(IGUANA_SIT_1_STATE, 77), WeightedState.of(IGUANA_SIT_2_STATE, 15), WeightedState.of(IGUANA_SIT_3_STATE, 10));
    }
}

