/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.seafarer.entity.misc.state;

import com.scouter.seafarer.entity.misc.state.EntityAction;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2940;

public class StateHelper {
    private final class_2940<Boolean> state;
    private final int playTime;
    private final int stopTime;
    private final boolean affectsAI;
    private final String name;
    private final EnumSet<class_1352.class_4134> affectedFlags;
    private final Predicate<class_1309> startingPredicate;
    private final EntityAction entityAction;

    public StateHelper(class_2940<Boolean> state, String name) {
        this(state, name, 0, 0, false, EnumSet.noneOf(class_1352.class_4134.class), StateHelper.defaultStartingPredicate(), StateHelper.defaultEntityAction());
    }

    public StateHelper(class_2940<Boolean> state, String name, int playTime) {
        this(state, name, playTime, 0, false, EnumSet.noneOf(class_1352.class_4134.class), StateHelper.defaultStartingPredicate(), StateHelper.defaultEntityAction());
    }

    public StateHelper(class_2940<Boolean> state, String name, int playTime, int stopTime) {
        this(state, name, playTime, stopTime, false, EnumSet.noneOf(class_1352.class_4134.class), StateHelper.defaultStartingPredicate(), StateHelper.defaultEntityAction());
    }

    public StateHelper(class_2940<Boolean> state, String name, int playTime, int stopTime, boolean affectsAI) {
        this(state, name, playTime, stopTime, affectsAI, EnumSet.noneOf(class_1352.class_4134.class), StateHelper.defaultStartingPredicate(), StateHelper.defaultEntityAction());
    }

    public StateHelper(class_2940<Boolean> state, String name, int playTime, int stopTime, boolean affectsAI, EnumSet<class_1352.class_4134> affectedFlags) {
        this(state, name, playTime, stopTime, affectsAI, affectedFlags, StateHelper.defaultStartingPredicate(), StateHelper.defaultEntityAction());
    }

    public StateHelper(class_2940<Boolean> state, String name, int playTime, int stopTime, boolean affectsAI, EnumSet<class_1352.class_4134> affectedFlags, Predicate<class_1309> startingPredicate) {
        this(state, name, playTime, stopTime, affectsAI, affectedFlags, startingPredicate, StateHelper.defaultEntityAction());
    }

    public StateHelper(class_2940<Boolean> state, String name, int playTime, int stopTime, boolean affectsAI, EnumSet<class_1352.class_4134> affectedFlags, Predicate<class_1309> startingPredicate, EntityAction entityAction) {
        if (state == null || startingPredicate == null || entityAction == null) {
            throw new IllegalArgumentException("State, starting predicate, and entity action cannot be null.");
        }
        this.state = state;
        this.playTime = playTime;
        this.stopTime = stopTime;
        this.affectsAI = affectsAI;
        this.affectedFlags = affectedFlags;
        this.startingPredicate = startingPredicate;
        this.entityAction = entityAction;
        this.name = name;
    }

    public class_2940<Boolean> getState() {
        return this.state;
    }

    public int getPlayTime() {
        return this.playTime;
    }

    public int getStopTime() {
        return this.stopTime;
    }

    public boolean isAffectsAI() {
        return this.affectsAI;
    }

    public EnumSet<class_1352.class_4134> getAffectedFlags() {
        return this.affectedFlags;
    }

    public Predicate<class_1309> getStartingPredicate() {
        return this.startingPredicate;
    }

    public String getName() {
        return this.name;
    }

    public EntityAction getEntityAction() {
        return this.entityAction;
    }

    private static Predicate<class_1309> defaultStartingPredicate() {
        return e -> true;
    }

    private static EntityAction defaultEntityAction() {
        return new EntityAction(0, e -> {}, 0);
    }

    public static class Builder {
        private class_2940<Boolean> state;
        private int playTime = 0;
        private int stopTime = 0;
        private boolean affectsAI = false;
        private EnumSet<class_1352.class_4134> affectedFlags = EnumSet.noneOf(class_1352.class_4134.class);
        private Predicate<class_1309> startingPredicate = e -> true;
        private String name;
        private EntityAction entityAction = new EntityAction(0, e -> {}, 0);

        public static Builder state(class_2940<Boolean> state, String name) {
            return new Builder(state, name);
        }

        public Builder(class_2940<Boolean> state, String name) {
            if (state == null) {
                throw new IllegalArgumentException("State cannot be null.");
            }
            this.state = state;
            this.name = name;
        }

        public Builder playTime(int playTimeTicks) {
            this.playTime = playTimeTicks;
            return this;
        }

        public Builder stopTime(int stopTimeTicks) {
            this.stopTime = stopTimeTicks;
            return this;
        }

        public Builder affectsAI(boolean affectsAI) {
            this.affectsAI = affectsAI;
            return this;
        }

        public Builder affectedFlags(EnumSet<class_1352.class_4134> affectedFlags) {
            this.affectedFlags = affectedFlags;
            return this;
        }

        public Builder startingPredicate(Predicate<class_1309> startingPredicate) {
            if (startingPredicate == null) {
                throw new IllegalArgumentException("Starting predicate cannot be null.");
            }
            this.startingPredicate = startingPredicate;
            return this;
        }

        public Builder entityAction(EntityAction entityAction) {
            if (entityAction == null) {
                throw new IllegalArgumentException("Entity action cannot be null.");
            }
            this.entityAction = entityAction;
            return this;
        }

        public StateHelper build() {
            return new StateHelper(this.state, this.name, this.playTime, this.stopTime, this.affectsAI, this.affectedFlags, this.startingPredicate, this.entityAction);
        }
    }
}

