/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.seafarer.entity.model;

import com.scouter.seafarer.entity.model.ModelLocations;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ModelLocationBuilder {
    private final String modid;
    private final String entityName;
    private final String texture;
    private final Map<Integer, class_2960> textures = new HashMap<Integer, class_2960>();
    private float babyHeadScale = 1.0f;
    private String headBone = "head";

    private ModelLocationBuilder(String modid, String entityName, @Nullable String texture) {
        this.modid = modid;
        this.texture = texture;
        this.entityName = entityName;
        this.setDefaultTexture(texture == null ? entityName : texture);
    }

    public ModelLocationBuilder addVariant(int variant, String textureName) {
        this.textures.put(variant, new class_2960(this.modid, "textures/entity/" + textureName + ".png"));
        return this;
    }

    public ModelLocationBuilder addVariantWithPath(int variant, String path, String textureName) {
        this.textures.put(variant, new class_2960(this.modid, "textures/entity/" + path + "/" + textureName + ".png"));
        return this;
    }

    public ModelLocationBuilder setDefaultTexture(String textureName) {
        this.textures.put(0, new class_2960(this.modid, "textures/entity/" + textureName + ".png"));
        return this;
    }

    public ModelLocationBuilder setBabyHeadScale(float scale) {
        this.babyHeadScale = scale;
        return this;
    }

    public ModelLocationBuilder setHeadBone(String headBone) {
        this.headBone = headBone;
        return this;
    }

    public ModelLocations.ModelData build() {
        return new ModelLocations.ModelData(new class_2960(this.modid, "geo/" + this.entityName + ".geo.json"), new class_2960(this.modid, "animations/" + this.entityName + ".animation.json"), this.textures, this.babyHeadScale, this.headBone);
    }

    public static ModelLocationBuilder create(String entityName) {
        return new ModelLocationBuilder("seafarer", entityName, null);
    }

    public static ModelLocationBuilder create(String entityName, String texture) {
        return new ModelLocationBuilder("seafarer", entityName, texture);
    }
}

