/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.seafarer.world;

import com.scouter.seafarer.SeaFarer;
import com.scouter.seafarer.config.BiomeModifiersConfig;
import com.scouter.seafarer.config.EntitySpawningConfig;
import com.scouter.seafarer.config.SFConfigManager;
import com.scouter.seafarer.entity.SFEntities;
import com.scouter.seafarer.entity.entities.EntityCrab;
import com.scouter.seafarer.entity.entities.EntityHorseshoeCrab;
import com.scouter.seafarer.entity.entities.EntityMarineIguana;
import com.scouter.seafarer.entity.entities.EntitySunfish;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class SFGeneration {
    public static void registerGeneration() {
        SFGeneration.generateFeatures();
        SFGeneration.spawnCreatures();
    }

    private static void generateFeatures() {
        for (BiomeModifiersConfig biomeModifiersConfig : SFConfigManager.getConfig().getBiomeModifiersConfigList()) {
            BiomeModifications.create((class_2960)biomeModifiersConfig.getPlacedFeatureKey()).add(ModificationPhase.ADDITIONS, BiomeSelectors.tag(biomeModifiersConfig.getBiomeTag()), context -> context.getGenerationSettings().addFeature(biomeModifiersConfig.getGenerationStep(), class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)biomeModifiersConfig.getPlacedFeatureKey())));
        }
    }

    private static void spawnCreatures() {
        for (EntitySpawningConfig entitySpawningConfig : SFConfigManager.getConfig().getEntitySpawningConfigList()) {
            BiomeModifications.addSpawn((Predicate)BiomeSelectors.tag(entitySpawningConfig.getSpawnTag()), (class_1311)class_1311.field_6294, entitySpawningConfig.getEntityType(), (int)entitySpawningConfig.getWeight(), (int)entitySpawningConfig.getMinCount(), (int)entitySpawningConfig.getMaxCount());
        }
        class_1317.method_20637(SFEntities.CRAB, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, EntityCrab::checkCrabSpawnRules);
        class_1317.method_20637(SFEntities.HORSESHOE_CRAB, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, EntityHorseshoeCrab::checkHorseshoeCrabSpawnRules);
        class_1317.method_20637(SFEntities.MARINE_IGUANA, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, EntityMarineIguana::checkMarineIguanaSpawnRules);
        class_1317.method_20637(SFEntities.SUNFISH, (class_1317.class_1319)class_1317.class_1319.field_6318, (class_2902.class_2903)class_2902.class_2903.field_13203, EntitySunfish::checkSunfishSpawnRules);
    }

    private static void addPlacedFeature(String name) {
        BiomeModifications.create((class_2960)SeaFarer.prefix(name)).add(ModificationPhase.ADDITIONS, BiomeSelectors.foundInOverworld(), context -> context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)SeaFarer.prefix(name))));
    }

    private static void addPlacedFeature(String name, class_5321<class_1959> biome) {
        BiomeModifications.create((class_2960)SeaFarer.prefix(name)).add(ModificationPhase.ADDITIONS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{biome}), context -> context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)SeaFarer.prefix(name))));
    }

    private static void addPlacedFeature(String name, class_6862<class_1959> biome) {
        BiomeModifications.create((class_2960)SeaFarer.prefix(name)).add(ModificationPhase.ADDITIONS, BiomeSelectors.tag(biome), context -> context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)SeaFarer.prefix(name))));
    }
}

