/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.seafarer.world.feature;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.scouter.seafarer.block.SFBlocks;
import com.scouter.seafarer.world.feature.util.FastNoiseLite;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5281;
import net.minecraft.class_5778;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.slf4j.Logger;

public class AlgaeBoulderFeature
extends class_3031<class_3111> {
    private static final Logger LOGGER = LogUtils.getLogger();

    public AlgaeBoulderFeature(Codec<class_3111> config) {
        super(config);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_5281 worldgenlevel = context.method_33652();
        class_2338 blockpos = context.method_33655();
        class_5819 random = context.method_33654();
        FastNoiseLite noise = AlgaeBoulderFeature.createNoise(worldgenlevel.method_8412(), 0.05f);
        FastNoiseLite noise2 = AlgaeBoulderFeature.createNoise(worldgenlevel.method_8412(), 0.4f);
        FastNoiseLite noise3 = AlgaeBoulderFeature.createNoise(worldgenlevel.method_8412(), 0.5f);
        double middleBlockZ = worldgenlevel.method_8392(blockpos.method_10263() >> 4, blockpos.method_10260() >> 4).method_12004().method_33942();
        double middleBlockX = worldgenlevel.method_8392(blockpos.method_10263() >> 4, blockpos.method_10260() >> 4).method_12004().method_33940();
        double cornerBlockZ = worldgenlevel.method_8392(blockpos.method_10263() >> 4, blockpos.method_10260() >> 4).method_12004().method_8328();
        double cornerBlockX = worldgenlevel.method_8392(blockpos.method_10263() >> 4, blockpos.method_10260() >> 4).method_12004().method_8326();
        class_2338 blockPosMid = class_2338.method_49637((double)middleBlockX, (double)worldgenlevel.method_8624(class_2902.class_2903.field_13195, (int)middleBlockX, (int)middleBlockZ), (double)middleBlockZ);
        class_2338 blockPosCorner = class_2338.method_49637((double)cornerBlockX, (double)worldgenlevel.method_8624(class_2902.class_2903.field_13195, (int)cornerBlockX, (int)cornerBlockZ), (double)cornerBlockZ);
        int radius = random.method_43051(5, 10);
        AlgaeBoulderFeature.createSphere(worldgenlevel, random, blockPosMid, noise);
        AlgaeBoulderFeature.addBushes(worldgenlevel, random, blockPosMid, noise3, radius);
        return true;
    }

    public static void createSphere(class_5281 worldgenlevel, class_5819 rand, class_2338 origin, FastNoiseLite noise) {
        int height;
        int radius = height = rand.method_43051(2, 4);
        class_2680 block = SFBlocks.ALGAE_COBBLESTONE.method_9564();
        class_2680 block2 = SFBlocks.ALGAE_BLOCK.method_9564();
        class_2680 block3 = class_2246.field_10445.method_9564();
        class_2680 block4 = class_2246.field_10102.method_9564();
        origin = origin.method_10069(0, 0, 0);
        for (int x = -radius; x < radius; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    class_2338 pos = origin.method_10069(x, y, z);
                    class_2338 pos2 = origin.method_10069(x, -y, z);
                    double distance = AlgaeBoulderFeature.distance(x, y, z, radius, height, radius);
                    float f = noise.GetNoise(x, y, z);
                    if (!(distance < 1.0)) continue;
                    if ((double)f < 0.3 && (double)f >= -0.5) {
                        worldgenlevel.method_8652(pos, block, 3);
                        worldgenlevel.method_8652(pos2, block, 3);
                        continue;
                    }
                    if ((double)f >= 0.3 && (double)f < 0.5) {
                        worldgenlevel.method_8652(pos, block2, 3);
                        worldgenlevel.method_8652(pos2, block2, 3);
                        continue;
                    }
                    if ((double)f >= 0.2 && (double)f < 0.4) {
                        worldgenlevel.method_8652(pos, block3, 3);
                        worldgenlevel.method_8652(pos2, block3, 3);
                        continue;
                    }
                    if (!((double)f >= 0.7) || !((double)f < 0.9)) continue;
                    worldgenlevel.method_8652(pos, block4, 3);
                    worldgenlevel.method_8652(pos2, block4, 3);
                }
            }
        }
    }

    public static void addBushes(class_5281 worldgenlevel, class_5819 rand, class_2338 origin, FastNoiseLite noise, int radius) {
        class_2680 block = SFBlocks.ALGAE_PLANT.method_9564();
        class_2680 block2 = (class_2680)SFBlocks.ALGAE_CARPET.method_9564().method_11657((class_2769)class_5778.method_33374((class_2350)class_2350.field_11033), (Comparable)Boolean.valueOf(true));
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                boolean isCorrectBlock;
                class_2338 pos = origin.method_10069(x, 0, z);
                double yHeight = worldgenlevel.method_8624(class_2902.class_2903.field_13195, pos.method_10263(), pos.method_10260());
                class_2338 pos2 = class_2338.method_49637((double)pos.method_10263(), (double)yHeight, (double)pos.method_10260());
                double distance = AlgaeBoulderFeature.distance(x, 0.0, z, radius, 1.0, radius);
                float f = noise.GetNoise(x, (float)yHeight, z);
                if (!(distance < 1.0)) continue;
                boolean bl = isCorrectBlock = worldgenlevel.method_8320(pos2).method_27852(class_2246.field_10124) || !worldgenlevel.method_8316(pos2).method_15769() || worldgenlevel.method_8320(pos2.method_10074()).method_26164(class_3481.field_25806) || worldgenlevel.method_8320(pos2.method_10074()).method_27852(SFBlocks.ALGAE_COBBLESTONE);
                if (f > 0.0f && (double)f < 0.5 && isCorrectBlock) {
                    block = (class_2680)block.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(worldgenlevel.method_8316(pos2).method_39360((class_3611)class_3612.field_15910)));
                    worldgenlevel.method_8652(pos2, block, 3);
                }
                if (!((double)f >= 0.5) || !(f < 1.0f) || !isCorrectBlock) continue;
                block2 = (class_2680)block2.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(worldgenlevel.method_8316(pos2).method_39360((class_3611)class_3612.field_15910)));
                worldgenlevel.method_8652(pos2, block2, 3);
            }
        }
    }

    public static void changeTerrain(class_5281 worldgenlevel, class_5819 rand, class_2338 origin, FastNoiseLite noise, int radius) {
        class_2680 block = SFBlocks.GRAVELY_SAND.method_9564();
        class_2680 block2 = SFBlocks.ROCKY_SAND.method_9564();
        class_2680 block3 = class_2246.field_10253.method_9564();
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                boolean isCorrectBlock;
                class_2338 pos = origin.method_10069(x, 0, z);
                double yHeight = worldgenlevel.method_8624(class_2902.class_2903.field_13195, pos.method_10263(), pos.method_10260()) - 1;
                class_2338 pos2 = class_2338.method_49637((double)pos.method_10263(), (double)yHeight, (double)pos.method_10260());
                double distance = AlgaeBoulderFeature.distance(x, 0.0, z, radius, 1.0, radius);
                float f = noise.GetNoise(x, (float)yHeight, z);
                if (!(distance < 1.0)) continue;
                boolean bl = isCorrectBlock = worldgenlevel.method_8320(pos2).method_26164(class_3481.field_29822) || worldgenlevel.method_8320(pos2).method_26164(class_3481.field_15466) || worldgenlevel.method_8320(pos2).method_27852(class_2246.field_10255);
                if (f < 0.0f && (double)f >= -0.4 && isCorrectBlock) {
                    worldgenlevel.method_8652(pos2, block, 3);
                    continue;
                }
                if (!(f > 0.0f) || !((double)f < 0.2) || !isCorrectBlock) continue;
                worldgenlevel.method_8652(pos2, block2, 3);
            }
        }
    }

    public static double distance(double x, double y, double z, double xRadius, double yRadius, double zRadius) {
        return class_3532.method_33723((double)(x / xRadius)) + class_3532.method_33723((double)(y / yRadius)) + class_3532.method_33723((double)(z / zRadius));
    }

    private static FastNoiseLite createNoise(long seed, float frequency) {
        FastNoiseLite noise = new FastNoiseLite((int)seed);
        noise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2S);
        noise.SetFrequency(frequency);
        return noise;
    }
}

