/*
 * Decompiled with CFR 0.152.
 */
package dev.eyw.ai;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.eyw.ai.AIConfig;
import dev.eyw.ai.AIProvider;
import dev.eyw.lang.Language;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;

public class AIClient {
    private static final Gson gson = new Gson();

    public static CompletableFuture<String> sendMessage(String message, AIProvider provider) {
        return CompletableFuture.supplyAsync(() -> {
            String apiKey = AIConfig.getInstance().getApiKey(provider);
            if (apiKey == null || apiKey.isEmpty()) {
                return Language.format("ai.api.no_key", provider.getDisplayName());
            }
            JsonObject requestBody = AIClient.createRequestBody(message, provider);
            String jsonString = requestBody.toString();
            URL url = provider == AIProvider.GEMINI ? new URL(provider.getApiUrl() + "?key=" + apiKey) : new URL(provider.getApiUrl());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            if (provider != AIProvider.GEMINI) {
                connection.setRequestProperty("Authorization", AIClient.getAuthHeader(provider, apiKey));
                if (provider == AIProvider.CLAUDE) {
                    connection.setRequestProperty("anthropic-version", "2023-06-01");
                }
            }
            connection.setDoOutput(true);
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonString.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                return Language.format("ai.api.response_error", responseCode, connection.getResponseMessage());
            }
            Scanner scanner = new Scanner(connection.getInputStream(), StandardCharsets.UTF_8);
            try {
                scanner.useDelimiter("\\A");
                String responseBody = scanner.hasNext() ? scanner.next() : "";
                String string = AIClient.parseResponse(responseBody, provider);
                scanner.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Language.format("ai.api.connection_error", e.getMessage());
                }
            }
        });
    }

    private static JsonObject createRequestBody(String message, AIProvider provider) {
        JsonObject requestBody = new JsonObject();
        switch (provider) {
            case CHATGPT: 
            case DEEPSEEK: 
            case FREE: {
                requestBody.addProperty("model", AIClient.getModel(provider));
                JsonArray messages = new JsonArray();
                JsonObject userMessage = new JsonObject();
                userMessage.addProperty("role", "user");
                userMessage.addProperty("content", message);
                messages.add((JsonElement)userMessage);
                requestBody.add("messages", (JsonElement)messages);
                requestBody.addProperty("max_tokens", (Number)1000);
                break;
            }
            case GEMINI: {
                JsonObject contents = new JsonObject();
                JsonArray parts = new JsonArray();
                JsonObject part = new JsonObject();
                part.addProperty("text", message);
                parts.add((JsonElement)part);
                contents.add("parts", (JsonElement)parts);
                JsonArray contentsArray = new JsonArray();
                contentsArray.add((JsonElement)contents);
                requestBody.add("contents", (JsonElement)contentsArray);
                break;
            }
            case CLAUDE: {
                requestBody.addProperty("model", "claude-3-5-sonnet-20241022");
                requestBody.addProperty("max_tokens", (Number)1000);
                JsonArray claudeMessages = new JsonArray();
                JsonObject claudeMessage = new JsonObject();
                claudeMessage.addProperty("role", "user");
                claudeMessage.addProperty("content", message);
                claudeMessages.add((JsonElement)claudeMessage);
                requestBody.add("messages", (JsonElement)claudeMessages);
            }
        }
        return requestBody;
    }

    private static String getModel(AIProvider provider) {
        switch (provider) {
            case CHATGPT: {
                return "gpt-3.5-turbo";
            }
            case DEEPSEEK: {
                return "deepseek-chat";
            }
            case FREE: {
                return "llama3-8b-8192";
            }
        }
        return "gpt-3.5-turbo";
    }

    private static String getAuthHeader(AIProvider provider, String apiKey) {
        switch (provider) {
            case CLAUDE: {
                return "Bearer " + apiKey;
            }
            case GEMINI: {
                return "Bearer " + apiKey;
            }
        }
        return "Bearer " + apiKey;
    }

    private static String parseResponse(String responseBody, AIProvider provider) {
        try {
            JsonObject response = (JsonObject)gson.fromJson(responseBody, JsonObject.class);
            switch (provider) {
                case CHATGPT: 
                case DEEPSEEK: 
                case FREE: {
                    JsonArray choices;
                    if (!response.has("choices") || (choices = response.getAsJsonArray("choices")).size() <= 0) break;
                    JsonObject choice = choices.get(0).getAsJsonObject();
                    JsonObject message = choice.getAsJsonObject("message");
                    return message.get("content").getAsString();
                }
                case GEMINI: {
                    JsonObject candidate;
                    JsonObject content;
                    JsonArray parts;
                    JsonArray candidates;
                    if (!response.has("candidates") || (candidates = response.getAsJsonArray("candidates")).size() <= 0 || (parts = (content = (candidate = candidates.get(0).getAsJsonObject()).getAsJsonObject("content")).getAsJsonArray("parts")).size() <= 0) break;
                    return parts.get(0).getAsJsonObject().get("text").getAsString();
                }
                case CLAUDE: {
                    JsonArray content;
                    if (!response.has("content") || (content = response.getAsJsonArray("content")).size() <= 0) break;
                    return content.get(0).getAsJsonObject().get("text").getAsString();
                }
            }
            return Language.translate("ai.api.parse_failed");
        }
        catch (Exception e) {
            return Language.format("ai.api.parse_error", e.getMessage());
        }
    }
}

