/*
 * Decompiled with CFR 0.152.
 */
package dev.eyw.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.eyw.ai.AIClient;
import dev.eyw.ai.AIConfig;
import dev.eyw.ai.AIProvider;
import dev.eyw.lang.Language;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class AICommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ai").then(class_2170.method_9247((String)"chatgpt").then(class_2170.method_9244((String)"apikey", (ArgumentType)StringArgumentType.greedyString()).executes(context -> AICommand.setApiKey((CommandContext<class_2168>)context, AIProvider.CHATGPT))))).then(class_2170.method_9247((String)"deepseek").then(class_2170.method_9244((String)"apikey", (ArgumentType)StringArgumentType.greedyString()).executes(context -> AICommand.setApiKey((CommandContext<class_2168>)context, AIProvider.DEEPSEEK))))).then(class_2170.method_9247((String)"gemini").then(class_2170.method_9244((String)"apikey", (ArgumentType)StringArgumentType.greedyString()).executes(context -> AICommand.setApiKey((CommandContext<class_2168>)context, AIProvider.GEMINI))))).then(class_2170.method_9247((String)"claude").then(class_2170.method_9244((String)"apikey", (ArgumentType)StringArgumentType.greedyString()).executes(context -> AICommand.setApiKey((CommandContext<class_2168>)context, AIProvider.CLAUDE))))).then(class_2170.method_9247((String)"help").executes(AICommand::showHelp))).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(AICommand::executeChat)));
    }

    private static int executeChat(CommandContext<class_2168> context) {
        String message = StringArgumentType.getString(context, (String)"message");
        class_2168 source = (class_2168)context.getSource();
        AIProvider provider = AIConfig.getInstance().getDefaultProvider();
        source.method_9226(() -> class_2561.method_43470((String)Language.translate("ai.command.sending")), false);
        ((CompletableFuture)AIClient.sendMessage(message, provider).thenAccept(response -> source.method_9226(() -> class_2561.method_43470((String)("\u00a7b[" + provider.getDisplayName() + "] \u00a7f" + response)), false))).exceptionally(throwable -> {
            source.method_9226(() -> class_2561.method_43470((String)(Language.translate("ai.command.error") + throwable.getMessage())), false);
            return null;
        });
        return 1;
    }

    private static int setApiKey(CommandContext<class_2168> context, AIProvider provider) {
        String apiKey = StringArgumentType.getString(context, (String)"apikey");
        class_2168 source = (class_2168)context.getSource();
        AIConfig.getInstance().setApiKey(provider, apiKey);
        AIConfig.getInstance().setDefaultProvider(provider);
        source.method_9226(() -> class_2561.method_43470((String)Language.format("ai.command.api_set", provider.getDisplayName())), false);
        return 1;
    }

    private static int showHelp(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)Language.translate("ai.command.help.title")), false);
        source.method_9226(() -> class_2561.method_43470((String)Language.translate("ai.command.help.chat")), false);
        source.method_9226(() -> class_2561.method_43470((String)Language.translate("ai.command.help.chatgpt")), false);
        source.method_9226(() -> class_2561.method_43470((String)Language.translate("ai.command.help.deepseek")), false);
        source.method_9226(() -> class_2561.method_43470((String)Language.translate("ai.command.help.gemini")), false);
        source.method_9226(() -> class_2561.method_43470((String)Language.translate("ai.command.help.claude")), false);
        source.method_9226(() -> class_2561.method_43470((String)Language.translate("ai.command.help.help")), false);
        source.method_9226(() -> class_2561.method_43470((String)Language.translate("ai.command.help.footer")), false);
        return 1;
    }
}

