/*
 * Decompiled with CFR 0.152.
 */
package dev.eyw.lang;

import java.util.HashMap;
import java.util.Map;

public class Language {
    private static final Map<String, Map<String, String>> translations = new HashMap<String, Map<String, String>>();
    private static String currentLanguage;

    public static String translate(String key) {
        String currentLang = Language.getCurrentLanguage();
        Map<String, String> langMap = translations.get(currentLang);
        if (langMap != null && langMap.containsKey(key)) {
            return langMap.get(key);
        }
        Map<String, String> englishMap = translations.get("en_us");
        if (englishMap != null && englishMap.containsKey(key)) {
            return englishMap.get(key);
        }
        return key;
    }

    public static void setLanguage(String language) {
        currentLanguage = language;
    }

    private static String getCurrentLanguage() {
        try {
            String lang;
            Object languageManager;
            Class<?> clientClass = Class.forName("net.minecraft.client.MinecraftClient");
            Object client = clientClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            if (client != null && (languageManager = clientClass.getMethod("getLanguageManager", new Class[0]).invoke(client, new Object[0])) != null && (lang = (String)languageManager.getClass().getMethod("getLanguage", new Class[0]).invoke(languageManager, new Object[0])) != null) {
                return lang;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return currentLanguage;
    }

    private static void loadTranslations() {
        HashMap<String, String> english = new HashMap<String, String>();
        english.put("ai.book.title", "AI Chat Helper");
        english.put("ai.book.author", "3yw_");
        english.put("ai.book.page1", "\u00a76\u00a7lAI Chat Helper\u00a7r\n\n\u00a70Author: \u00a713yw_\u00a7r\n\u00a70Version: \u00a711.0.0\u00a7r\n\n\u00a72Chat with AI in-game!\u00a7r\n\n\u00a70Check next pages for commands.");
        english.put("ai.book.page2", "\u00a76\u00a7lBasic Commands\u00a7r\n\n\u00a71/ai <message>\u00a7r\n\u00a70Chat with AI\u00a7r\n\n\u00a71/ai help\u00a7r\n\u00a70Show help menu\u00a7r\n\n\u00a70Free AI is used by default.\u00a7r");
        english.put("ai.book.page3", "\u00a76\u00a7lAPI Settings\u00a7r\n\n\u00a71/ai chatgpt <api_key>\u00a7r\n\u00a70ChatGPT API key\u00a7r\n\n\u00a71/ai deepseek <api_key>\u00a7r\n\u00a70DeepSeek API key\u00a7r\n\n\u00a71/ai gemini <api_key>\u00a7r\n\u00a70Gemini API key\u00a7r");
        english.put("ai.book.page4", "\u00a76\u00a7lMore APIs\u00a7r\n\n\u00a71/ai claude <api_key>\u00a7r\n\u00a70Claude API key\u00a7r\n\n\u00a70When you set an API key, that provider becomes default.\u00a7r\n\n\u00a72Have fun!\u00a7r");
        english.put("ai.command.sending", "\u00a77[AI] Sending message...");
        english.put("ai.command.error", "\u00a7c[Error] ");
        english.put("ai.command.api_set", "\u00a7a{0} API key set and selected as default provider!");
        english.put("ai.command.help.title", "\u00a76=== AI Chat Helper Commands ===");
        english.put("ai.command.help.chat", "\u00a7e/ai <message> \u00a77- Chat with AI");
        english.put("ai.command.help.chatgpt", "\u00a7e/ai chatgpt <api_key> \u00a77- Set ChatGPT API key");
        english.put("ai.command.help.deepseek", "\u00a7e/ai deepseek <api_key> \u00a77- Set DeepSeek API key");
        english.put("ai.command.help.gemini", "\u00a7e/ai gemini <api_key> \u00a77- Set Gemini API key");
        english.put("ai.command.help.claude", "\u00a7e/ai claude <api_key> \u00a77- Set Claude API key");
        english.put("ai.command.help.help", "\u00a7e/ai help \u00a77- Show this help menu");
        english.put("ai.command.help.footer", "\u00a77Author: \u00a763yw_ \u00a77| Version: \u00a761.0.0");
        english.put("ai.player.welcome", "\u00a7a[AI Chat Helper] \u00a77Welcome! Read your book to chat with AI.");
        english.put("ai.player.book_given", "\u00a7a[AI Chat Helper] \u00a77You received your book! Read it for commands.");
        english.put("ai.api.no_key", "API key not found: {0}");
        english.put("ai.api.connection_error", "Connection error: {0}");
        english.put("ai.api.response_error", "Error: {0} - {1}");
        english.put("ai.api.parse_error", "Response parsing error: {0}");
        english.put("ai.api.parse_failed", "Could not parse response");
        HashMap<String, String> turkish = new HashMap<String, String>();
        turkish.put("ai.book.title", "AI Sohbet Yard\u0131mc\u0131s\u0131");
        turkish.put("ai.book.author", "3yw_");
        turkish.put("ai.book.page1", "\u00a76\u00a7lAI Sohbet Yard\u0131mc\u0131s\u0131\u00a7r\n\n\u00a70Yap\u0131mc\u0131: \u00a713yw_\u00a7r\n\u00a70S\u00fcr\u00fcm: \u00a711.0.0\u00a7r\n\n\u00a72Oyun i\u00e7inde AI ile sohbet edin!\u00a7r\n\n\u00a70Komutlar i\u00e7in sonraki sayfalar\u0131 kontrol edin.");
        turkish.put("ai.book.page2", "\u00a76\u00a7lTemel Komutlar\u00a7r\n\n\u00a71/ai <mesaj>\u00a7r\n\u00a70AI ile sohbet et\u00a7r\n\n\u00a71/ai help\u00a7r\n\u00a70Yard\u0131m men\u00fcs\u00fcn\u00fc g\u00f6ster\u00a7r\n\n\u00a70Varsay\u0131lan olarak \u00fccretsiz AI kullan\u0131l\u0131r.\u00a7r");
        turkish.put("ai.book.page3", "\u00a76\u00a7lAPI Ayarlar\u0131\u00a7r\n\n\u00a71/ai chatgpt <api_key>\u00a7r\n\u00a70ChatGPT API anahtar\u0131\u00a7r\n\n\u00a71/ai deepseek <api_key>\u00a7r\n\u00a70DeepSeek API anahtar\u0131\u00a7r\n\n\u00a71/ai gemini <api_key>\u00a7r\n\u00a70Gemini API anahtar\u0131\u00a7r");
        turkish.put("ai.book.page4", "\u00a76\u00a7lDaha Fazla API\u00a7r\n\n\u00a71/ai claude <api_key>\u00a7r\n\u00a70Claude API anahtar\u0131\u00a7r\n\n\u00a70API anahtar\u0131 ayarlad\u0131\u011f\u0131n\u0131zda, o sa\u011flay\u0131c\u0131 varsay\u0131lan olur.\u00a7r\n\n\u00a72\u0130yi e\u011flenceler!\u00a7r");
        turkish.put("ai.command.sending", "\u00a77[AI] Mesaj g\u00f6nderiliyor...");
        turkish.put("ai.command.error", "\u00a7c[Hata] ");
        turkish.put("ai.command.api_set", "\u00a7a{0} API anahtar\u0131 ayarland\u0131 ve varsay\u0131lan sa\u011flay\u0131c\u0131 olarak se\u00e7ildi!");
        turkish.put("ai.command.help.title", "\u00a76=== AI Sohbet Yard\u0131mc\u0131s\u0131 Komutlar\u0131 ===");
        turkish.put("ai.command.help.chat", "\u00a7e/ai <mesaj> \u00a77- AI ile sohbet et");
        turkish.put("ai.command.help.chatgpt", "\u00a7e/ai chatgpt <api_key> \u00a77- ChatGPT API anahtar\u0131n\u0131 ayarla");
        turkish.put("ai.command.help.deepseek", "\u00a7e/ai deepseek <api_key> \u00a77- DeepSeek API anahtar\u0131n\u0131 ayarla");
        turkish.put("ai.command.help.gemini", "\u00a7e/ai gemini <api_key> \u00a77- Gemini API anahtar\u0131n\u0131 ayarla");
        turkish.put("ai.command.help.claude", "\u00a7e/ai claude <api_key> \u00a77- Claude API anahtar\u0131n\u0131 ayarla");
        turkish.put("ai.command.help.help", "\u00a7e/ai help \u00a77- Bu yard\u0131m men\u00fcs\u00fcn\u00fc g\u00f6ster");
        turkish.put("ai.command.help.footer", "\u00a77Yap\u0131mc\u0131: \u00a763yw_ \u00a77| S\u00fcr\u00fcm: \u00a761.0.0");
        turkish.put("ai.player.welcome", "\u00a7a[AI Sohbet Yard\u0131mc\u0131s\u0131] \u00a77Ho\u015fgeldiniz! AI ile sohbet etmek i\u00e7in kitab\u0131n\u0131z\u0131 okuyun.");
        turkish.put("ai.player.book_given", "\u00a7a[AI Sohbet Yard\u0131mc\u0131s\u0131] \u00a77Kitab\u0131n\u0131z\u0131 ald\u0131n\u0131z! Komutlar i\u00e7in okuyun.");
        turkish.put("ai.api.no_key", "API anahtar\u0131 bulunamad\u0131: {0}");
        turkish.put("ai.api.connection_error", "Ba\u011flant\u0131 hatas\u0131: {0}");
        turkish.put("ai.api.response_error", "Hata: {0} - {1}");
        turkish.put("ai.api.parse_error", "Yan\u0131t ayr\u0131\u015ft\u0131rma hatas\u0131: {0}");
        turkish.put("ai.api.parse_failed", "Yan\u0131t ayr\u0131\u015ft\u0131r\u0131lamad\u0131");
        HashMap<String, String> russian = new HashMap<String, String>();
        russian.put("ai.book.title", "AI \u0427\u0430\u0442 \u041f\u043e\u043c\u043e\u0449\u043d\u0438\u043a");
        russian.put("ai.book.author", "3yw_");
        russian.put("ai.book.page1", "\u00a76\u00a7lAI \u0427\u0430\u0442 \u041f\u043e\u043c\u043e\u0449\u043d\u0438\u043a\u00a7r\n\n\u00a70\u0410\u0432\u0442\u043e\u0440: \u00a713yw_\u00a7r\n\u00a70\u0412\u0435\u0440\u0441\u0438\u044f: \u00a711.0.0\u00a7r\n\n\u00a72\u0427\u0430\u0442 \u0441 \u0418\u0418 \u0432 \u0438\u0433\u0440\u0435!\u00a7r\n\n\u00a70\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u0434\u043b\u044f \u043a\u043e\u043c\u0430\u043d\u0434.");
        russian.put("ai.book.page2", "\u00a76\u00a7l\u041e\u0441\u043d\u043e\u0432\u043d\u044b\u0435 \u041a\u043e\u043c\u0430\u043d\u0434\u044b\u00a7r\n\n\u00a71/ai <\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435>\u00a7r\n\u00a70\u0427\u0430\u0442 \u0441 \u0418\u0418\u00a7r\n\n\u00a71/ai help\u00a7r\n\u00a70\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043c\u0435\u043d\u044e \u043f\u043e\u043c\u043e\u0449\u0438\u00a7r\n\n\u00a70\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0431\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u044b\u0439 \u0418\u0418.\u00a7r");
        russian.put("ai.book.page3", "\u00a76\u00a7l\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 API\u00a7r\n\n\u00a71/ai chatgpt <api_key>\u00a7r\n\u00a70ChatGPT API \u043a\u043b\u044e\u0447\u00a7r\n\n\u00a71/ai deepseek <api_key>\u00a7r\n\u00a70DeepSeek API \u043a\u043b\u044e\u0447\u00a7r\n\n\u00a71/ai gemini <api_key>\u00a7r\n\u00a70Gemini API \u043a\u043b\u044e\u0447\u00a7r");
        russian.put("ai.book.page4", "\u00a76\u00a7l\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 API\u00a7r\n\n\u00a71/ai claude <api_key>\u00a7r\n\u00a70Claude API \u043a\u043b\u044e\u0447\u00a7r\n\n\u00a70\u041a\u043e\u0433\u0434\u0430 \u0432\u044b \u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442\u0435 API \u043a\u043b\u044e\u0447, \u044d\u0442\u043e\u0442 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0441\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e.\u00a7r\n\n\u00a72\u0423\u0434\u0430\u0447\u0438!\u00a7r");
        russian.put("ai.command.sending", "\u00a77[AI] \u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f...");
        russian.put("ai.command.error", "\u00a7c[\u041e\u0448\u0438\u0431\u043a\u0430] ");
        russian.put("ai.command.api_set", "\u00a7a{0} API \u043a\u043b\u044e\u0447 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0438 \u0432\u044b\u0431\u0440\u0430\u043d \u043a\u0430\u043a \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e!");
        russian.put("ai.command.help.title", "\u00a76=== \u041a\u043e\u043c\u0430\u043d\u0434\u044b AI \u0427\u0430\u0442 \u041f\u043e\u043c\u043e\u0449\u043d\u0438\u043a\u0430 ===");
        russian.put("ai.command.help.chat", "\u00a7e/ai <\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435> \u00a77- \u0427\u0430\u0442 \u0441 \u0418\u0418");
        russian.put("ai.command.help.chatgpt", "\u00a7e/ai chatgpt <api_key> \u00a77- \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c ChatGPT API \u043a\u043b\u044e\u0447");
        russian.put("ai.command.help.deepseek", "\u00a7e/ai deepseek <api_key> \u00a77- \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c DeepSeek API \u043a\u043b\u044e\u0447");
        russian.put("ai.command.help.gemini", "\u00a7e/ai gemini <api_key> \u00a77- \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c Gemini API \u043a\u043b\u044e\u0447");
        russian.put("ai.command.help.claude", "\u00a7e/ai claude <api_key> \u00a77- \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c Claude API \u043a\u043b\u044e\u0447");
        russian.put("ai.command.help.help", "\u00a7e/ai help \u00a77- \u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u044d\u0442\u043e \u043c\u0435\u043d\u044e \u043f\u043e\u043c\u043e\u0449\u0438");
        russian.put("ai.command.help.footer", "\u00a77\u0410\u0432\u0442\u043e\u0440: \u00a763yw_ \u00a77| \u0412\u0435\u0440\u0441\u0438\u044f: \u00a761.0.0");
        russian.put("ai.player.welcome", "\u00a7a[AI \u0427\u0430\u0442 \u041f\u043e\u043c\u043e\u0449\u043d\u0438\u043a] \u00a77\u0414\u043e\u0431\u0440\u043e \u043f\u043e\u0436\u0430\u043b\u043e\u0432\u0430\u0442\u044c! \u041f\u0440\u043e\u0447\u0438\u0442\u0430\u0439\u0442\u0435 \u0441\u0432\u043e\u044e \u043a\u043d\u0438\u0433\u0443 \u0434\u043b\u044f \u0447\u0430\u0442\u0430 \u0441 \u0418\u0418.");
        russian.put("ai.player.book_given", "\u00a7a[AI \u0427\u0430\u0442 \u041f\u043e\u043c\u043e\u0449\u043d\u0438\u043a] \u00a77\u0412\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 \u0441\u0432\u043e\u044e \u043a\u043d\u0438\u0433\u0443! \u041f\u0440\u043e\u0447\u0438\u0442\u0430\u0439\u0442\u0435 \u0435\u0451 \u0434\u043b\u044f \u043a\u043e\u043c\u0430\u043d\u0434.");
        russian.put("ai.api.no_key", "API \u043a\u043b\u044e\u0447 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: {0}");
        russian.put("ai.api.connection_error", "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f: {0}");
        russian.put("ai.api.response_error", "\u041e\u0448\u0438\u0431\u043a\u0430: {0} - {1}");
        russian.put("ai.api.parse_error", "\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u043e\u0442\u0432\u0435\u0442\u0430: {0}");
        russian.put("ai.api.parse_failed", "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442");
        HashMap<String, String> german = new HashMap<String, String>();
        german.put("ai.book.title", "AI Chat Helfer");
        german.put("ai.book.author", "3yw_");
        german.put("ai.book.page1", "\u00a76\u00a7lAI Chat Helfer\u00a7r\n\n\u00a70Autor: \u00a713yw_\u00a7r\n\u00a70Version: \u00a711.0.0\u00a7r\n\n\u00a72Chatten Sie mit AI im Spiel!\u00a7r\n\n\u00a70\u00dcberpr\u00fcfen Sie die n\u00e4chsten Seiten f\u00fcr Befehle.");
        german.put("ai.book.page2", "\u00a76\u00a7lGrundbefehle\u00a7r\n\n\u00a71/ai <nachricht>\u00a7r\n\u00a70Chat mit AI\u00a7r\n\n\u00a71/ai help\u00a7r\n\u00a70Hilfemen\u00fc anzeigen\u00a7r\n\n\u00a70Standardm\u00e4\u00dfig wird kostenlose AI verwendet.\u00a7r");
        german.put("ai.book.page3", "\u00a76\u00a7lAPI Einstellungen\u00a7r\n\n\u00a71/ai chatgpt <api_key>\u00a7r\n\u00a70ChatGPT API Schl\u00fcssel\u00a7r\n\n\u00a71/ai deepseek <api_key>\u00a7r\n\u00a70DeepSeek API Schl\u00fcssel\u00a7r\n\n\u00a71/ai gemini <api_key>\u00a7r\n\u00a70Gemini API Schl\u00fcssel\u00a7r");
        german.put("ai.book.page4", "\u00a76\u00a7lWeitere APIs\u00a7r\n\n\u00a71/ai claude <api_key>\u00a7r\n\u00a70Claude API Schl\u00fcssel\u00a7r\n\n\u00a70Wenn Sie einen API-Schl\u00fcssel setzen, wird dieser Anbieter zum Standard.\u00a7r\n\n\u00a72Viel Spa\u00df!\u00a7r");
        german.put("ai.command.sending", "\u00a77[AI] Nachricht wird gesendet...");
        german.put("ai.command.error", "\u00a7c[Fehler] ");
        german.put("ai.command.api_set", "\u00a7a{0} API Schl\u00fcssel gesetzt und als Standard-Anbieter ausgew\u00e4hlt!");
        german.put("ai.command.help.title", "\u00a76=== AI Chat Helfer Befehle ===");
        german.put("ai.command.help.chat", "\u00a7e/ai <nachricht> \u00a77- Chat mit AI");
        german.put("ai.command.help.chatgpt", "\u00a7e/ai chatgpt <api_key> \u00a77- ChatGPT API Schl\u00fcssel setzen");
        german.put("ai.command.help.deepseek", "\u00a7e/ai deepseek <api_key> \u00a77- DeepSeek API Schl\u00fcssel setzen");
        german.put("ai.command.help.gemini", "\u00a7e/ai gemini <api_key> \u00a77- Gemini API Schl\u00fcssel setzen");
        german.put("ai.command.help.claude", "\u00a7e/ai claude <api_key> \u00a77- Claude API Schl\u00fcssel setzen");
        german.put("ai.command.help.help", "\u00a7e/ai help \u00a77- Dieses Hilfemen\u00fc anzeigen");
        german.put("ai.command.help.footer", "\u00a77Autor: \u00a763yw_ \u00a77| Version: \u00a761.0.0");
        german.put("ai.player.welcome", "\u00a7a[AI Chat Helfer] \u00a77Willkommen! Lesen Sie Ihr Buch, um mit AI zu chatten.");
        german.put("ai.player.book_given", "\u00a7a[AI Chat Helfer] \u00a77Sie haben Ihr Buch erhalten! Lesen Sie es f\u00fcr Befehle.");
        german.put("ai.api.no_key", "API Schl\u00fcssel nicht gefunden: {0}");
        german.put("ai.api.connection_error", "Verbindungsfehler: {0}");
        german.put("ai.api.response_error", "Fehler: {0} - {1}");
        german.put("ai.api.parse_error", "Antwort-Parsing-Fehler: {0}");
        german.put("ai.api.parse_failed", "Antwort konnte nicht geparst werden");
        HashMap<String, String> french = new HashMap<String, String>();
        french.put("ai.book.title", "Assistant Chat IA");
        french.put("ai.book.author", "3yw_");
        french.put("ai.book.page1", "\u00a76\u00a7lAssistant Chat IA\u00a7r\n\n\u00a70Auteur: \u00a713yw_\u00a7r\n\u00a70Version: \u00a711.0.0\u00a7r\n\n\u00a72Chattez avec l'IA dans le jeu!\u00a7r\n\n\u00a70V\u00e9rifiez les pages suivantes pour les commandes.");
        french.put("ai.book.page2", "\u00a76\u00a7lCommandes de Base\u00a7r\n\n\u00a71/ai <message>\u00a7r\n\u00a70Chat avec IA\u00a7r\n\n\u00a71/ai help\u00a7r\n\u00a70Afficher le menu d'aide\u00a7r\n\n\u00a70L'IA gratuite est utilis\u00e9e par d\u00e9faut.\u00a7r");
        french.put("ai.book.page3", "\u00a76\u00a7lParam\u00e8tres API\u00a7r\n\n\u00a71/ai chatgpt <api_key>\u00a7r\n\u00a70Cl\u00e9 API ChatGPT\u00a7r\n\n\u00a71/ai deepseek <api_key>\u00a7r\n\u00a70Cl\u00e9 API DeepSeek\u00a7r\n\n\u00a71/ai gemini <api_key>\u00a7r\n\u00a70Cl\u00e9 API Gemini\u00a7r");
        french.put("ai.book.page4", "\u00a76\u00a7lPlus d'APIs\u00a7r\n\n\u00a71/ai claude <api_key>\u00a7r\n\u00a70Cl\u00e9 API Claude\u00a7r\n\n\u00a70Quand vous d\u00e9finissez une cl\u00e9 API, ce fournisseur devient par d\u00e9faut.\u00a7r\n\n\u00a72Amusez-vous bien!\u00a7r");
        french.put("ai.command.sending", "\u00a77[AI] Envoi du message...");
        french.put("ai.command.error", "\u00a7c[Erreur] ");
        french.put("ai.command.api_set", "\u00a7a{0} cl\u00e9 API d\u00e9finie et s\u00e9lectionn\u00e9e comme fournisseur par d\u00e9faut!");
        french.put("ai.command.help.title", "\u00a76=== Commandes Assistant Chat IA ===");
        french.put("ai.command.help.chat", "\u00a7e/ai <message> \u00a77- Chat avec IA");
        french.put("ai.command.help.chatgpt", "\u00a7e/ai chatgpt <api_key> \u00a77- D\u00e9finir la cl\u00e9 API ChatGPT");
        french.put("ai.command.help.deepseek", "\u00a7e/ai deepseek <api_key> \u00a77- D\u00e9finir la cl\u00e9 API DeepSeek");
        french.put("ai.command.help.gemini", "\u00a7e/ai gemini <api_key> \u00a77- D\u00e9finir la cl\u00e9 API Gemini");
        french.put("ai.command.help.claude", "\u00a7e/ai claude <api_key> \u00a77- D\u00e9finir la cl\u00e9 API Claude");
        french.put("ai.command.help.help", "\u00a7e/ai help \u00a77- Afficher ce menu d'aide");
        french.put("ai.command.help.footer", "\u00a77Auteur: \u00a763yw_ \u00a77| Version: \u00a761.0.0");
        french.put("ai.player.welcome", "\u00a7a[Assistant Chat IA] \u00a77Bienvenue! Lisez votre livre pour chatter avec l'IA.");
        french.put("ai.player.book_given", "\u00a7a[Assistant Chat IA] \u00a77Vous avez re\u00e7u votre livre! Lisez-le pour les commandes.");
        french.put("ai.api.no_key", "Cl\u00e9 API non trouv\u00e9e: {0}");
        french.put("ai.api.connection_error", "Erreur de connexion: {0}");
        french.put("ai.api.response_error", "Erreur: {0} - {1}");
        french.put("ai.api.parse_error", "Erreur d'analyse de r\u00e9ponse: {0}");
        french.put("ai.api.parse_failed", "Impossible d'analyser la r\u00e9ponse");
        HashMap<String, String> spanish = new HashMap<String, String>();
        spanish.put("ai.book.title", "Asistente Chat IA");
        spanish.put("ai.book.author", "3yw_");
        spanish.put("ai.book.page1", "\u00a76\u00a7lAsistente Chat IA\u00a7r\n\n\u00a70Autor: \u00a713yw_\u00a7r\n\u00a70Versi\u00f3n: \u00a711.0.0\u00a7r\n\n\u00a72\u00a1Chatea con IA en el juego!\u00a7r\n\n\u00a70Revisa las siguientes p\u00e1ginas para comandos.");
        spanish.put("ai.book.page2", "\u00a76\u00a7lComandos B\u00e1sicos\u00a7r\n\n\u00a71/ai <mensaje>\u00a7r\n\u00a70Chat con IA\u00a7r\n\n\u00a71/ai help\u00a7r\n\u00a70Mostrar men\u00fa de ayuda\u00a7r\n\n\u00a70Se usa IA gratuita por defecto.\u00a7r");
        spanish.put("ai.book.page3", "\u00a76\u00a7lConfiguraciones API\u00a7r\n\n\u00a71/ai chatgpt <api_key>\u00a7r\n\u00a70Clave API ChatGPT\u00a7r\n\n\u00a71/ai deepseek <api_key>\u00a7r\n\u00a70Clave API DeepSeek\u00a7r\n\n\u00a71/ai gemini <api_key>\u00a7r\n\u00a70Clave API Gemini\u00a7r");
        spanish.put("ai.book.page4", "\u00a76\u00a7lM\u00e1s APIs\u00a7r\n\n\u00a71/ai claude <api_key>\u00a7r\n\u00a70Clave API Claude\u00a7r\n\n\u00a70Cuando estableces una clave API, ese proveedor se vuelve predeterminado.\u00a7r\n\n\u00a72\u00a1Divi\u00e9rtete!\u00a7r");
        spanish.put("ai.command.sending", "\u00a77[AI] Enviando mensaje...");
        spanish.put("ai.command.error", "\u00a7c[Error] ");
        spanish.put("ai.command.api_set", "\u00a7a\u00a1{0} clave API establecida y seleccionada como proveedor predeterminado!");
        spanish.put("ai.command.help.title", "\u00a76=== Comandos Asistente Chat IA ===");
        spanish.put("ai.command.help.chat", "\u00a7e/ai <mensaje> \u00a77- Chat con IA");
        spanish.put("ai.command.help.chatgpt", "\u00a7e/ai chatgpt <api_key> \u00a77- Establecer clave API ChatGPT");
        spanish.put("ai.command.help.deepseek", "\u00a7e/ai deepseek <api_key> \u00a77- Establecer clave API DeepSeek");
        spanish.put("ai.command.help.gemini", "\u00a7e/ai gemini <api_key> \u00a77- Establecer clave API Gemini");
        spanish.put("ai.command.help.claude", "\u00a7e/ai claude <api_key> \u00a77- Establecer clave API Claude");
        spanish.put("ai.command.help.help", "\u00a7e/ai help \u00a77- Mostrar este men\u00fa de ayuda");
        spanish.put("ai.command.help.footer", "\u00a77Autor: \u00a763yw_ \u00a77| Versi\u00f3n: \u00a761.0.0");
        spanish.put("ai.player.welcome", "\u00a7a[Asistente Chat IA] \u00a77\u00a1Bienvenido! Lee tu libro para chatear con IA.");
        spanish.put("ai.player.book_given", "\u00a7a[Asistente Chat IA] \u00a77\u00a1Recibiste tu libro! L\u00e9elo para los comandos.");
        spanish.put("ai.api.no_key", "Clave API no encontrada: {0}");
        spanish.put("ai.api.connection_error", "Error de conexi\u00f3n: {0}");
        spanish.put("ai.api.response_error", "Error: {0} - {1}");
        spanish.put("ai.api.parse_error", "Error de an\u00e1lisis de respuesta: {0}");
        spanish.put("ai.api.parse_failed", "No se pudo analizar la respuesta");
        translations.put("en_us", english);
        translations.put("tr_tr", turkish);
        translations.put("ru_ru", russian);
        translations.put("de_de", german);
        translations.put("fr_fr", french);
        translations.put("es_es", spanish);
    }

    public static String format(String key, Object ... args) {
        String translated = Language.translate(key);
        for (int i = 0; i < args.length; ++i) {
            translated = translated.replace("{" + i + "}", args[i].toString());
        }
        return translated;
    }

    static {
        Language.loadTranslations();
        currentLanguage = "en_us";
    }
}

