/*
 * Decompiled with CFR 0.152.
 */
package net.pmkjun.mineplanetplus.dungeonhelper;

import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.pmkjun.mineplanetplus.dungeonhelper.file.Data;
import net.pmkjun.mineplanetplus.dungeonhelper.file.Settings;
import net.pmkjun.mineplanetplus.dungeonhelper.gui.DungeonCooltimeGui;
import net.pmkjun.mineplanetplus.dungeonhelper.gui.SkillCooltimeGui;
import net.pmkjun.mineplanetplus.dungeonhelper.gui.screen.DungeonHelperSettingsScreen;
import net.pmkjun.mineplanetplus.dungeonhelper.util.Timer;
import net.pmkjun.mineplanetplus.input.IKeyMappings;

public class DungeonHelperClient {
    private static DungeonHelperClient instance;
    private final IKeyMappings keyMappings;
    public Settings settings;
    public Data data;
    private final DungeonCooltimeGui dungeonCooltimeGui;
    private final SkillCooltimeGui skillCooltimeGui;
    private final DungeonHelperSettingsScreen settingsScreen;
    private final Timer timer = new Timer();
    public boolean ishereDungeon = false;

    public DungeonHelperClient(IKeyMappings keyMappings) {
        this.keyMappings = keyMappings;
        instance = this;
        this.settings = new Settings();
        this.data = this.settings.load();
        if (this.data == null || this.data.lastDungeonTime.length != 8) {
            this.data = new Data();
            this.settings.save();
        }
        this.dungeonCooltimeGui = new DungeonCooltimeGui();
        this.skillCooltimeGui = new SkillCooltimeGui();
        this.settingsScreen = new DungeonHelperSettingsScreen();
    }

    public void init() {
    }

    public void renderEvent(class_332 guiGraphics, class_2561 title, class_2561 message) {
        this.dungeonCooltimeGui.renderTick(guiGraphics, title, this.timer);
        this.skillCooltimeGui.renderTick(guiGraphics, this.timer);
        this.timer.updateTime();
    }

    public void updateLastComboSkillTime() {
        this.skillCooltimeGui.updateLastComboSkillTime(this.timer);
    }

    public void updateLastLV30SkillTime() {
        this.skillCooltimeGui.updateLastLV30SkillTime(this.timer);
    }

    public void updateLastLV30SkillTime(float plustime) {
        long plustimeLong = (long)(plustime * 1000.0f);
        this.skillCooltimeGui.updateLastLV30SkillTime(this.timer, plustimeLong);
    }

    public void updateLastLV40SkillTime() {
        this.skillCooltimeGui.updateLastLV40SkillTime(this.timer);
    }

    public void updateLastLV40SkillTime(float plustime) {
        long plustimeLong = (long)(plustime * 1000.0f);
        this.skillCooltimeGui.updateLastLV40SkillTime(this.timer, plustimeLong);
    }

    public void updateLastUltimateTime() {
        this.skillCooltimeGui.updateLastUltimateTime(this.timer);
    }

    public void resetLastComboSkillTime() {
        this.skillCooltimeGui.resetLastComboSkillTime();
    }

    public DungeonHelperSettingsScreen getSettingsScreen() {
        return this.settingsScreen;
    }

    public void delayLastSkilltime(long delay) {
        this.skillCooltimeGui.delayLastSkilltime(delay);
    }

    public static DungeonHelperClient getInstance() {
        return instance;
    }
}

