/*
 * Decompiled with CFR 0.152.
 */
package net.pmkjun.mineplanetplus.dungeonhelper.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.pmkjun.mineplanetplus.dungeonhelper.DungeonHelperClient;
import net.pmkjun.mineplanetplus.dungeonhelper.util.DungeonCategory;
import net.pmkjun.mineplanetplus.dungeonhelper.util.DungeonCoolAxis;
import net.pmkjun.mineplanetplus.dungeonhelper.util.Timer;

public class DungeonCooltimeGui {
    private final class_310 mc = class_310.method_1551();
    private final DungeonHelperClient client = DungeonHelperClient.getInstance();
    public static final int DUNGEON_COUNT = 8;
    private static final class_2960[] DUNGEON_ICONS = new class_2960[]{class_2960.method_60655((String)"dungeonhelper", (String)"textures/icon/dungeon/one_dungeon_icon.png"), class_2960.method_60655((String)"dungeonhelper", (String)"textures/icon/dungeon/two_dungeon_icon.png"), class_2960.method_60655((String)"dungeonhelper", (String)"textures/icon/dungeon/three_dungeon_icon.png"), class_2960.method_60655((String)"dungeonhelper", (String)"textures/icon/dungeon/four_dungeon_icon.png"), class_2960.method_60655((String)"dungeonhelper", (String)"textures/icon/dungeon/n_one_dungeon_icon.png"), class_2960.method_60655((String)"dungeonhelper", (String)"textures/icon/dungeon/n_two_dungeon_icon.png"), class_2960.method_60655((String)"dungeonhelper", (String)"textures/icon/dungeon/n_three_dungeon_icon.png"), class_2960.method_60655((String)"dungeonhelper", (String)"textures/icon/dungeon/n_four_dungeon_icon.png")};
    private static final String[] DUNGEON_NAMES = new String[]{"\uadf8\ub8e8\ud2b8\uc758 \uace8\uc9dc\uae30", "\ub9dd\ub839\uc758 \ubb34\ub364", "\ud639\ud55c\uc758 \uc131\uc5ed", "\uad70\ub2e8\uc7a5\uc758 \uc694\uc0c8", "\ub9dd\uc790\uc758 \ubb18\uc9c0", "\uace0\ube14\ub9b0\uc758 \uc694\uc0c8", "\ub9c8\ucc9c\ub8e8 : \ub124\uc628\uc2dc\ud2f0", "\ud5e4\ub7f4\ub4dc\uc758 \uc131\ucc44"};
    private static final class_2960 BLACK_ICON = class_2960.method_60655((String)"dungeonhelper", (String)"textures/icon/black.png");
    private class_2561 lastTitle = null;

    public void renderTick(class_332 guiGraphics, class_2561 title, Timer timer) {
        if (title != null) {
            block6: {
                try {
                    if (title == this.lastTitle) break block6;
                    for (int i = 0; i < 8; ++i) {
                        if (!title.getString().contains(DUNGEON_NAMES[i])) continue;
                        this.client.data.lastDungeonTime[i] = timer.getCurrentTime();
                        this.client.settings.save();
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.lastTitle = title;
        }
        int[] seconds = new int[8];
        for (int i = 0; i < seconds.length; ++i) {
            seconds[i] = 3600 - (int)timer.getDifference(this.client.data.lastDungeonTime[i]);
            if (seconds[i] >= 0) continue;
            seconds[i] = 0;
        }
        if (this.client.data.toggleDungeonCooltime) {
            this.render(guiGraphics, seconds);
        }
    }

    private void render(class_332 guiGraphics, int[] seconds) {
        float scale = this.client.data.dungeonCooltime_uiScale;
        int dungeon_count = 8;
        int id = 0;
        if (this.client.data.dungeontype == DungeonCategory.NORMAL) {
            dungeon_count = 4;
        } else if (this.client.data.dungeontype == DungeonCategory.CHAOS) {
            id = 4;
            dungeon_count = 4;
        }
        float textOffset = 1.458333f * scale + 3.66667f;
        for (int i = 0; i < dungeon_count; ++i) {
            int y;
            int x;
            if (this.client.data.coolAxis == DungeonCoolAxis.VERTICAL) {
                x = 2 + (this.mc.method_22683().method_4486() - (int)(scale + 2.0f + textOffset)) * this.client.data.DungeonCooltimeXpos / 1000;
                y = 2 + (this.mc.method_22683().method_4502() - (int)((scale + 2.0f) * (float)dungeon_count - 2.0f)) * this.client.data.DungeonCooltimeYpos / 1000;
            } else {
                x = 2 + (this.mc.method_22683().method_4486() - (int)((scale + 2.0f) * (float)dungeon_count - 2.0f)) * this.client.data.DungeonCooltimeXpos / 1000;
                y = 2 + (this.mc.method_22683().method_4502() - (int)(2.0f + textOffset)) * this.client.data.DungeonCooltimeYpos / 1000;
            }
            this.renderDungeonsAndCooltime(i, id, guiGraphics, x, y, seconds[id]);
            ++id;
        }
    }

    private void renderDungeonsAndCooltime(int i, int id, class_332 guiGraphics, int x, int y, int second) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        if (this.client.data.coolAxis == DungeonCoolAxis.VERTICAL) {
            poseStack.method_46416((float)x, (float)y + (this.client.data.dungeonCooltime_uiScale + 2.0f) * (float)i, 0.0f);
        } else {
            poseStack.method_46416((float)x + (this.client.data.dungeonCooltime_uiScale + 2.0f) * (float)i, (float)y, 0.0f);
        }
        poseStack.method_22905(this.client.data.dungeonCooltime_uiScale / 256.0f, this.client.data.dungeonCooltime_uiScale / 256.0f, this.client.data.dungeonCooltime_uiScale / 256.0f);
        class_2960 texture = this.getDungeonTexture(id);
        if (texture == null) {
            return;
        }
        guiGraphics.method_25290(class_1921::method_62277, texture, 0, 0, 0.0f, 0.0f, 256, 256, 256, 256);
        if (this.client.data.toggleDungeonCooltimeFade) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.method_25290(class_1921::method_62277, BLACK_ICON, 0, 0, 0.0f, 0.0f, 256, (int)(256.0f * (float)second / 3600.0f), 256, 256);
        }
        poseStack.method_22905(256.0f / this.client.data.dungeonCooltime_uiScale, 256.0f / this.client.data.dungeonCooltime_uiScale, 256.0f / this.client.data.dungeonCooltime_uiScale);
        poseStack.method_22909();
        if (this.client.data.toggleDungeonCooltimeText) {
            class_327 font = this.mc.field_1772;
            int minute = second / 60;
            second -= minute * 60;
            poseStack.method_22903();
            if (this.client.data.coolAxis == DungeonCoolAxis.VERTICAL) {
                poseStack.method_46416((float)x + this.client.data.dungeonCooltime_uiScale + 2.0f, (float)y + this.client.data.dungeonCooltime_uiScale / 4.0f + (this.client.data.dungeonCooltime_uiScale + 2.0f) * (float)i, 0.0f);
            } else {
                poseStack.method_46416((float)x + this.client.data.dungeonCooltime_uiScale / 2.0f + (this.client.data.dungeonCooltime_uiScale + 2.0f) * (float)i, (float)y + this.client.data.dungeonCooltime_uiScale + 2.0f, 0.0f);
            }
            float textScale = this.client.data.dungeonCooltime_uiScale / 16.0f;
            poseStack.method_22905(textScale / 1.1f, textScale / 1.1f, textScale / 1.1f);
            if (this.client.data.coolAxis == DungeonCoolAxis.VERTICAL) {
                guiGraphics.method_27535(font, (class_2561)class_2561.method_43470((String)String.format("%d:%d", minute, second)), 0, 0, 0xFFFFFF);
            } else {
                guiGraphics.method_27534(font, (class_2561)class_2561.method_43470((String)String.format("%d", minute)), 0, 0, 0xFFFFFF);
            }
            poseStack.method_22905(1.1f, 1.1f, 1.1f);
            poseStack.method_22909();
        }
    }

    private class_2960 getDungeonTexture(int dungeon_id) {
        if (dungeon_id >= 8) {
            return null;
        }
        return DUNGEON_ICONS[dungeon_id];
    }
}

