/*
 * Decompiled with CFR 0.152.
 */
package net.pmkjun.mineplanetplus.dungeonhelper.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.pmkjun.mineplanetplus.dungeonhelper.DungeonHelperClient;
import net.pmkjun.mineplanetplus.dungeonhelper.file.Mana;
import net.pmkjun.mineplanetplus.dungeonhelper.util.ClassCategory;
import net.pmkjun.mineplanetplus.dungeonhelper.util.DungeonSkill;
import net.pmkjun.mineplanetplus.dungeonhelper.util.SkillCategory;
import net.pmkjun.mineplanetplus.dungeonhelper.util.Timer;

public class SkillCooltimeGui {
    private final class_310 mc = class_310.method_1551();
    private final DungeonHelperClient client = DungeonHelperClient.getInstance();
    private final DungeonSkill dungeonSkill = new DungeonSkill();
    private static final class_2960 WIDGETS = class_2960.method_60656((String)"hud/hotbar_offhand_left");
    private static final class_2960 BLACK_ICON = class_2960.method_60655((String)"dungeonhelper", (String)"textures/icon/black.png");
    private static final class_2960 MANA_RUNOUT_ICON = class_2960.method_60655((String)"dungeonhelper", (String)"textures/icon/mana_runout.png");
    private static final int SKILL_GUI_SIZE = 16;
    private static final float ASSASSIN_SKILL_REACTIVATION_TIME = 0.5f;
    private static final float DRAGON_WARRIOR_SKILL_REACTIVATION_TIME = 1.0f;
    private static final float MARTIAL_ARTIST_SKILL_REACTIVATION_TIME = 1.0f;
    private static final float BATTLE_MAGE_SKILL_REACTIVATION_TIME = 0.7f;
    private static final float BLADE_SPIN_SKILL_COOLTIME = 7.3f;
    private static final float DRAGON_SMASH_COOLTIME = 6.4f;
    private static final float MARTIAL_DRIVE_COOLTIME = 7.9f;
    private static final float INFERNO_CHAIN_COOLTIME = 10.0f;
    private static final float BLADE_DANCE_COOLTIME = 30.0f;
    private static final float DRAGON_FURY_COOLTIME = 27.5f;
    private static final float MULTIPLE_BLOW_COOLTIME = 27.0f;
    private static final float ARCANE_DEMOLITION_COOLTIME = 25.7f;
    private long lastComboSkillTime = 0L;
    private long lastLV40SkillTime = 0L;
    private long lastUltimateTime = 0L;
    private long lastLV30SkillTime = 0L;
    private float leftLV30SkillTime = 0.0f;
    private float leftComboSkillTime;
    private float leftLV40SkillTime;
    private float leftUltimateTime;
    private static final float DAGGER_THROW_COOLTIME = 0.4f;
    private static final float DRAGON_BREATH_COOLTIME = 0.4f;
    private static final float ARCANE_SPIN_COOLTIME = 6.3f;

    public void updateLastComboSkillTime(Timer timer) {
        this.lastComboSkillTime = timer.getCurrentTime();
    }

    public void updateLastLV40SkillTime(Timer timer) {
        this.lastLV40SkillTime = timer.getCurrentTime();
    }

    public void updateLastLV40SkillTime(Timer timer, long plustime) {
        this.lastLV40SkillTime = timer.getCurrentTime() + plustime;
    }

    public void updateLastUltimateTime(Timer timer) {
        this.lastUltimateTime = timer.getCurrentTime();
    }

    public void resetLastComboSkillTime() {
        this.lastComboSkillTime = 0L;
    }

    public void delayLastSkilltime(long delay) {
        if (this.isComboSkillUseable()) {
            this.lastComboSkillTime += delay;
        }
        if (this.isLV40SkillCooltime()) {
            this.lastLV40SkillTime += delay;
        }
        if (this.isUltimateCooltime()) {
            this.lastUltimateTime += delay;
        }
    }

    public void updateLastLV30SkillTime(Timer timer) {
        this.lastLV30SkillTime = timer.getCurrentTime();
    }

    public void updateLastLV30SkillTime(Timer timer, long plustime) {
        this.lastLV30SkillTime = timer.getCurrentTime() + plustime;
    }

    public void renderTick(class_332 guiGraphics, Timer timer) {
        if (!this.client.data.toggleSkillCooltime) {
            return;
        }
        if (this.client.data.classType == ClassCategory.ASSASSIN) {
            this.leftComboSkillTime = 0.5f - timer.getDifference(this.lastComboSkillTime);
            this.leftLV40SkillTime = 7.3f - timer.getDifference(this.lastLV40SkillTime);
            this.leftUltimateTime = 30.0f - timer.getDifference(this.lastUltimateTime);
        } else if (this.client.data.classType == ClassCategory.DRAGON_WARRIOR) {
            this.leftComboSkillTime = 1.0f - timer.getDifference(this.lastComboSkillTime);
            this.leftLV40SkillTime = 6.4f - timer.getDifference(this.lastLV40SkillTime);
            this.leftUltimateTime = 27.5f - timer.getDifference(this.lastUltimateTime);
        } else if (this.client.data.classType == ClassCategory.MARTIAL_ARTIST) {
            this.leftComboSkillTime = 1.0f - timer.getDifference(this.lastComboSkillTime);
            this.leftLV40SkillTime = 7.9f - timer.getDifference(this.lastLV40SkillTime);
            this.leftUltimateTime = 27.0f - timer.getDifference(this.lastUltimateTime);
        } else if (this.client.data.classType == ClassCategory.BATTLE_MAGE) {
            this.leftComboSkillTime = 0.7f - timer.getDifference(this.lastComboSkillTime);
            this.leftLV40SkillTime = 10.0f - timer.getDifference(this.lastLV40SkillTime);
            this.leftUltimateTime = 25.7f - timer.getDifference(this.lastUltimateTime);
        }
        if (this.client.data.classType == ClassCategory.ASSASSIN) {
            this.leftLV30SkillTime = 0.4f - timer.getDifference(this.lastLV30SkillTime);
        } else if (this.client.data.classType == ClassCategory.DRAGON_WARRIOR) {
            this.leftLV30SkillTime = 0.4f - timer.getDifference(this.lastLV30SkillTime);
        } else if (this.client.data.classType == ClassCategory.BATTLE_MAGE) {
            this.leftLV30SkillTime = 6.3f - timer.getDifference(this.lastLV30SkillTime);
        }
        this.leftComboSkillTime = Math.max(this.leftComboSkillTime, 0.0f);
        this.leftLV30SkillTime = Math.max(this.leftLV30SkillTime, 0.0f);
        this.leftLV40SkillTime = Math.max(this.leftLV40SkillTime, 0.0f);
        this.leftUltimateTime = Math.max(this.leftUltimateTime, 0.0f);
        this.render(guiGraphics);
    }

    private void render(class_332 guiGraphics) {
        int xOffset = 98;
        this.renderSkillTexture(guiGraphics, xOffset);
        this.renderSkillCooltime(guiGraphics, xOffset);
    }

    private void renderSkillTexture(class_332 guiGraphics, int xOffset) {
        int yOffset;
        int screenWidth = this.mc.method_22683().method_4486();
        int screenHeight = this.mc.method_22683().method_4502();
        if (this.client.data.toggleCustomSkillGUIPos) {
            xOffset = (screenWidth - 88) * this.client.data.SkillCooltimeXpos / 1000;
            yOffset = (screenHeight - 22) * this.client.data.SkillCooltimeYpos / 1000;
        } else {
            xOffset = screenWidth / 2 + xOffset;
            yOffset = screenHeight - 22;
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)WIDGETS);
        int i = 0;
        for (int skillNum = 0; skillNum < 5; ++skillNum) {
            if (this.dungeonSkill.isComboSkill(this.client.data.classType, skillNum) && this.isComboSkillUseable()) {
                ++skillNum;
            }
            guiGraphics.method_52706(class_1921::method_62275, WIDGETS, xOffset + 22 * i, yOffset - 1, 29, 24);
            class_2960 texture = null;
            texture = this.dungeonSkill.getSkillTexture(this.client.data.classType, skillNum);
            this.drawSkillTexture(guiGraphics, texture, xOffset + 22 * i + 3, yOffset + 3);
            if (!(!this.isManaRunout(this.client.data.classType, this.dungeonSkill.getSkillCategory(skillNum)) || skillNum == 3 && this.isLV40SkillCooltime() || skillNum == 4 && this.isUltimateCooltime())) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderTexture((int)0, (class_2960)MANA_RUNOUT_ICON);
                this.drawSkillTexture(guiGraphics, MANA_RUNOUT_ICON, xOffset + 22 * i + 3, yOffset + 3);
            }
            if (this.dungeonSkill.isComboSkill(this.client.data.classType, skillNum) && !this.isComboSkillUseable()) {
                ++skillNum;
            }
            ++i;
        }
    }

    private void renderSkillCooltime(class_332 guiGraphics, int xOffset) {
        String cooldownText;
        int y;
        int x;
        int screenWidth = this.mc.method_22683().method_4486();
        int screenHeight = this.mc.method_22683().method_4502();
        if (this.client.data.toggleCustomSkillGUIPos) {
            x = (screenWidth - 88) * this.client.data.SkillCooltimeXpos / 1000 + 3;
            y = (screenHeight - 22) * this.client.data.SkillCooltimeYpos / 1000 + 4;
        } else {
            x = screenWidth / 2 + xOffset + 3;
            y = screenHeight - 22 + 4;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (class_2960)BLACK_ICON);
        float lv30SkillCooltime = 0.0f;
        if (this.client.data.classType == ClassCategory.ASSASSIN) {
            lv30SkillCooltime = 0.4f;
        } else if (this.client.data.classType == ClassCategory.DRAGON_WARRIOR) {
            lv30SkillCooltime = 0.4f;
        } else if (this.client.data.classType == ClassCategory.BATTLE_MAGE) {
            lv30SkillCooltime = 6.3f;
        }
        float lv40SkillCooltime = 0.0f;
        if (this.client.data.classType == ClassCategory.ASSASSIN) {
            lv40SkillCooltime = 7.3f;
        } else if (this.client.data.classType == ClassCategory.DRAGON_WARRIOR) {
            lv40SkillCooltime = 6.4f;
        } else if (this.client.data.classType == ClassCategory.MARTIAL_ARTIST) {
            lv40SkillCooltime = 7.9f;
        } else if (this.client.data.classType == ClassCategory.BATTLE_MAGE) {
            lv40SkillCooltime = 10.0f;
        }
        float ultimateCooltime = 10.0f;
        if (this.client.data.classType == ClassCategory.ASSASSIN) {
            ultimateCooltime = 30.0f;
        } else if (this.client.data.classType == ClassCategory.DRAGON_WARRIOR) {
            ultimateCooltime = 27.5f;
        } else if (this.client.data.classType == ClassCategory.MARTIAL_ARTIST) {
            ultimateCooltime = 27.0f;
        } else if (this.client.data.classType == ClassCategory.BATTLE_MAGE) {
            ultimateCooltime = 25.7f;
        }
        guiGraphics.method_25290(class_1921::method_62275, BLACK_ICON, x + 22, y + (int)(16.0f * (1.0f - this.leftLV30SkillTime / lv30SkillCooltime)), 0.0f, 0.0f, 16, (int)(16.0f * (this.leftLV30SkillTime / lv30SkillCooltime)), 256, 256);
        guiGraphics.method_25290(class_1921::method_62275, BLACK_ICON, x + 44, y + (int)(16.0f * (1.0f - this.leftLV40SkillTime / lv40SkillCooltime)), 0.0f, 0.0f, 16, (int)(16.0f * (this.leftLV40SkillTime / lv40SkillCooltime)), 256, 256);
        guiGraphics.method_25290(class_1921::method_62275, BLACK_ICON, x + 66, y + (int)(16.0f * (1.0f - this.leftUltimateTime / ultimateCooltime)), 0.0f, 0.0f, 16, (int)(16.0f * (this.leftUltimateTime / ultimateCooltime)), 256, 256);
        class_4587 poseStack = guiGraphics.method_51448();
        if (this.isComboSkillUseable()) {
            poseStack.method_22903();
            poseStack.method_46416((float)(x + 8 + 22 * this.dungeonSkill.getComboSkill(this.client.data.classType)), (float)(y + 4), 0.0f);
            poseStack.method_22905(0.9090909f, 0.9090909f, 0.9090909f);
            cooldownText = this.leftComboSkillTime < 1.0f ? String.format("%.1f", Float.valueOf(this.leftComboSkillTime)) : String.valueOf((int)this.leftComboSkillTime);
            guiGraphics.method_27534(this.mc.field_1772, (class_2561)class_2561.method_43470((String)cooldownText), 0, 0, 0xFFFFFF);
            poseStack.method_22909();
        }
        if (this.isLV30SkillCooltime()) {
            poseStack.method_22903();
            poseStack.method_46416((float)(x + 2 + 22 + 6), (float)(y + 4), 0.0f);
            poseStack.method_22905(0.9090909f, 0.9090909f, 0.9090909f);
            cooldownText = this.leftLV30SkillTime < 1.0f ? String.format("%.1f", Float.valueOf(this.leftLV30SkillTime)) : String.valueOf((int)this.leftLV30SkillTime);
            guiGraphics.method_27534(this.mc.field_1772, (class_2561)class_2561.method_43470((String)cooldownText), 0, 0, 0xFFFFFF);
            poseStack.method_22909();
        }
        if (this.isLV40SkillCooltime()) {
            poseStack.method_22903();
            poseStack.method_46416((float)(x + 2 + 44 + 6), (float)(y + 4), 0.0f);
            poseStack.method_22905(0.9090909f, 0.9090909f, 0.9090909f);
            cooldownText = this.leftLV40SkillTime < 1.0f ? String.format("%.1f", Float.valueOf(this.leftLV40SkillTime)) : String.valueOf((int)this.leftLV40SkillTime);
            guiGraphics.method_27534(this.mc.field_1772, (class_2561)class_2561.method_43470((String)cooldownText), 0, 0, 0xFFFFFF);
            poseStack.method_22909();
        }
        if (this.isUltimateCooltime()) {
            poseStack.method_22903();
            poseStack.method_46416((float)(x + 2 + 66 + 6), (float)(y + 4), 0.0f);
            poseStack.method_22905(0.9090909f, 0.9090909f, 0.9090909f);
            cooldownText = this.leftUltimateTime < 1.0f ? String.format("%.1f", Float.valueOf(this.leftUltimateTime)) : String.valueOf((int)this.leftUltimateTime);
            guiGraphics.method_27534(this.mc.field_1772, (class_2561)class_2561.method_43470((String)cooldownText), 0, 0, 0xFFFFFF);
            poseStack.method_22909();
        }
    }

    private void drawSkillTexture(class_332 guiGraphics, class_2960 texture, int x, int y) {
        float scaleRatio = 0.0625f;
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)x, (float)y, 0.0f);
        poseStack.method_22905(scaleRatio, scaleRatio, 1.0f);
        guiGraphics.method_25290(class_1921::method_62275, texture, 0, 0, 0.0f, 0.0f, 256, 256, 256, 256);
        poseStack.method_22909();
    }

    public boolean isManaRunout(ClassCategory classtype, SkillCategory skilltype) {
        return Mana.current < Mana.getSkillManacost(classtype, skilltype, Mana.dungeon_level);
    }

    public boolean isLV40SkillCooltime() {
        return this.leftLV40SkillTime > 0.0f;
    }

    public boolean isUltimateCooltime() {
        return this.leftUltimateTime > 0.0f;
    }

    public boolean isComboSkillUseable() {
        return this.leftComboSkillTime > 0.0f;
    }

    public boolean isLV30SkillCooltime() {
        return this.leftLV30SkillTime > 0.0f;
    }
}

