/*
 * Decompiled with CFR 0.152.
 */
package net.pmkjun.mineplanetplus.dungeonhelper.util;

import java.util.Arrays;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2761;
import net.minecraft.class_310;
import net.pmkjun.mineplanetplus.dungeonhelper.DungeonHelperClient;

public class TpsTracker {
    public static TpsTracker INSTANCE = new TpsTracker();
    private final float[] tickRates = new float[20];
    private int nextIndex = 0;
    private long timeLastTimeUpdate = -1L;
    private long timeGameJoined;
    private long tickDuration;
    private final DungeonHelperClient client = DungeonHelperClient.getInstance();
    public float serverProvidedTps = -1.0f;

    public <T extends class_2547> void onHandlePacket(class_2596<T> packet, class_2547 packetListener) {
        if (packet instanceof class_2761) {
            long now = System.currentTimeMillis();
            float timeElapsed = (float)(now - this.timeLastTimeUpdate) / 1000.0f;
            this.tickDuration = now - this.timeLastTimeUpdate;
            this.tickRates[this.nextIndex] = this.clamp(20.0f / timeElapsed, 0.0f, 20.0f);
            this.nextIndex = (this.nextIndex + 1) % this.tickRates.length;
            this.timeLastTimeUpdate = now;
            if (this.tickDuration > 1000L && this.tickDuration < 100000L) {
                this.client.delayLastSkilltime(this.tickDuration - 1000L);
            }
        }
    }

    public void onGameJoined() {
        this.serverProvidedTps = -1.0f;
        Arrays.fill(this.tickRates, 0.0f);
        this.nextIndex = 0;
        this.timeGameJoined = this.timeLastTimeUpdate = System.currentTimeMillis();
    }

    public float getTickRate() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return 0.0f;
        }
        if (System.currentTimeMillis() - this.timeGameJoined < 4000L) {
            return 20.0f;
        }
        int numTicks = 0;
        float sumTickRates = 0.0f;
        for (float tickRate : this.tickRates) {
            if (!(tickRate > 0.0f)) continue;
            sumTickRates += tickRate;
            ++numTicks;
        }
        return sumTickRates / (float)numTicks;
    }

    public long getTickDuration() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return 0L;
        }
        return this.tickDuration;
    }

    private float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }
}

