/*
 * Decompiled with CFR 0.152.
 */
package de.jakomi1.database;

import de.jakomi1.PlayerGrave;
import de.jakomi1.utils.FileUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_243;

public class GraveDatabase {
    private static Connection connection;

    private static Connection getConnection() throws SQLException {
        if (connection == null || connection.isClosed()) {
            File dbFile = FileUtils.ensureFileExists("config/justgraves", "graves.db");
            connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getAbsolutePath());
        }
        return connection;
    }

    public static void init() {
        try (Connection conn = GraveDatabase.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate("    CREATE TABLE IF NOT EXISTS graves (\n        timestamp LONG NOT NULL,\n        player_uuid TEXT NOT NULL,\n        world TEXT NOT NULL,\n        x DOUBLE NOT NULL,\n        y DOUBLE NOT NULL,\n        z DOUBLE NOT NULL,\n        xp INT NOT NULL,\n        inventory TEXT NOT NULL,\n        PRIMARY KEY(player_uuid, timestamp)\n    );\n");
        }
        catch (SQLException e) {
            System.err.println("Error initializing the Grave database: " + e.getMessage());
        }
    }

    public static void saveGrave(PlayerGrave grave) {
        String sql = "    INSERT INTO graves(player_uuid, timestamp, world, x, y, z, xp, inventory)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?)\n";
        try (PreparedStatement ps = GraveDatabase.getConnection().prepareStatement(sql);){
            ps.setString(1, grave.owner.method_5667().toString());
            ps.setLong(2, grave.timestamp);
            ps.setString(3, grave.world.toString());
            ps.setDouble(4, grave.location.field_1352);
            ps.setDouble(5, grave.location.field_1351);
            ps.setDouble(6, grave.location.field_1350);
            ps.setInt(7, grave.xpPoints);
            ps.setString(8, grave.savedInventory);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            System.err.println("Error saving grave for player " + (grave.owner != null ? grave.owner.method_5477().getString() : "unknown") + ": " + e.getMessage());
        }
    }

    public static String getWorld(String uuid, long timestamp) {
        return GraveDatabase.getSingleStringValue(uuid, timestamp, "world");
    }

    public static double getX(String uuid, long timestamp) {
        return GraveDatabase.getSingleDoubleValue(uuid, timestamp, "x");
    }

    public static double getY(String uuid, long timestamp) {
        return GraveDatabase.getSingleDoubleValue(uuid, timestamp, "y");
    }

    public static double getZ(String uuid, long timestamp) {
        return GraveDatabase.getSingleDoubleValue(uuid, timestamp, "z");
    }

    public static class_243 getGraveLocation(String uuid, long timestamp) {
        double x = GraveDatabase.getX(uuid, timestamp);
        double y = GraveDatabase.getY(uuid, timestamp);
        double z = GraveDatabase.getZ(uuid, timestamp);
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return null;
        }
        return new class_243(x, y, z);
    }

    public static int getXP(String uuid, long timestamp) {
        return GraveDatabase.getSingleIntValue(uuid, timestamp, "xp");
    }

    public static String getInventory(String uuid, long timestamp) {
        return GraveDatabase.getSingleStringValue(uuid, timestamp, "inventory");
    }

    public static void removeByUUIDAndTimestamp(String uuid, long timestamp) {
        String sql = "DELETE FROM graves WHERE player_uuid = ? AND timestamp = ?";
        try (PreparedStatement ps = GraveDatabase.getConnection().prepareStatement(sql);){
            ps.setString(1, uuid);
            ps.setLong(2, timestamp);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            System.err.println("Error deleting grave for UUID " + uuid + " and Timestamp " + timestamp + ": " + e.getMessage());
        }
    }

    public static List<Long> getGraveTimestamps(String uuid) {
        ArrayList<Long> timestamps = new ArrayList<Long>();
        String sql = "SELECT timestamp FROM graves WHERE player_uuid = ? ORDER BY timestamp ASC";
        try (PreparedStatement ps = GraveDatabase.getConnection().prepareStatement(sql);){
            ps.setString(1, uuid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                timestamps.add(rs.getLong("timestamp"));
            }
        }
        catch (SQLException e) {
            System.err.println("Error retrieving grave timestamps for UUID " + uuid + ": " + e.getMessage());
        }
        return timestamps;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getSingleStringValue(String uuid, long timestamp, String column) {
        String sql = "SELECT " + column + " FROM graves WHERE player_uuid = ? AND timestamp = ?";
        try (PreparedStatement ps = GraveDatabase.getConnection().prepareStatement(sql);){
            ps.setString(1, uuid);
            ps.setLong(2, timestamp);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return null;
            String string = rs.getString(column);
            return string;
        }
        catch (SQLException e) {
            System.err.println("Error retrieving " + column + " for UUID " + uuid + " and Timestamp " + timestamp + ": " + e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static double getSingleDoubleValue(String uuid, long timestamp, String column) {
        PreparedStatement ps;
        block7: {
            String sql = "SELECT " + column + " FROM graves WHERE player_uuid = ? AND timestamp = ?";
            try {
                double d;
                ps = GraveDatabase.getConnection().prepareStatement(sql);
                try {
                    ps.setString(1, uuid);
                    ps.setLong(2, timestamp);
                    ResultSet rs = ps.executeQuery();
                    if (!rs.next()) break block7;
                    d = rs.getDouble(column);
                    if (ps == null) return d;
                }
                catch (Throwable throwable) {
                    if (ps == null) throw throwable;
                    try {
                        ps.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ps.close();
                return d;
            }
            catch (SQLException e) {
                System.err.println("Error retrieving " + column + " for UUID " + uuid + " and Timestamp " + timestamp + ": " + e.getMessage());
                return 0.0;
            }
        }
        if (ps == null) return 0.0;
        ps.close();
        return 0.0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getSingleIntValue(String uuid, long timestamp, String column) {
        String sql = "SELECT " + column + " FROM graves WHERE player_uuid = ? AND timestamp = ?";
        try (PreparedStatement ps = GraveDatabase.getConnection().prepareStatement(sql);){
            ps.setString(1, uuid);
            ps.setLong(2, timestamp);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return 0;
            int n = rs.getInt(column);
            return n;
        }
        catch (SQLException e) {
            System.err.println("Error retrieving " + column + " for UUID " + uuid + " and Timestamp " + timestamp + ": " + e.getMessage());
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getSingleLongValue(String uuid, long timestamp, String column) {
        String sql = "SELECT " + column + " FROM graves WHERE player_uuid = ? AND timestamp = ?";
        try (PreparedStatement ps = GraveDatabase.getConnection().prepareStatement(sql);){
            ps.setString(1, uuid);
            ps.setLong(2, timestamp);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return 0L;
            long l = rs.getLong(column);
            return l;
        }
        catch (SQLException e) {
            System.err.println("Error retrieving " + column + " for UUID " + uuid + " and Timestamp " + timestamp + ": " + e.getMessage());
        }
        return 0L;
    }

    public static void close() {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                System.err.println("Error closing the Grave database: " + e.getMessage());
            }
            finally {
                connection = null;
            }
        }
    }
}

