/*
 * Decompiled with CFR 0.152.
 */
package de.jakomi1.mixin;

import de.jakomi1.JustGraves;
import de.jakomi1.PlayerGrave;
import de.jakomi1.database.GraveDatabase;
import de.jakomi1.utils.FileUtils;
import de.jakomi1.utils.MessageUtils;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5251;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerInteractMixin {
    @Inject(method={"method_7287(Lnet/minecraft/class_1297;Lnet/minecraft/class_1268;)Lnet/minecraft/class_1269;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onInteractWithEntity(class_1297 entity, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        boolean canLoot;
        class_1657 player = (class_1657)this;
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        Map<String, String> tags = entity.method_5752().stream().filter(s -> s.contains(":")).map(s -> s.split(":", 2)).collect(Collectors.toMap(a -> a[0], a -> a[1]));
        long timestamp = tags.containsKey("timestamp") ? Long.parseLong(tags.get("timestamp")) : 0L;
        String ownerUUID = tags.get("owner");
        String ownerName = tags.get("name");
        if (timestamp == 0L || ownerUUID == null) {
            return;
        }
        boolean isOwner = ownerUUID.equals(serverPlayer.method_5667().toString());
        String remainingTime = PlayerInteractMixin.getRemainingTime(timestamp, FileUtils.GRAVE_PROTECTION_TIME);
        boolean bl = canLoot = isOwner || remainingTime == null;
        if (canLoot) {
            String gearString = GraveDatabase.getInventory(ownerUUID, timestamp);
            int xp = GraveDatabase.getXP(ownerUUID, timestamp);
            PlayerGrave.givePlayerStoredLoot((class_1657)serverPlayer, gearString);
            PlayerGrave.givePlayerStoredXP((class_1657)serverPlayer, xp);
            PlayerGrave.playOpenSound((class_1657)serverPlayer);
            GraveDatabase.removeByUUIDAndTimestamp(ownerUUID, timestamp);
            PlayerGrave.remove((class_1657)serverPlayer, ownerUUID, timestamp);
            String messageKey = isOwner ? "grave-loot-own" : "grave-loot-other";
            String message = MessageUtils.formatMessage(messageKey, Map.of("name", ownerName));
            serverPlayer.method_7353((class_2561)JustGraves.chatPrefix.method_27661().method_10852((class_2561)class_2561.method_43470((String)message).method_27694(style -> style.method_27703(class_5251.method_27717((int)0xAAAAAA)).method_10978(Boolean.valueOf(false)))), false);
        } else {
            String protectionMsg = MessageUtils.getMessage("grave-protection").replace("%name%", ownerName).replace("%time%", remainingTime);
            serverPlayer.method_7353((class_2561)JustGraves.chatPrefix.method_27661().method_10852((class_2561)class_2561.method_43470((String)protectionMsg).method_27694(style -> style.method_27703(class_5251.method_27717((int)0xFF5555)).method_10978(Boolean.valueOf(false)))), false);
        }
        cir.setReturnValue((Object)class_1269.field_5812);
    }

    private static String getRemainingTime(long timestamp, long durationMs) {
        long remaining = timestamp + durationMs - System.currentTimeMillis();
        if (remaining <= 0L) {
            return null;
        }
        long hours = remaining / 3600000L;
        long minutes = remaining / 60000L % 60L;
        long seconds = remaining / 1000L % 60L;
        if (hours >= 1L) {
            return hours + " " + MessageUtils.getMessage(hours == 1L ? "time-hour-singular" : "time-hour-plural");
        }
        if (minutes >= 1L) {
            return minutes + " " + MessageUtils.getMessage(minutes == 1L ? "time-minute-singular" : "time-minute-plural");
        }
        return seconds + " " + MessageUtils.getMessage(seconds == 1L ? "time-second-singular" : "time-second-plural");
    }
}

