/*
 * Decompiled with CFR 0.152.
 */
package de.jakomi1.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class FileUtils {
    public static boolean DROP_PLAYER_HEAD = true;
    public static int GRAVE_PROTECTION_TIME = 0x6DDD00;
    public static String LANG = "en_us";

    public static File ensureFileExists(String folderPath, String fileName) {
        try {
            File folder = new File(folderPath);
            if (!folder.exists() && !folder.mkdirs()) {
                throw new IOException("Could not create folder: " + folderPath);
            }
            File file = new File(folder, fileName);
            if (!file.exists() && !file.createNewFile()) {
                throw new IOException("Could not create file: " + file.getAbsolutePath());
            }
            return file;
        }
        catch (IOException e) {
            System.err.println("Error creating file/folder: " + e.getMessage());
            return null;
        }
    }

    public static void loadConfig() {
        String folderPath = "config/justgraves";
        String fileName = "config.yml";
        File configFile = FileUtils.ensureFileExists(folderPath, fileName);
        if (configFile == null) {
            return;
        }
        LinkedHashMap<String, String> defaults = new LinkedHashMap<String, String>();
        defaults.put("drop-player-head", "true");
        defaults.put("grave-protection-time", "120");
        defaults.put("lang", "en_us");
        HashMap<String, String> comments = new HashMap<String, String>();
        comments.put("drop-player-head", "# If true, on player death drops head of player (true/false)");
        comments.put("grave-protection-time", "# How many minutes another player cannot access the grave");
        comments.put("lang", "# Language of messages: en_us, de_de, fr_fr, es_es or it_it");
        HashMap<String, String> legacyMap = new HashMap<String, String>();
        legacyMap.put("drop_player_head", "drop-player-head");
        legacyMap.put("drop-playerhead", "drop-player-head");
        legacyMap.put("dropplayerhead", "drop-player-head");
        legacyMap.put("grave_protection_time", "grave-protection-time");
        legacyMap.put("grave-protection", "grave-protection-time");
        legacyMap.put("protection-time", "grave-protection-time");
        legacyMap.put("protection", "grave-protection-time");
        legacyMap.put("language", "lang");
        legacyMap.put("locale", "lang");
        legacyMap.put("langue", "lang");
        LinkedHashMap<String, String> fileMap = new LinkedHashMap<String, String>();
        boolean changed = false;
        try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts;
                String trimmed = line.trim();
                if (trimmed.isEmpty() || trimmed.startsWith("#") || (parts = trimmed.split(":", 2)).length != 2) continue;
                String key = parts[0].trim();
                String value = parts[1].trim();
                if (value.startsWith("\"") && value.endsWith("\"") && value.length() >= 2) {
                    value = value.substring(1, value.length() - 1);
                }
                fileMap.put(key, value);
            }
        }
        catch (IOException e) {
            System.err.println("Fehler beim Lesen der Config: " + e.getMessage());
        }
        for (Map.Entry legacy : legacyMap.entrySet()) {
            String legacyKey = (String)legacy.getKey();
            String canonical = (String)legacy.getValue();
            if (!fileMap.containsKey(legacyKey) || fileMap.containsKey(canonical)) continue;
            fileMap.put(canonical, (String)fileMap.get(legacyKey));
            fileMap.remove(legacyKey);
            changed = true;
            System.out.println("[CONFIG] Migrated legacy key '" + legacyKey + "' -> '" + canonical + "'");
        }
        for (Map.Entry def : defaults.entrySet()) {
            String key = (String)def.getKey();
            if (fileMap.containsKey(key)) continue;
            fileMap.put(key, (String)def.getValue());
            changed = true;
            System.out.println("[CONFIG] Missing key '" + key + "' added with default '" + (String)def.getValue() + "'");
        }
        if (changed) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(configFile));){
                for (String key : defaults.keySet()) {
                    if (comments.containsKey(key)) {
                        writer.write((String)comments.get(key));
                        writer.newLine();
                    }
                    String val = fileMap.getOrDefault(key, (String)defaults.get(key));
                    writer.write(key + ": " + val);
                    writer.newLine();
                    writer.newLine();
                }
                writer.flush();
                System.out.println("[CONFIG] Config file repaired and rewritten.");
            }
            catch (IOException e) {
                System.err.println("[CONFIG] Error whilest writing: " + e.getMessage());
            }
        }
        String dropVal = fileMap.getOrDefault("drop-player-head", (String)defaults.get("drop-player-head"));
        DROP_PLAYER_HEAD = FileUtils.parseBooleanSafe(dropVal, true);
        String protVal = fileMap.getOrDefault("grave-protection-time", (String)defaults.get("grave-protection-time"));
        int minutes = FileUtils.parseIntSafe(protVal, Integer.parseInt((String)defaults.get("grave-protection-time")));
        GRAVE_PROTECTION_TIME = minutes * 60 * 1000;
        String langVal = fileMap.getOrDefault("lang", (String)defaults.get("lang")).toLowerCase(Locale.ROOT).trim();
        LANG = FileUtils.normalizeLang(langVal);
        System.out.println("[DEBUG] Loaded config: DROP_PLAYER_HEAD=" + DROP_PLAYER_HEAD + ", GRAVE_PROTECTION_TIME(ms)=" + GRAVE_PROTECTION_TIME + ", LANG=" + LANG);
    }

    private static int parseIntSafe(String s, int fallback) {
        try {
            return Integer.parseInt(s.trim());
        }
        catch (Exception ex) {
            System.err.println("[CONFIG] Number parse error for value '" + s + "'. Using fallback: " + fallback);
            return fallback;
        }
    }

    private static boolean parseBooleanSafe(String s, boolean fallback) {
        if (s == null) {
            return fallback;
        }
        String t = s.trim().toLowerCase(Locale.ROOT);
        if (t.equals("true") || t.equals("yes") || t.equals("1")) {
            return true;
        }
        if (t.equals("false") || t.equals("no") || t.equals("0")) {
            return false;
        }
        System.err.println("[CONFIG] Boolean parse error for value '" + s + "'. Using fallback: " + fallback);
        return fallback;
    }

    private static String normalizeLang(String lang) {
        String cleaned;
        if (lang == null || lang.isEmpty()) {
            return "en_us";
        }
        switch (cleaned = lang.replace('-', '_').toLowerCase(Locale.ROOT)) {
            case "en": 
            case "en_us": 
            case "english": {
                return "en_us";
            }
            case "de": 
            case "de_de": 
            case "german": {
                return "de_de";
            }
            case "fr": 
            case "fr_fr": 
            case "french": {
                return "fr_fr";
            }
            case "es": 
            case "es_es": 
            case "spanish": {
                return "es_es";
            }
            case "it": 
            case "it_it": 
            case "italian": {
                return "it_it";
            }
        }
        if (cleaned.matches("[a-z]{2}_[a-z]{2}")) {
            return cleaned;
        }
        System.err.println("[CONFIG] Unknown lang '" + lang + "', falling back to en_us");
        return "en_us";
    }
}

