/*
 * Decompiled with CFR 0.152.
 */
package de.jakomi1.utils;

import de.jakomi1.utils.FileUtils;
import java.util.HashMap;
import java.util.Map;

public class MessageUtils {
    private static final Map<String, String> messages_en_us = new HashMap<String, String>();
    private static final Map<String, String> messages_de_de = new HashMap<String, String>();
    private static final Map<String, String> messages_fr_fr = new HashMap<String, String>();
    private static final Map<String, String> messages_es_es = new HashMap<String, String>();
    private static final Map<String, String> messages_it_it = new HashMap<String, String>();

    public static String getMessage(String key) {
        switch (FileUtils.LANG.toLowerCase()) {
            case "de_de": {
                return messages_de_de.getOrDefault(key, messages_en_us.getOrDefault(key, key));
            }
            case "fr_fr": {
                return messages_fr_fr.getOrDefault(key, messages_en_us.getOrDefault(key, key));
            }
            case "es_es": {
                return messages_es_es.getOrDefault(key, messages_en_us.getOrDefault(key, key));
            }
            case "it_it": {
                return messages_it_it.getOrDefault(key, messages_en_us.getOrDefault(key, key));
            }
        }
        return messages_en_us.getOrDefault(key, key);
    }

    public static String formatTime(long millis) {
        long totalSeconds = millis / 1000L;
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append(" ").append(MessageUtils.getMessage(days == 1L ? "time-day-singular" : "time-day-plural")).append(" ");
        }
        if (hours > 0L) {
            sb.append(hours).append(" ").append(MessageUtils.getMessage(hours == 1L ? "time-hour-singular" : "time-hour-plural")).append(" ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append(" ").append(MessageUtils.getMessage(minutes == 1L ? "time-minute-singular" : "time-minute-plural")).append(" ");
        }
        if (seconds > 0L || sb.isEmpty()) {
            sb.append(seconds).append(" ").append(MessageUtils.getMessage(seconds == 1L ? "time-second-singular" : "time-second-plural"));
        }
        return sb.toString().trim();
    }

    public static String formatMessage(String key, Map<String, String> placeholders) {
        String msg = MessageUtils.getMessage(key);
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                msg = msg.replace("%" + entry.getKey() + "%", entry.getValue());
            }
        }
        return msg;
    }

    static {
        messages_en_us.put("grave-created", "Your grave is safe at [%x%/%y%/%z%] for %time%!");
        messages_en_us.put("grave-empty-inventory", "No grave created because your inventory was empty.");
        messages_en_us.put("grave-loot-own", "You collected your grave!");
        messages_en_us.put("grave-loot-other", "You collected %name%'s grave!");
        messages_en_us.put("grave-protection", "You can open %name%'s grave in %time%!");
        messages_en_us.put("time-day-singular", "day");
        messages_en_us.put("time-day-plural", "days");
        messages_en_us.put("time-hour-singular", "hour");
        messages_en_us.put("time-hour-plural", "hours");
        messages_en_us.put("time-minute-singular", "minute");
        messages_en_us.put("time-minute-plural", "minutes");
        messages_en_us.put("time-second-singular", "second");
        messages_en_us.put("time-second-plural", "seconds");
        messages_en_us.put("head", "Head");
        messages_en_us.put("grave-of", "Grave of");
        messages_en_us.put("graves-of", "Graves of");
        messages_en_us.put("no-graves", "You don't have any graves!");
        messages_de_de.put("grave-created", "Dein Grab ist bei [%x%/%y%/%z%] f\u00fcr %time% sicher!");
        messages_de_de.put("grave-empty-inventory", "Kein Grab erzeugt, weil dein Inventar leer war!");
        messages_de_de.put("grave-loot-own", "Du hast dein Grab eingesammelt!");
        messages_de_de.put("grave-loot-other", "Du hast %name%'s Grab eingesammelt!");
        messages_de_de.put("grave-protection", "Du kannst %name%'s Grab erst in %time% \u00f6ffnen!");
        messages_de_de.put("time-day-singular", "Tag");
        messages_de_de.put("time-day-plural", "Tage");
        messages_de_de.put("time-hour-singular", "Stunde");
        messages_de_de.put("time-hour-plural", "Stunden");
        messages_de_de.put("time-minute-singular", "Minute");
        messages_de_de.put("time-minute-plural", "Minuten");
        messages_de_de.put("time-second-singular", "Sekunde");
        messages_de_de.put("time-second-plural", "Sekunden");
        messages_de_de.put("head", "Kopf");
        messages_de_de.put("grave-of", "Grab von");
        messages_de_de.put("graves-of", "Gr\u00e4ber von");
        messages_de_de.put("no-graves", "Du hast keine Gr\u00e4ber!");
        messages_fr_fr.put("grave-created", "Votre tombe est s\u00e9curis\u00e9e \u00e0 [%x%/%y%/%z%] pour %time% !");
        messages_fr_fr.put("grave-empty-inventory", "Aucune tombe cr\u00e9\u00e9e car votre inventaire \u00e9tait vide.");
        messages_fr_fr.put("grave-loot-own", "Vous avez r\u00e9cup\u00e9r\u00e9 votre tombe !");
        messages_fr_fr.put("grave-loot-other", "Vous avez r\u00e9cup\u00e9r\u00e9 la tombe de %name% !");
        messages_fr_fr.put("grave-protection", "Vous pouvez ouvrir la tombe de %name% dans %time% !");
        messages_fr_fr.put("time-day-singular", "jour");
        messages_fr_fr.put("time-day-plural", "jours");
        messages_fr_fr.put("time-hour-singular", "heure");
        messages_fr_fr.put("time-hour-plural", "heures");
        messages_fr_fr.put("time-minute-singular", "minute");
        messages_fr_fr.put("time-minute-plural", "minutes");
        messages_fr_fr.put("time-second-singular", "seconde");
        messages_fr_fr.put("time-second-plural", "secondes");
        messages_fr_fr.put("head", "T\u00eate");
        messages_fr_fr.put("grave-of", "Tombe de");
        messages_fr_fr.put("graves-of", "Tombes de");
        messages_fr_fr.put("no-graves", "Vous n'avez aucune tombe !");
        messages_es_es.put("grave-created", "\u00a1Tu tumba est\u00e1 segura en [%x%/%y%/%z%] durante %time%!");
        messages_es_es.put("grave-empty-inventory", "No se cre\u00f3 ninguna tumba porque tu inventario estaba vac\u00edo.");
        messages_es_es.put("grave-loot-own", "\u00a1Has recogido tu tumba!");
        messages_es_es.put("grave-loot-other", "\u00a1Has recogido la tumba de %name%!");
        messages_es_es.put("grave-protection", "\u00a1Puedes abrir la tumba de %name% en %time%!");
        messages_es_es.put("time-day-singular", "d\u00eda");
        messages_es_es.put("time-day-plural", "d\u00edas");
        messages_es_es.put("time-hour-singular", "hora");
        messages_es_es.put("time-hour-plural", "horas");
        messages_es_es.put("time-minute-singular", "minuto");
        messages_es_es.put("time-minute-plural", "minutos");
        messages_es_es.put("time-second-singular", "segundo");
        messages_es_es.put("time-second-plural", "segundos");
        messages_es_es.put("head", "Cabeza");
        messages_es_es.put("grave-of", "Tumba de");
        messages_es_es.put("graves-of", "Tumbas de");
        messages_es_es.put("no-graves", "\u00a1No tienes ninguna tumba!");
        messages_it_it.put("grave-created", "La tua tomba \u00e8 sicura a [%x%/%y%/%z%] per %time%!");
        messages_it_it.put("grave-empty-inventory", "Nessuna tomba creata perch\u00e9 il tuo inventario era vuoto.");
        messages_it_it.put("grave-loot-own", "Hai raccolto la tua tomba!");
        messages_it_it.put("grave-loot-other", "Hai raccolto la tomba di %name%!");
        messages_it_it.put("grave-protection", "Puoi aprire la tomba di %name% in %time%!");
        messages_it_it.put("time-day-singular", "giorno");
        messages_it_it.put("time-day-plural", "giorni");
        messages_it_it.put("time-hour-singular", "ora");
        messages_it_it.put("time-hour-plural", "ore");
        messages_it_it.put("time-minute-singular", "minuto");
        messages_it_it.put("time-minute-plural", "minuti");
        messages_it_it.put("time-second-singular", "secondo");
        messages_it_it.put("time-second-plural", "secondi");
        messages_it_it.put("head", "Testa");
        messages_it_it.put("grave-of", "Tomba di");
        messages_it_it.put("graves-of", "Tombe di");
        messages_it_it.put("no-graves", "Non hai tombe!");
    }
}

