/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.config.search;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import net.caffeinemc.mods.sodium.client.config.search.SearchQuerySession;
import net.caffeinemc.mods.sodium.client.config.search.SourceStoringIndex;
import net.caffeinemc.mods.sodium.client.config.search.TextSource;
import org.jspecify.annotations.NonNull;

public class BigramSearchIndex
extends SourceStoringIndex {
    private final Object2ReferenceMap<String, BigramSources> bigramIndex = new Object2ReferenceOpenHashMap();
    private static final Pattern NON_WORD = Pattern.compile("[\\W_]+", 256);

    public BigramSearchIndex(Runnable registerCallback) {
        super(registerCallback);
    }

    @Override
    public void rebuildIndex() {
        this.bigramIndex.clear();
        for (TextSource source : this.sources) {
            String text = source.getText();
            if (text == null) continue;
            text = BigramSearchIndex.conditionText(text).trim();
            for (Object2IntMap.Entry entry : BigramSearchIndex.countBigrams(text).object2IntEntrySet()) {
                String bigram = (String)entry.getKey();
                int count = entry.getIntValue();
                BigramSources list = (BigramSources)this.bigramIndex.computeIfAbsent((Object)bigram, k -> new BigramSources());
                list.counts.add(new SourceBigramCount(source, count));
            }
        }
        for (BigramSources bigramSources : this.bigramIndex.values()) {
            bigramSources.prevalenceInv = (float)this.sources.size() / (float)bigramSources.counts.size();
        }
    }

    private static String conditionText(String text) {
        text = text.toLowerCase();
        text = NON_WORD.matcher(text).replaceAll(" ");
        return text;
    }

    private static @NonNull Object2IntMap<String> countBigrams(String text) {
        int length = text.length();
        Object2IntLinkedOpenHashMap bigramCounts = new Object2IntLinkedOpenHashMap(length + 1);
        BigramSearchIndex.addLeadingBigram(text, (Object2IntLinkedOpenHashMap<String>)bigramCounts);
        BigramSearchIndex.addInnerBigrams(text, (Object2IntMap<String>)bigramCounts);
        BigramSearchIndex.addTrailingBigram(text, length, (Object2IntLinkedOpenHashMap<String>)bigramCounts);
        return bigramCounts;
    }

    private static void addInnerBigrams(String text, Object2IntMap<String> bigramCounts) {
        int length = text.length();
        for (int i = 0; i < length - 1; ++i) {
            String bigram = text.substring(i, i + 2);
            bigramCounts.put((Object)bigram, bigramCounts.getInt((Object)bigram) + 1);
        }
    }

    private static void addTrailingBigram(String text, int length, Object2IntLinkedOpenHashMap<String> bigramCounts) {
        String trailingBigram = text.charAt(length - 1) + " ";
        bigramCounts.put((Object)trailingBigram, bigramCounts.getInt((Object)trailingBigram) + 1);
    }

    private static void addLeadingBigram(String text, Object2IntLinkedOpenHashMap<String> bigramCounts) {
        String leadingBigram = " " + text.charAt(0);
        bigramCounts.put((Object)leadingBigram, bigramCounts.getInt((Object)leadingBigram) + 1);
    }

    @Override
    protected SearchQuerySession createQuery() {
        return new BigramSearchQuerySession();
    }

    private static class BigramSources {
        public final List<SourceBigramCount> counts = new ObjectArrayList();
        public float prevalenceInv;

        private BigramSources() {
        }
    }

    private record SourceBigramCount(TextSource source, int count) {
    }

    private class BigramSearchQuerySession
    implements SearchQuerySession {
        private BigramSearchQuerySession() {
        }

        @Override
        public List<? extends TextSource> getSearchResults(String query) {
            if ((query = BigramSearchIndex.conditionText(query)).isEmpty()) {
                return List.of();
            }
            Object2IntLinkedOpenHashMap queryBigrams = new Object2IntLinkedOpenHashMap(query.length());
            BigramSearchIndex.addLeadingBigram(query, (Object2IntLinkedOpenHashMap<String>)queryBigrams);
            BigramSearchIndex.addInnerBigrams(query, (Object2IntMap<String>)queryBigrams);
            float queryBigramTotalInv = 1.0f / (float)(query.length() + 1);
            ReferenceLinkedOpenHashSet scoredSources = new ReferenceLinkedOpenHashSet();
            float maxScore = 0.0f;
            for (Object2IntMap.Entry entry : queryBigrams.object2IntEntrySet()) {
                String bigram = (String)entry.getKey();
                int queryCount = entry.getIntValue();
                float queryBigramDensity = (float)queryCount * queryBigramTotalInv;
                BigramSources bigramSources = (BigramSources)BigramSearchIndex.this.bigramIndex.get((Object)bigram);
                if (bigramSources == null) continue;
                float prevalenceInv = bigramSources.prevalenceInv;
                for (SourceBigramCount sourceBigramCount : bigramSources.counts) {
                    TextSource source = sourceBigramCount.source;
                    int sourceCount = sourceBigramCount.count;
                    float score = queryBigramDensity * ((float)Math.log(sourceCount) + 1.0f) * prevalenceInv;
                    if (source.getText().toLowerCase().startsWith(query.trim())) {
                        score *= 3.0f;
                    } else if (source.getText().toLowerCase().contains(query.trim())) {
                        score *= 2.0f;
                    }
                    if (queryCount > sourceCount) {
                        score *= (float)sourceCount / (float)(sourceCount + 2 * (queryCount - sourceCount));
                    }
                    if (scoredSources.add((Object)source)) {
                        source.setScore(score);
                        maxScore = Math.max(maxScore, score);
                        continue;
                    }
                    float newScore = source.getScore() + score;
                    source.setScore(newScore);
                    maxScore = Math.max(maxScore, newScore);
                }
            }
            float scoreCutoff = maxScore * 0.2f;
            ObjectArrayList results = new ObjectArrayList(scoredSources.size());
            for (TextSource source : scoredSources) {
                if (!(source.getScore() >= scoreCutoff)) continue;
                results.add((Object)source);
            }
            results.sort(Comparator.comparing(TextSource::getScore).reversed());
            if (results.size() > 10) {
                results = results.subList(0, 10);
            }
            return results;
        }
    }
}

