/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.model.quad.BakedQuadView;
import net.caffeinemc.mods.sodium.client.render.helper.ListStorage;
import net.caffeinemc.mods.sodium.client.render.helper.TextureHelper;
import net.caffeinemc.mods.sodium.client.render.model.EncodingFormat;
import net.caffeinemc.mods.sodium.client.render.model.QuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.model.SodiumShadeMode;
import net.caffeinemc.mods.sodium.client.render.texture.SodiumSpriteFinder;
import net.minecraft.class_1058;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_2350;
import net.minecraft.class_5611;
import net.minecraft.class_765;
import net.minecraft.class_777;
import net.minecraft.class_9851;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public abstract class MutableQuadViewImpl
extends QuadViewImpl
implements ListStorage {
    private @Nullable class_1058 cachedSprite;
    private List<class_10889> cachedList;

    @Override
    public List<class_10889> clearAndGet() {
        if (this.cachedList == null) {
            this.cachedList = new ArrayList<class_10889>();
            return this.cachedList;
        }
        this.cachedList.clear();
        return this.cachedList;
    }

    public @Nullable class_1058 cachedSprite() {
        return this.cachedSprite;
    }

    public void cachedSprite(@Nullable class_1058 sprite) {
        this.cachedSprite = sprite;
    }

    public class_1058 sprite(SodiumSpriteFinder finder) {
        class_1058 sprite = this.cachedSprite;
        if (sprite == null) {
            this.cachedSprite = sprite = finder.find(this);
        }
        return sprite;
    }

    public void clear() {
        for (int i = 0; i < 4; ++i) {
            this.positions[i].set(0.0f, 0.0f, 0.0f);
            this.colors[i] = 0;
            this.uv[i] = 0L;
            this.light[i] = 0;
        }
        this.maxLightEmission = 0;
        this.isGeometryInvalid = true;
        this.nominalFace = null;
        this.cachedSprite(null);
    }

    @Override
    public void load() {
        super.load();
        this.cachedSprite(null);
    }

    public MutableQuadViewImpl setPos(int vertexIndex, float x, float y, float z) {
        this.positions[vertexIndex].set(x, y, z);
        this.isGeometryInvalid = true;
        return this;
    }

    public MutableQuadViewImpl setColor(int vertexIndex, int color) {
        this.colors[vertexIndex] = color;
        return this;
    }

    public MutableQuadViewImpl setUV(int vertexIndex, float u, float v) {
        this.uv[vertexIndex] = class_5611.method_76640((float)u, (float)v);
        this.cachedSprite(null);
        return this;
    }

    public MutableQuadViewImpl spriteBake(class_1058 sprite, int bakeFlags) {
        TextureHelper.bakeSprite(this, sprite, bakeFlags);
        this.cachedSprite(sprite);
        return this;
    }

    public MutableQuadViewImpl setLight(int vertexIndex, int lightmap) {
        this.light[vertexIndex] = lightmap;
        return this;
    }

    protected void normalFlags(int flags) {
        this.header = EncodingFormat.normalFlags(this.header, flags);
    }

    public MutableQuadViewImpl setNormal(int vertexIndex, float x, float y, float z) {
        this.normalFlags(this.normalFlags() | 1 << vertexIndex);
        throw new IllegalStateException("Not implemented as of 1.21.11");
    }

    public final void populateMissingNormals() {
        throw new IllegalStateException("Not implemented as of 1.21.11");
    }

    public final MutableQuadViewImpl setCullFace(@Nullable class_2350 face) {
        this.header = EncodingFormat.cullFace(this.header, face);
        this.setNominalFace(face);
        return this;
    }

    public final MutableQuadViewImpl setNominalFace(@Nullable class_2350 face) {
        this.nominalFace = face;
        return this;
    }

    public MutableQuadViewImpl setRenderType(@Nullable class_11515 renderLayer) {
        this.header = EncodingFormat.renderLayer(this.header, renderLayer);
        return this;
    }

    public MutableQuadViewImpl setEmissive(boolean emissive) {
        this.header = EncodingFormat.emissive(this.header, emissive);
        return this;
    }

    public MutableQuadViewImpl setDiffuseShade(boolean shade) {
        this.header = EncodingFormat.diffuseShade(this.header, shade);
        return this;
    }

    public MutableQuadViewImpl setAmbientOcclusion(class_9851 ao) {
        Objects.requireNonNull(ao, "ambient occlusion TriState may not be null");
        this.header = EncodingFormat.ambientOcclusion(this.header, ao);
        return this;
    }

    public MutableQuadViewImpl setGlint(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable class_10444.class_10445 glint) {
        this.header = EncodingFormat.glint(this.header, glint);
        return this;
    }

    public MutableQuadViewImpl setShadeMode(SodiumShadeMode mode) {
        Objects.requireNonNull(mode, "ShadeMode may not be null");
        this.header = EncodingFormat.shadeMode(this.header, mode);
        return this;
    }

    public final MutableQuadViewImpl setTintIndex(int tintIndex) {
        this.tintIndex = tintIndex;
        return this;
    }

    public final MutableQuadViewImpl setTag(int tag) {
        this.tag = tag;
        return this;
    }

    public MutableQuadViewImpl copyFrom(QuadViewImpl q) {
        this.nominalFace = q.nominalFace;
        this.isGeometryInvalid = q.isGeometryInvalid;
        if (!this.isGeometryInvalid) {
            this.faceNormal.set((Vector3fc)q.faceNormal);
        }
        if (q instanceof MutableQuadViewImpl) {
            MutableQuadViewImpl mutableQuad = (MutableQuadViewImpl)q;
            this.cachedSprite(mutableQuad.cachedSprite());
        } else {
            this.cachedSprite(null);
        }
        throw new IllegalStateException("Not implemented as of 1.21.11");
    }

    public final MutableQuadViewImpl fromBakedQuad(class_777 quad) {
        for (int i = 0; i < 4; ++i) {
            this.positions[i].set(quad.method_76648(i));
            this.uv[i] = quad.method_76649(i);
            this.colors[i] = -1;
        }
        Arrays.fill(this.light, 0);
        this.setNominalFace(quad.comp_3723());
        this.setDiffuseShade(quad.comp_3725());
        this.setTintIndex(quad.comp_3722());
        this.setAmbientOcclusion(((BakedQuadView)quad).hasAO() ? class_9851.field_52396 : class_9851.field_52395);
        BakedQuadView bakedView = (BakedQuadView)quad;
        NormI8.unpack(bakedView.getFaceNormal(), this.faceNormal);
        this.packedNormal = bakedView.getFaceNormal();
        int headerBits = EncodingFormat.lightFace(this.header, bakedView.getLightFace());
        headerBits = EncodingFormat.normalFace(headerBits, bakedView.getNormalFace());
        this.header = EncodingFormat.geometryFlags(headerBits, bakedView.getFlags());
        this.isGeometryInvalid = false;
        int lightEmission = quad.comp_3726();
        if (lightEmission > 0) {
            for (int i = 0; i < 4; ++i) {
                this.setLight(i, class_765.method_62228((int)this.getLight(i), (int)lightEmission));
            }
        }
        this.cachedSprite(quad.comp_3724());
        return this;
    }

    public abstract void emitDirectly();

    static {
        MutableQuadViewImpl quad = new MutableQuadViewImpl(){

            @Override
            public void emitDirectly() {
            }
        };
        quad.setColor(0, -1);
        quad.setColor(1, -1);
        quad.setColor(2, -1);
        quad.setColor(3, -1);
        quad.setCullFace(null);
        quad.setRenderType(null);
        quad.setDiffuseShade(true);
        quad.setAmbientOcclusion(class_9851.field_52396);
        quad.setGlint(null);
        quad.setTintIndex(-1);
    }
}

