/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.platform.windows;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.caffeinemc.mods.sodium.client.platform.windows.api.Kernel32;
import org.lwjgl.system.MemoryUtil;

public class WindowsCommandLine {
    private static CommandLineHook ACTIVE_COMMAND_LINE_HOOK;

    public static void setCommandLine(String modifiedCmdline) {
        if (ACTIVE_COMMAND_LINE_HOOK != null) {
            throw new IllegalStateException("Command line is already modified");
        }
        long pCmdline = Kernel32.getCommandLine();
        String cmdline = MemoryUtil.memUTF16((long)pCmdline);
        int cmdlineLen = MemoryUtil.memLengthUTF16((CharSequence)cmdline, (boolean)true);
        if (MemoryUtil.memLengthUTF16((CharSequence)modifiedCmdline, (boolean)true) > cmdlineLen) {
            throw new BufferOverflowException();
        }
        ByteBuffer buffer = MemoryUtil.memByteBuffer((long)pCmdline, (int)cmdlineLen);
        MemoryUtil.memUTF16((CharSequence)modifiedCmdline, (boolean)true, (ByteBuffer)buffer);
        if (!Objects.equals(modifiedCmdline, MemoryUtil.memUTF16((long)pCmdline))) {
            throw new RuntimeException("Sanity check failed, the command line arguments did not appear to change");
        }
        ACTIVE_COMMAND_LINE_HOOK = new CommandLineHook(cmdline, buffer);
    }

    public static void resetCommandLine() {
        if (ACTIVE_COMMAND_LINE_HOOK != null) {
            ACTIVE_COMMAND_LINE_HOOK.uninstall();
            ACTIVE_COMMAND_LINE_HOOK = null;
        }
    }

    private static class CommandLineHook {
        private final String cmdline;
        private final ByteBuffer cmdlineBuf;
        private boolean active = true;

        private CommandLineHook(String cmdline, ByteBuffer cmdlineBuf) {
            this.cmdline = cmdline;
            this.cmdlineBuf = cmdlineBuf;
        }

        public void uninstall() {
            if (!this.active) {
                throw new IllegalStateException("Hook was already uninstalled");
            }
            MemoryUtil.memUTF16((CharSequence)this.cmdline, (boolean)true, (ByteBuffer)this.cmdlineBuf);
            this.active = false;
        }
    }
}

