/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gl.shader;

import com.mojang.blaze3d.opengl.GlStateManager;
import java.util.Arrays;
import net.caffeinemc.mods.sodium.client.gl.GlObject;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderParser;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderType;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderWorkarounds;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL20C;

public class GlShader
extends GlObject {
    private static final Logger LOGGER = LogManager.getLogger(GlShader.class);
    private final ResourceLocation name;

    public GlShader(ShaderType type, ResourceLocation name, ShaderParser.ParsedShader parsedShader) {
        int result;
        this.name = name;
        int handle = GL20C.glCreateShader((int)type.id);
        ShaderWorkarounds.safeShaderSource(handle, parsedShader.src());
        GL20C.glCompileShader((int)handle);
        String log = GL20C.glGetShaderInfoLog((int)handle);
        if (!log.isEmpty()) {
            LOGGER.warn("Shader compilation log for {}: {}", (Object)this.name, (Object)log);
            LOGGER.warn("Include table: {}", (Object)Arrays.toString(parsedShader.includeIds()));
        }
        if ((result = GlStateManager.glGetShaderi((int)handle, (int)35713)) != 1) {
            throw new RuntimeException("Shader compilation failed, see log for details");
        }
        this.setHandle(handle);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public void delete() {
        GL20C.glDeleteShader((int)this.handle());
        this.invalidateHandle();
    }
}

