/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.options.control;

import com.mojang.blaze3d.platform.Monitor;
import net.caffeinemc.mods.sodium.client.compatibility.environment.OsUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public interface ControlValueFormatter {
    public static ControlValueFormatter guiScale() {
        return v -> v == 0 ? Component.translatable((String)"options.guiScale.auto") : Component.literal((String)(v + "x"));
    }

    public static ControlValueFormatter resolution() {
        return v -> {
            Monitor monitor = Minecraft.getInstance().getWindow().findBestMonitor();
            if (OsUtils.getOs() != OsUtils.OperatingSystem.WIN || monitor == null) {
                return Component.translatable((String)"options.fullscreen.unavailable");
            }
            if (0 == v) {
                return Component.translatable((String)"options.fullscreen.current");
            }
            return Component.literal((String)monitor.getMode(v - 1).toString().replace(" (24bit)", ""));
        };
    }

    public static ControlValueFormatter fpsLimit() {
        return v -> v == 260 ? Component.translatable((String)"options.framerateLimit.max") : Component.translatable((String)"options.framerate", (Object[])new Object[]{v});
    }

    public static ControlValueFormatter brightness() {
        return v -> {
            if (v == 0) {
                return Component.translatable((String)"options.gamma.min");
            }
            if (v == 100) {
                return Component.translatable((String)"options.gamma.max");
            }
            return Component.literal((String)(v + "%"));
        };
    }

    public static ControlValueFormatter biomeBlend() {
        return v -> {
            if (v < 0 || v > 7) {
                return Component.translatable((String)"parsing.int.invalid", (Object[])new Object[]{v});
            }
            if (v == 0) {
                return Component.translatable((String)"gui.none");
            }
            int sv = 2 * v + 1;
            return Component.translatable((String)"sodium.options.biome_blend.value", (Object[])new Object[]{sv, sv});
        };
    }

    public Component format(int var1);

    public static ControlValueFormatter translateVariable(String key) {
        return v -> Component.translatable((String)key, (Object[])new Object[]{v});
    }

    public static ControlValueFormatter percentage() {
        return v -> Component.literal((String)(v + "%"));
    }

    public static ControlValueFormatter multiplier() {
        return v -> Component.literal((String)(v + "x"));
    }

    public static ControlValueFormatter quantityOrDisabled(String name, String disableText) {
        return v -> Component.literal((String)(v == 0 ? disableText : v + " " + name));
    }

    public static ControlValueFormatter number() {
        return v -> Component.literal((String)String.valueOf(v));
    }
}

