/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.model.quad.blender;

import net.caffeinemc.mods.sodium.api.util.ColorMixer;
import net.caffeinemc.mods.sodium.client.model.color.ColorProvider;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuadView;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;

public abstract class BlendedColorProvider<T>
implements ColorProvider<T> {
    @Override
    public void getColors(LevelSlice slice, BlockPos pos, BlockPos.MutableBlockPos scratchPos, T state, ModelQuadView quad, int[] output, boolean smooth) {
        if (smooth) {
            for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                output[vertexIndex] = this.getVertexColor(slice, pos, scratchPos, quad, state, vertexIndex);
            }
        } else {
            int color = this.getColor(slice, state, pos);
            for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                output[vertexIndex] = color;
            }
        }
    }

    private int getVertexColor(LevelSlice slice, BlockPos pos, BlockPos.MutableBlockPos scratchPos, ModelQuadView quad, T state, int vertexIndex) {
        float x = quad.getX(vertexIndex) - 0.5f;
        float y = quad.getY(vertexIndex) - 0.5f;
        float z = quad.getZ(vertexIndex) - 0.5f;
        int intX = Mth.floor((float)x);
        int intY = Mth.floor((float)y);
        int intZ = Mth.floor((float)z);
        float fracX = x - (float)intX;
        float fracY = y - (float)intY;
        float fracZ = z - (float)intZ;
        int blockX = pos.getX() + intX;
        int blockY = pos.getY() + intY;
        int blockZ = pos.getZ() + intZ;
        int m00 = this.getColor(slice, state, (BlockPos)scratchPos.set(blockX + 0, blockY, blockZ + 0));
        int m01 = this.getColor(slice, state, (BlockPos)scratchPos.set(blockX + 0, blockY, blockZ + 1));
        int m10 = this.getColor(slice, state, (BlockPos)scratchPos.set(blockX + 1, blockY, blockZ + 0));
        int m11 = this.getColor(slice, state, (BlockPos)scratchPos.set(blockX + 1, blockY, blockZ + 1));
        return ColorMixer.mix2d(m00, m01, m10, m11, fracX, fracZ);
    }

    protected abstract int getColor(LevelSlice var1, T var2, BlockPos var3);
}

