/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import net.caffeinemc.mods.sodium.client.services.PlatformBlockAccess;
import net.caffeinemc.mods.sodium.client.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockOcclusionCache {
    private static final int CACHE_SIZE = 512;
    private static final int ENTRY_ABSENT = -1;
    private static final int ENTRY_FALSE = 0;
    private static final int ENTRY_TRUE = 1;
    private final Object2IntLinkedOpenCustomHashMap<ShapeComparison> comparisonLookupTable;
    private final ShapeComparison cachedComparisonObject = new ShapeComparison();
    private final BlockPos.MutableBlockPos cachedPositionObject = new BlockPos.MutableBlockPos();

    public BlockOcclusionCache() {
        this.comparisonLookupTable = new Object2IntLinkedOpenCustomHashMap(512, 0.5f, (Hash.Strategy)new ShapeComparison.ShapeComparisonStrategy());
        this.comparisonLookupTable.defaultReturnValue(-1);
    }

    public boolean shouldDrawSide(BlockState selfBlockState, BlockGetter view, BlockPos selfPos, Direction facing) {
        BlockPos.MutableBlockPos neighborPos = this.cachedPositionObject;
        neighborPos.setWithOffset((Vec3i)selfPos, facing);
        BlockState neighborBlockState = view.getBlockState((BlockPos)neighborPos);
        VoxelShape neighborShape = neighborBlockState.getFaceOcclusionShape(DirectionUtil.getOpposite(facing));
        if (BlockOcclusionCache.isFullShape(neighborShape)) {
            return false;
        }
        if (selfBlockState.skipRendering(neighborBlockState, facing)) {
            return false;
        }
        if (PlatformBlockAccess.getInstance().shouldSkipRender(view, selfBlockState, neighborBlockState, selfPos, (BlockPos)neighborPos, facing)) {
            return false;
        }
        if (BlockOcclusionCache.isEmptyShape(neighborShape) || !neighborBlockState.canOcclude()) {
            return true;
        }
        VoxelShape selfShape = selfBlockState.getFaceOcclusionShape(facing);
        if (BlockOcclusionCache.isEmptyShape(selfShape)) {
            return true;
        }
        return this.lookup(selfShape, neighborShape);
    }

    private static boolean isFullShape(VoxelShape selfShape) {
        return selfShape == Shapes.block();
    }

    private static boolean isEmptyShape(VoxelShape voxelShape) {
        return voxelShape == Shapes.empty() || voxelShape.isEmpty();
    }

    public boolean shouldDrawFullBlockFluidSide(BlockState selfBlockState, BlockGetter view, BlockPos selfPos, Direction facing, FluidState fluid, VoxelShape fluidShape) {
        VoxelShape selfShape;
        boolean fluidShapeIsBlock;
        boolean bl = fluidShapeIsBlock = fluidShape == Shapes.block();
        if (selfBlockState.canOcclude() && !BlockOcclusionCache.isEmptyShape(selfShape = selfBlockState.getFaceOcclusionShape(facing))) {
            if (BlockOcclusionCache.isFullShape(selfShape) && fluidShapeIsBlock) {
                return false;
            }
            if (!this.lookup(fluidShape, selfShape)) {
                return false;
            }
        }
        BlockPos.MutableBlockPos otherPos = this.cachedPositionObject;
        otherPos.set(selfPos.getX() + facing.getStepX(), selfPos.getY() + facing.getStepY(), selfPos.getZ() + facing.getStepZ());
        BlockState otherState = view.getBlockState((BlockPos)otherPos);
        if (otherState.getFluidState() == fluid) {
            return false;
        }
        if (PlatformBlockAccess.getInstance().shouldOccludeFluid(facing.getOpposite(), otherState, fluid)) {
            return false;
        }
        if (facing == Direction.UP) {
            return true;
        }
        if (!otherState.canOcclude()) {
            return true;
        }
        VoxelShape otherShape = otherState.getFaceOcclusionShape(facing.getOpposite());
        if (BlockOcclusionCache.isEmptyShape(otherShape)) {
            return true;
        }
        return !BlockOcclusionCache.isFullShape(otherShape) || !fluidShapeIsBlock;
    }

    private boolean lookup(VoxelShape self, VoxelShape other) {
        ShapeComparison comparison = this.cachedComparisonObject;
        comparison.self = self;
        comparison.other = other;
        return switch (this.comparisonLookupTable.getAndMoveToFirst((Object)comparison)) {
            case 0 -> false;
            case 1 -> true;
            default -> this.calculate(comparison);
        };
    }

    private boolean calculate(ShapeComparison comparison) {
        boolean result = Shapes.joinIsNotEmpty((VoxelShape)comparison.self, (VoxelShape)comparison.other, (BooleanOp)BooleanOp.ONLY_FIRST);
        while (this.comparisonLookupTable.size() >= 512) {
            this.comparisonLookupTable.removeLastInt();
        }
        this.comparisonLookupTable.putAndMoveToFirst((Object)comparison.copy(), result ? 1 : 0);
        return result;
    }

    private static final class ShapeComparison {
        private VoxelShape self;
        private VoxelShape other;

        private ShapeComparison() {
        }

        private ShapeComparison(VoxelShape self, VoxelShape other) {
            this.self = self;
            this.other = other;
        }

        public ShapeComparison copy() {
            return new ShapeComparison(this.self, this.other);
        }

        public static class ShapeComparisonStrategy
        implements Hash.Strategy<ShapeComparison> {
            public int hashCode(ShapeComparison value) {
                int result = System.identityHashCode(value.self);
                result = 31 * result + System.identityHashCode(value.other);
                return result;
            }

            public boolean equals(ShapeComparison a, ShapeComparison b) {
                if (a == b) {
                    return true;
                }
                if (a == null || b == null) {
                    return false;
                }
                return a.self == b.self && a.other == b.other;
            }
        }
    }
}

