/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import net.caffeinemc.mods.sodium.client.render.chunk.DefaultChunkRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.ExtendedBlockEntityType;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildContext;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.MeshTaskSizeEstimator;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderCache;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderTask;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionInfo;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortBehavior;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortType;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TranslucentGeometryCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.DynamicData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.PresentTranslucentData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.Sorter;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TranslucentData;
import net.caffeinemc.mods.sodium.client.services.PlatformLevelRenderHooks;
import net.caffeinemc.mods.sodium.client.util.task.CancellationToken;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.caffeinemc.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.joml.Vector3dc;

public class ChunkBuilderMeshingTask
extends ChunkBuilderTask<ChunkBuildOutput> {
    private final ChunkRenderContext renderContext;
    private final SortBehavior sortBehavior;
    private final boolean forceSort;

    public ChunkBuilderMeshingTask(RenderSection render, int buildTime, Vector3dc absoluteCameraPos, ChunkRenderContext renderContext, SortBehavior sortBehavior, boolean forceSort) {
        super(render, buildTime, absoluteCameraPos);
        this.renderContext = renderContext;
        this.sortBehavior = sortBehavior;
        this.forceSort = forceSort;
    }

    @Override
    public ChunkBuildOutput execute(ChunkBuildContext buildContext, CancellationToken cancellationToken) {
        ProfilerFiller profiler = Profiler.get();
        BuiltSectionInfo.Builder renderData = new BuiltSectionInfo.Builder();
        VisGraph occluder = new VisGraph();
        ChunkBuildBuffers buffers = buildContext.buffers;
        buffers.init(renderData, this.render.getSectionIndex());
        BlockRenderCache cache = buildContext.cache;
        cache.init(this.renderContext);
        LevelSlice slice = cache.getWorldSlice();
        int minX = this.render.getOriginX();
        int minY = this.render.getOriginY();
        int minZ = this.render.getOriginZ();
        int maxX = minX + 16;
        int maxY = minY + 16;
        int maxZ = minZ + 16;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(minX, minY, minZ);
        BlockPos.MutableBlockPos modelOffset = new BlockPos.MutableBlockPos();
        boolean sortEnabled = this.sortBehavior != SortBehavior.OFF;
        TranslucentGeometryCollector collector = sortEnabled ? new TranslucentGeometryCollector(this.render.getPosition(), this.sortBehavior) : null;
        BlockRenderer blockRenderer = cache.getBlockRenderer();
        blockRenderer.prepare(buffers, slice, collector);
        profiler.push("render blocks");
        try {
            for (int y = minY; y < maxY; ++y) {
                if (cancellationToken.isCancelled()) {
                    return null;
                }
                for (int z = minZ; z < maxZ; ++z) {
                    for (int x = minX; x < maxX; ++x) {
                        BlockEntityRenderer renderer;
                        TerrainRenderPass[] entity;
                        FluidState fluidState;
                        BlockState blockState = slice.getBlockState(x, y, z);
                        if (blockState.isAir() && !blockState.hasBlockEntity()) continue;
                        blockPos.set(x, y, z);
                        modelOffset.set(x & 0xF, y & 0xF, z & 0xF);
                        if (blockState.getRenderShape() == RenderShape.MODEL) {
                            BlockStateModel model = cache.getBlockModels().getBlockModel(blockState);
                            blockRenderer.renderModel(model, blockState, (BlockPos)blockPos, (BlockPos)modelOffset);
                        }
                        if (!(fluidState = blockState.getFluidState()).isEmpty()) {
                            cache.getFluidRenderer().render(slice, blockState, fluidState, (BlockPos)blockPos, (BlockPos)modelOffset, collector, buffers);
                        }
                        if (blockState.hasBlockEntity() && (entity = slice.getBlockEntity((BlockPos)blockPos)) != null && ExtendedBlockEntityType.shouldRender(entity.getType(), (BlockGetter)slice, (BlockPos)blockPos, entity) && (renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer((BlockEntity)entity)) != null) {
                            renderData.addBlockEntity((BlockEntity)entity, !renderer.shouldRenderOffScreen());
                        }
                        if (!blockState.isSolidRender()) continue;
                        occluder.setOpaque((BlockPos)blockPos);
                    }
                }
            }
        }
        catch (ReportedException ex) {
            throw this.fillCrashInfo(ex.getReport(), slice, (BlockPos)blockPos);
        }
        catch (Exception ex) {
            throw this.fillCrashInfo(CrashReport.forThrowable((Throwable)ex, (String)"Encountered exception while building chunk meshes"), slice, (BlockPos)blockPos);
        }
        profiler.popPush("mesh appenders");
        PlatformLevelRenderHooks.INSTANCE.runChunkMeshAppenders(this.renderContext.getRenderers(), type -> buffers.get(DefaultMaterials.forChunkLayer(type)).asFallbackVertexConsumer(DefaultMaterials.forChunkLayer(type), collector), slice);
        blockRenderer.release();
        SortType sortType = SortType.NONE;
        if (sortEnabled) {
            sortType = collector.finishRendering();
        }
        if (cancellationToken.isCancelled()) {
            profiler.pop();
            return null;
        }
        profiler.popPush("translucency sorting");
        boolean reuseUploadedData = false;
        TranslucentData translucentData = null;
        if (sortEnabled) {
            TranslucentData oldData = this.render.getTranslucentData();
            if (this.forceSort && !(oldData instanceof DynamicData)) {
                oldData = null;
            }
            translucentData = collector.getTranslucentData(oldData, this);
            reuseUploadedData = !this.forceSort && translucentData == oldData;
        }
        profiler.popPush("meshing");
        Reference2ReferenceOpenHashMap meshes = new Reference2ReferenceOpenHashMap();
        int visibleSlices = DefaultChunkRenderer.getVisibleFaces((int)this.absoluteCameraPos.x(), (int)this.absoluteCameraPos.y(), (int)this.absoluteCameraPos.z(), this.render.getChunkX(), this.render.getChunkY(), this.render.getChunkZ());
        if (translucentData != null && translucentData.meshesWereModified()) {
            meshes.put(DefaultTerrainRenderPasses.TRANSLUCENT, buffers.createModifiedTranslucentMesh(translucentData.getUpdatedQuads()));
            renderData.addRenderPass(DefaultTerrainRenderPasses.TRANSLUCENT);
        }
        for (TerrainRenderPass pass : DefaultTerrainRenderPasses.ALL) {
            boolean sliceReordering;
            boolean translucentBehavior;
            boolean forceUnassigned;
            BuiltSectionMeshParts mesh;
            if (meshes.containsKey(pass) || (mesh = buffers.createMesh(pass, visibleSlices, forceUnassigned = (translucentBehavior = sortEnabled && pass.isTranslucent()) && sortType.needsDirectionMixing, sliceReordering = !translucentBehavior || sortType.allowSliceReordering)) == null) continue;
            meshes.put(pass, mesh);
            renderData.addRenderPass(pass);
        }
        renderData.setOcclusionData(occluder.resolve());
        ChunkBuildOutput output = new ChunkBuildOutput(this.render, this.submitTime, translucentData, renderData.build(), (Map<TerrainRenderPass, BuiltSectionMeshParts>)meshes);
        if (sortEnabled) {
            if (reuseUploadedData) {
                output.markAsReusingUploadedData();
            } else if (translucentData instanceof PresentTranslucentData) {
                PresentTranslucentData present = (PresentTranslucentData)translucentData;
                Sorter sorter = present.getSorter();
                sorter.writeIndexBuffer(this, true);
                output.setSorter(sorter);
            }
        }
        profiler.pop();
        return output;
    }

    private ReportedException fillCrashInfo(CrashReport report, LevelSlice slice, BlockPos pos) {
        CrashReportCategory crashReportSection = report.addCategory("Block being rendered", 1);
        BlockState state = null;
        try {
            state = slice.getBlockState(pos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CrashReportCategory.populateBlockDetails((CrashReportCategory)crashReportSection, (LevelHeightAccessor)slice, (BlockPos)pos, (BlockState)state);
        crashReportSection.setDetail("Chunk section", (Object)this.render);
        if (this.renderContext != null) {
            crashReportSection.setDetail("Render context volume", (Object)this.renderContext.getVolume());
        }
        return new ReportedException(report);
    }

    @Override
    public long estimateTaskSizeWith(MeshTaskSizeEstimator estimator) {
        return estimator.estimateSize(this.render);
    }
}

