/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.terrain.material;

import net.caffeinemc.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.Material;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.parameters.AlphaCutoffParameter;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class DefaultMaterials {
    public static final Material SOLID = new Material(DefaultTerrainRenderPasses.SOLID, AlphaCutoffParameter.ZERO, true);
    public static final Material CUTOUT = new Material(DefaultTerrainRenderPasses.CUTOUT, AlphaCutoffParameter.ONE_TENTH, false);
    public static final Material CUTOUT_MIPPED = new Material(DefaultTerrainRenderPasses.CUTOUT, AlphaCutoffParameter.HALF, true);
    public static final Material TRANSLUCENT = new Material(DefaultTerrainRenderPasses.TRANSLUCENT, AlphaCutoffParameter.ZERO, true);
    public static final Material TRIPWIRE = new Material(DefaultTerrainRenderPasses.TRANSLUCENT, AlphaCutoffParameter.ONE_TENTH, true);

    public static Material forBlockState(BlockState state) {
        return DefaultMaterials.forChunkLayer(ItemBlockRenderTypes.getChunkRenderType((BlockState)state));
    }

    public static Material forFluidState(FluidState state) {
        return DefaultMaterials.forChunkLayer(ItemBlockRenderTypes.getRenderLayer((FluidState)state));
    }

    public static Material forRenderLayer(RenderType layer) {
        if (layer == RenderType.solid()) {
            return SOLID;
        }
        if (layer == RenderType.cutout()) {
            return CUTOUT;
        }
        if (layer == RenderType.cutoutMipped()) {
            return CUTOUT_MIPPED;
        }
        if (layer == RenderType.tripwire()) {
            return TRIPWIRE;
        }
        if (layer == RenderType.translucentMovingBlock()) {
            return TRANSLUCENT;
        }
        throw new IllegalArgumentException("No material mapping exists for " + String.valueOf(layer));
    }

    public static Material forChunkLayer(ChunkSectionLayer layer) {
        return switch (layer) {
            default -> throw new MatchException(null, null);
            case ChunkSectionLayer.SOLID -> SOLID;
            case ChunkSectionLayer.CUTOUT_MIPPED -> CUTOUT_MIPPED;
            case ChunkSectionLayer.CUTOUT -> CUTOUT;
            case ChunkSectionLayer.TRANSLUCENT -> TRANSLUCENT;
            case ChunkSectionLayer.TRIPWIRE -> TRIPWIRE;
        };
    }
}

