/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data;

import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.QuadSplittingMode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortType;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TranslucentGeometryCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.BSPNode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.BSPResult;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.UpdatedQuadsList;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.CombinedCameraPos;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.DynamicData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.DynamicSorter;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TranslucentData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.quad.TQuad;
import net.minecraft.core.SectionPos;
import org.joml.Vector3dc;

public class DynamicBSPData
extends DynamicData {
    private static final int NODE_REUSE_MIN_GENERATION = 1;
    private final int indexQuadCount;
    private final BSPNode rootNode;
    private final int generation;
    private final UpdatedQuadsList updatedQuadsList;

    private DynamicBSPData(SectionPos sectionPos, int inputQuadCount, BSPResult result, Vector3dc initialCameraPos, int generation) {
        super(sectionPos, inputQuadCount, result, initialCameraPos);
        this.rootNode = result.getRootNode();
        this.generation = generation;
        this.updatedQuadsList = result.getUpdatedQuadsList();
        this.indexQuadCount = this.updatedQuadsList != null ? this.updatedQuadsList.getIndexQuadCount() : inputQuadCount;
    }

    @Override
    public boolean oldDataMatches(TranslucentGeometryCollector collector, SortType sortType, TQuad[] quads) {
        return !this.meshesWereModified() && super.oldDataMatches(collector, sortType, quads);
    }

    @Override
    public int getIndexQuadCount() {
        return this.indexQuadCount;
    }

    @Override
    public DynamicSorter getSorter() {
        return new DynamicBSPSorter(this.getIndexQuadCount());
    }

    @Override
    public UpdatedQuadsList getUpdatedQuads() {
        return this.updatedQuadsList;
    }

    public static DynamicBSPData fromMesh(CombinedCameraPos cameraPos, TQuad[] quads, SectionPos sectionPos, TranslucentData oldData, QuadSplittingMode quadSplittingMode) {
        BSPNode oldRoot = null;
        int generation = 0;
        boolean prepareNodeReuse = false;
        if (oldData instanceof DynamicBSPData) {
            DynamicBSPData oldBSPData = (DynamicBSPData)oldData;
            generation = oldBSPData.generation + 1;
            oldRoot = oldBSPData.rootNode;
            prepareNodeReuse = generation >= 1;
        }
        BSPResult result = BSPNode.buildBSP(quads, sectionPos, oldRoot, prepareNodeReuse, quadSplittingMode);
        DynamicBSPData dynamicData = new DynamicBSPData(sectionPos, quads.length, result, cameraPos.getAbsoluteCameraPos(), generation);
        result.prepareIntegration();
        return dynamicData;
    }

    private class DynamicBSPSorter
    extends DynamicSorter {
        private DynamicBSPSorter(int quadCount) {
            super(quadCount);
        }

        @Override
        void writeSort(CombinedCameraPos cameraPos, boolean initial) {
            DynamicBSPData.this.rootNode.collectSortedQuads(this.getIndexBuffer(), cameraPos.getRelativeCameraPos());
        }
    }
}

