/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.MatrixUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.caffeinemc.mods.sodium.api.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.api.util.ColorMixer;
import net.caffeinemc.mods.sodium.client.render.frapi.helper.ColorHelper;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.EncodingFormat;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.MeshViewImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.MutableQuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.render.AbstractRenderContext;
import net.caffeinemc.mods.sodium.client.render.frapi.render.QuadEncoder;
import net.caffeinemc.mods.sodium.client.render.texture.SpriteFinderCache;
import net.caffeinemc.mods.sodium.mixin.features.render.frapi.ItemRendererAccessor;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderLayerHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ItemRenderContext
extends AbstractRenderContext {
    public static final ThreadLocal<ItemRenderContext> POOL = ThreadLocal.withInitial(ItemRenderContext::new);
    private static final long ITEM_RANDOM_SEED = 42L;
    private static final int GLINT_COUNT = ItemStackRenderState.FoilType.values().length;
    private final MutableQuadViewImpl editorQuad = new ItemEmitter();
    private final RandomSource random = new SingleThreadedRandomSource(42L);
    private final Supplier<RandomSource> randomSupplier = () -> {
        this.random.setSeed(42L);
        return this.random;
    };
    private ItemDisplayContext transformMode;
    private PoseStack poseStack;
    private Matrix4f matPosition;
    private boolean trustedNormals;
    private Matrix3f matNormal;
    private MultiBufferSource bufferSource;
    private int lightmap;
    private int overlay;
    private int[] colors;
    private RenderType defaultLayer;
    private ItemStackRenderState.FoilType defaultGlint;
    private PoseStack.Pose specialGlintEntry;
    private final VertexConsumer[] vertexConsumerCache = new VertexConsumer[3 * GLINT_COUNT];

    @Override
    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    public void renderItem(ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int lightmap, int overlay, int[] colors, List<BakedQuad> vanillaQuads, MeshViewImpl mesh, RenderType layer, ItemStackRenderState.FoilType glint) {
        this.transformMode = displayContext;
        this.matPosition = poseStack.last().pose();
        this.poseStack = poseStack;
        this.trustedNormals = this.poseStack.last().trustedNormals;
        this.matNormal = this.poseStack.last().normal();
        this.bufferSource = bufferSource;
        this.lightmap = lightmap;
        this.overlay = overlay;
        this.colors = colors;
        this.defaultLayer = layer;
        this.defaultGlint = glint;
        this.bufferQuads(vanillaQuads, mesh);
        this.poseStack = null;
        this.bufferSource = null;
        this.colors = null;
        this.specialGlintEntry = null;
        Arrays.fill(this.vertexConsumerCache, null);
    }

    private void bufferQuads(List<BakedQuad> vanillaQuads, MeshViewImpl mesh) {
        QuadEmitter emitter = this.getEmitter();
        int vanillaQuadCount = vanillaQuads.size();
        for (int j = 0; j < vanillaQuadCount; ++j) {
            BakedQuad q = vanillaQuads.get(j);
            emitter.fromBakedQuad(q);
            emitter.emit();
        }
        mesh.outputTo(emitter);
    }

    private void renderQuad(MutableQuadViewImpl quad) {
        boolean emissive = quad.emissive();
        VertexConsumer vertexConsumer = this.getVertexConsumer(quad.renderLayer(), quad.glint());
        this.tintQuad(quad);
        this.shadeQuad(quad, emissive);
        this.bufferQuad(quad, vertexConsumer);
    }

    private void tintQuad(MutableQuadViewImpl quad) {
        int tintIndex = quad.tintIndex();
        if (tintIndex != -1 && tintIndex < this.colors.length) {
            int color = this.colors[tintIndex];
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorMixer.mulComponentWise(color, quad.color(i)));
            }
        }
    }

    private void shadeQuad(MutableQuadViewImpl quad, boolean emissive) {
        if (emissive) {
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, 0xF000F0);
            }
        } else {
            int lightmap = this.lightmap;
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), lightmap));
            }
        }
    }

    private void bufferQuad(MutableQuadViewImpl quad, VertexConsumer vertexConsumer) {
        QuadEncoder.writeQuadVertices(quad, vertexConsumer, this.overlay, this.matPosition, this.trustedNormals, this.matNormal);
        TextureAtlasSprite sprite = quad.sprite(SpriteFinderCache.forBlockAtlas());
        if (sprite != null) {
            SpriteUtil.INSTANCE.markSpriteActive(sprite);
        }
    }

    private VertexConsumer getVertexConsumer(@Nullable ChunkSectionLayer blendMode, @Nullable ItemStackRenderState.FoilType glintMode) {
        RenderType type = blendMode == null ? this.defaultLayer : RenderLayerHelper.getEntityBlockLayer((ChunkSectionLayer)blendMode);
        ItemStackRenderState.FoilType glint = glintMode == null ? this.defaultGlint : glintMode;
        int cacheIndex = type == Sheets.translucentItemSheet() ? 0 : (type == Sheets.cutoutBlockSheet() ? GLINT_COUNT : 2 * GLINT_COUNT);
        VertexConsumer vertexConsumer = this.vertexConsumerCache[cacheIndex += glint.ordinal()];
        if (vertexConsumer == null) {
            this.vertexConsumerCache[cacheIndex] = vertexConsumer = this.createVertexConsumer(type, glint);
        }
        return vertexConsumer;
    }

    private VertexConsumer createVertexConsumer(RenderType type, ItemStackRenderState.FoilType glint) {
        if (glint == ItemStackRenderState.FoilType.SPECIAL) {
            if (this.specialGlintEntry == null) {
                this.specialGlintEntry = this.poseStack.last().copy();
                if (this.transformMode == ItemDisplayContext.GUI) {
                    MatrixUtil.mulComponentWise((Matrix4f)this.specialGlintEntry.pose(), (float)0.5f);
                } else if (this.transformMode.firstPerson()) {
                    MatrixUtil.mulComponentWise((Matrix4f)this.specialGlintEntry.pose(), (float)0.75f);
                }
            }
            return ItemRendererAccessor.sodium$getSpecialFoilBuffer(this.bufferSource, type, this.specialGlintEntry);
        }
        return ItemRenderer.getFoilBuffer((MultiBufferSource)this.bufferSource, (RenderType)type, (boolean)true, (glint != ItemStackRenderState.FoilType.NONE ? 1 : 0) != 0);
    }

    public class ItemEmitter
    extends MutableQuadViewImpl {
        public ItemEmitter() {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        public void emitDirectly() {
            ItemRenderContext.this.renderQuad(this);
        }

        public boolean hasTransforms() {
            return this.activeTransform != NO_TRANSFORM;
        }
    }

    @FunctionalInterface
    public static interface VanillaModelBufferer {
        public void accept(BlockStateModel var1, int[] var2, int var3, int var4, PoseStack var5, VertexConsumer var6);
    }
}

