/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.caffeinemc.mods.sodium.api.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.client.render.frapi.helper.ColorHelper;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.MutableQuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.render.AbstractBlockRenderContext;
import net.caffeinemc.mods.sodium.client.render.frapi.render.QuadEncoder;
import net.caffeinemc.mods.sodium.client.render.texture.SpriteFinderCache;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBlockStateModel;
import net.fabricmc.fabric.api.renderer.v1.render.BlockVertexConsumerProvider;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SimpleBlockRenderContext
extends AbstractBlockRenderContext {
    public static final ThreadLocal<SimpleBlockRenderContext> POOL = ThreadLocal.withInitial(SimpleBlockRenderContext::new);
    private final RandomSource random = RandomSource.createNewThreadLocalInstance();
    private BlockVertexConsumerProvider vertexConsumers;
    private float red;
    private float green;
    private float blue;
    private int light;
    @Nullable
    private ChunkSectionLayer lastRenderLayer;
    @Nullable
    private VertexConsumer lastVertexConsumer;
    private PoseStack.Pose matrices;
    private int overlay;

    @Override
    protected void processQuad(MutableQuadViewImpl quad) {
        VertexConsumer vertexConsumer;
        ChunkSectionLayer renderLayer;
        ChunkSectionLayer quadRenderLayer = quad.renderLayer();
        ChunkSectionLayer chunkSectionLayer = renderLayer = quadRenderLayer == null ? this.defaultRenderType : quadRenderLayer;
        if (renderLayer == this.lastRenderLayer) {
            vertexConsumer = this.lastVertexConsumer;
        } else {
            this.lastVertexConsumer = vertexConsumer = this.vertexConsumers.getBuffer(renderLayer);
            this.lastRenderLayer = renderLayer;
        }
        if (quad.tintIndex() != -1) {
            float red = this.red;
            float green = this.green;
            float blue = this.blue;
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ARGB.scaleRGB((int)quad.color(i), (float)red, (float)green, (float)blue));
            }
        }
        if (quad.emissive()) {
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, 0xF000F0);
            }
        } else {
            int light = this.light;
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), light));
            }
        }
        QuadEncoder.writeQuadVertices(quad, vertexConsumer, this.overlay, this.matrices.pose(), this.matrices.trustedNormals, this.matrices.normal());
        SpriteUtil.INSTANCE.markSpriteActive(quad.sprite(SpriteFinderCache.forBlockAtlas()));
    }

    private RenderType toRenderLayer(ChunkSectionLayer defaultRenderType) {
        return switch (defaultRenderType) {
            default -> throw new MatchException(null, null);
            case ChunkSectionLayer.SOLID -> RenderType.solid();
            case ChunkSectionLayer.CUTOUT_MIPPED -> RenderType.cutoutMipped();
            case ChunkSectionLayer.CUTOUT -> RenderType.cutout();
            case ChunkSectionLayer.TRANSLUCENT -> RenderType.translucentMovingBlock();
            case ChunkSectionLayer.TRIPWIRE -> RenderType.tripwire();
        };
    }

    public void bufferModel(PoseStack.Pose entry, BlockVertexConsumerProvider vertexConsumers, BlockStateModel model, float red, float green, float blue, int light, int overlay, BlockAndTintGetter blockView, BlockPos pos, BlockState state) {
        this.matrices = entry;
        this.overlay = overlay;
        this.prepareAoInfo(true);
        this.vertexConsumers = vertexConsumers;
        this.defaultRenderType = ItemBlockRenderTypes.getChunkRenderType((BlockState)state);
        this.red = Mth.clamp((float)red, (float)0.0f, (float)1.0f);
        this.green = Mth.clamp((float)green, (float)0.0f, (float)1.0f);
        this.blue = Mth.clamp((float)blue, (float)0.0f, (float)1.0f);
        this.light = light;
        this.level = blockView;
        this.state = state;
        this.pos = pos;
        this.random.setSeed(42L);
        ((FabricBlockStateModel)model).emitQuads(this.getEmitter(), blockView, pos, state, this.random, cullFace -> false);
        this.level = null;
        this.state = null;
        this.pos = null;
        this.vertexConsumers = null;
        this.lastRenderLayer = null;
        this.lastVertexConsumer = null;
    }
}

