/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.immediate.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.EntityVertex;
import net.caffeinemc.mods.sodium.client.render.immediate.model.ModelCuboid;
import net.caffeinemc.mods.sodium.client.util.Int2;
import net.minecraft.core.Direction;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EntityRenderer {
    private static final Matrix3f prevNormalMatrix = new Matrix3f();
    private static final int VERTEX_BUFFER_BYTES = 864;
    private static final long[] CUBE_VERTEX_XY = new long[8];
    private static final long[] CUBE_VERTEX_ZW = new long[8];
    private static final int[] CUBE_FACE_NORMAL = new int[6];

    public static void renderCuboid(PoseStack.Pose matrices, VertexBufferWriter writer, ModelCuboid cuboid, int light, int overlay, int color) {
        EntityRenderer.prepareVertices(matrices, cuboid, color);
        EntityRenderer.prepareNormalsIfChanged(matrices);
        try (MemoryStack stack = MemoryStack.stackPush();){
            long vertexBuffer = stack.nmalloc(64, 864);
            int vertexCount = EntityRenderer.emitQuads(vertexBuffer, cuboid, overlay, light);
            if (vertexCount > 0) {
                writer.push(stack, vertexBuffer, vertexCount, EntityVertex.FORMAT);
            }
        }
    }

    private static int emitQuads(long buffer, ModelCuboid cuboid, int overlay, int light) {
        long packedOverlayLight = Int2.pack(overlay, light);
        long ptr = buffer;
        int[] normals = cuboid.normals;
        int[] positions = cuboid.positions;
        long[] textures = cuboid.textures;
        int vertexCount = 0;
        for (int faceIndex = 0; faceIndex < 6; ++faceIndex) {
            if (!cuboid.shouldDrawFace(faceIndex)) continue;
            int elementOffset = faceIndex * 4;
            int packedNormal = CUBE_FACE_NORMAL[normals[faceIndex]];
            ptr = EntityRenderer.writeVertex(ptr, positions[elementOffset + 0], textures[elementOffset + 0], packedOverlayLight, packedNormal);
            ptr = EntityRenderer.writeVertex(ptr, positions[elementOffset + 1], textures[elementOffset + 1], packedOverlayLight, packedNormal);
            ptr = EntityRenderer.writeVertex(ptr, positions[elementOffset + 2], textures[elementOffset + 2], packedOverlayLight, packedNormal);
            ptr = EntityRenderer.writeVertex(ptr, positions[elementOffset + 3], textures[elementOffset + 3], packedOverlayLight, packedNormal);
            vertexCount += 4;
        }
        return vertexCount;
    }

    private static long writeVertex(long ptr, int vertexIndex, long packedUv, long packedOverlayLight, int packedNormal) {
        MemoryUtil.memPutLong((long)(ptr + 0L), (long)CUBE_VERTEX_XY[vertexIndex]);
        MemoryUtil.memPutLong((long)(ptr + 8L), (long)CUBE_VERTEX_ZW[vertexIndex]);
        MemoryUtil.memPutLong((long)(ptr + 16L), (long)packedUv);
        MemoryUtil.memPutLong((long)(ptr + 24L), (long)packedOverlayLight);
        MemoryUtil.memPutInt((long)(ptr + 32L), (int)packedNormal);
        return ptr + 36L;
    }

    private static void prepareVertices(PoseStack.Pose matrices, ModelCuboid cuboid, int color) {
        Matrix4f pose = matrices.pose();
        float vxx = pose.m00() * cuboid.sizeX;
        float vxy = pose.m01() * cuboid.sizeX;
        float vxz = pose.m02() * cuboid.sizeX;
        float vyx = pose.m10() * cuboid.sizeY;
        float vyy = pose.m11() * cuboid.sizeY;
        float vyz = pose.m12() * cuboid.sizeY;
        float vzx = pose.m20() * cuboid.sizeZ;
        float vzy = pose.m21() * cuboid.sizeZ;
        float vzz = pose.m22() * cuboid.sizeZ;
        float c000x = MatrixHelper.transformPositionX((Matrix4fc)pose, cuboid.originX, cuboid.originY, cuboid.originZ);
        float c000y = MatrixHelper.transformPositionY((Matrix4fc)pose, cuboid.originX, cuboid.originY, cuboid.originZ);
        float c000z = MatrixHelper.transformPositionZ((Matrix4fc)pose, cuboid.originX, cuboid.originY, cuboid.originZ);
        EntityRenderer.setVertex(0, c000x, c000y, c000z, color);
        float c100x = c000x + vxx;
        float c100y = c000y + vxy;
        float c100z = c000z + vxz;
        EntityRenderer.setVertex(1, c100x, c100y, c100z, color);
        float c110x = c100x + vyx;
        float c110y = c100y + vyy;
        float c110z = c100z + vyz;
        EntityRenderer.setVertex(2, c110x, c110y, c110z, color);
        float c010x = c000x + vyx;
        float c010y = c000y + vyy;
        float c010z = c000z + vyz;
        EntityRenderer.setVertex(3, c010x, c010y, c010z, color);
        float c001x = c000x + vzx;
        float c001y = c000y + vzy;
        float c001z = c000z + vzz;
        EntityRenderer.setVertex(4, c001x, c001y, c001z, color);
        float c101x = c100x + vzx;
        float c101y = c100y + vzy;
        float c101z = c100z + vzz;
        EntityRenderer.setVertex(5, c101x, c101y, c101z, color);
        float c111x = c110x + vzx;
        float c111y = c110y + vzy;
        float c111z = c110z + vzz;
        EntityRenderer.setVertex(6, c111x, c111y, c111z, color);
        float c011x = c010x + vzx;
        float c011y = c010y + vzy;
        float c011z = c010z + vzz;
        EntityRenderer.setVertex(7, c011x, c011y, c011z, color);
    }

    private static void setVertex(int vertexIndex, float x, float y, float z, int color) {
        EntityRenderer.CUBE_VERTEX_XY[vertexIndex] = Int2.pack(Float.floatToRawIntBits(x), Float.floatToRawIntBits(y));
        EntityRenderer.CUBE_VERTEX_ZW[vertexIndex] = Int2.pack(Float.floatToRawIntBits(z), color);
    }

    private static void prepareNormalsIfChanged(PoseStack.Pose matrices) {
        if (matrices.normal().equals((Object)prevNormalMatrix)) {
            return;
        }
        EntityRenderer.CUBE_FACE_NORMAL[0] = MatrixHelper.transformNormal(matrices.normal(), matrices.trustedNormals, Direction.DOWN);
        EntityRenderer.CUBE_FACE_NORMAL[1] = MatrixHelper.transformNormal(matrices.normal(), matrices.trustedNormals, Direction.UP);
        EntityRenderer.CUBE_FACE_NORMAL[3] = MatrixHelper.transformNormal(matrices.normal(), matrices.trustedNormals, Direction.NORTH);
        EntityRenderer.CUBE_FACE_NORMAL[5] = MatrixHelper.transformNormal(matrices.normal(), matrices.trustedNormals, Direction.SOUTH);
        EntityRenderer.CUBE_FACE_NORMAL[4] = MatrixHelper.transformNormal(matrices.normal(), matrices.trustedNormals, Direction.WEST);
        EntityRenderer.CUBE_FACE_NORMAL[2] = MatrixHelper.transformNormal(matrices.normal(), matrices.trustedNormals, Direction.EAST);
        prevNormalMatrix.set((Matrix3fc)matrices.normal());
    }
}

