/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.world.biome;

import net.caffeinemc.mods.sodium.client.world.BiomeSeedProvider;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.caffeinemc.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.caffeinemc.mods.sodium.client.world.cloned.ClonedChunkSection;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.PalettedContainerRO;

public class LevelBiomeSlice {
    private static final int SIZE = 12;
    private final Holder<Biome>[] biomes = new Holder[1728];
    private final boolean[] uniform = new boolean[1728];
    private final BiasMap bias = new BiasMap();
    private long biomeZoomSeed;
    private int blockX;
    private int blockY;
    private int blockZ;

    public void update(ClientLevel level, ChunkRenderContext context) {
        this.blockX = context.getOrigin().minBlockX() - 16;
        this.blockY = context.getOrigin().minBlockY() - 16;
        this.blockZ = context.getOrigin().minBlockZ() - 16;
        this.biomeZoomSeed = BiomeSeedProvider.getBiomeZoomSeed(level);
        this.copyBiomeData((Level)level, context);
        this.calculateBias();
        this.calculateUniform();
    }

    private void copyBiomeData(Level level, ChunkRenderContext context) {
        Holder.Reference defaultValue = level.registryAccess().lookupOrThrow(Registries.BIOME).getOrThrow(Biomes.PLAINS);
        for (int sectionX = 0; sectionX < 3; ++sectionX) {
            for (int sectionY = 0; sectionY < 3; ++sectionY) {
                for (int sectionZ = 0; sectionZ < 3; ++sectionZ) {
                    this.copySectionBiomeData(context, sectionX, sectionY, sectionZ, (Holder<Biome>)defaultValue);
                }
            }
        }
    }

    private void copySectionBiomeData(ChunkRenderContext context, int sectionX, int sectionY, int sectionZ, Holder<Biome> defaultBiome) {
        ClonedChunkSection section = context.getSections()[LevelSlice.getLocalSectionIndex(sectionX, sectionY, sectionZ)];
        PalettedContainerRO<Holder<Biome>> biomeData = section.getBiomeData();
        for (int relCellX = 0; relCellX < 4; ++relCellX) {
            for (int relCellY = 0; relCellY < 4; ++relCellY) {
                for (int relCellZ = 0; relCellZ < 4; ++relCellZ) {
                    int cellX = sectionX * 4 + relCellX;
                    int cellY = sectionY * 4 + relCellY;
                    int cellZ = sectionZ * 4 + relCellZ;
                    int idx = LevelBiomeSlice.dataArrayIndex(cellX, cellY, cellZ);
                    this.biomes[idx] = biomeData == null ? defaultBiome : (Holder)biomeData.get(relCellX, relCellY, relCellZ);
                }
            }
        }
    }

    private void calculateUniform() {
        for (int cellX = 2; cellX < 10; ++cellX) {
            for (int cellY = 2; cellY < 10; ++cellY) {
                for (int cellZ = 2; cellZ < 10; ++cellZ) {
                    this.uniform[LevelBiomeSlice.dataArrayIndex((int)cellX, (int)cellY, (int)cellZ)] = this.hasUniformNeighbors(cellX, cellY, cellZ);
                }
            }
        }
    }

    private void calculateBias() {
        int originX = this.blockX >> 2;
        int originY = this.blockY >> 2;
        int originZ = this.blockZ >> 2;
        long seed = this.biomeZoomSeed;
        for (int relCellX = 1; relCellX < 11; ++relCellX) {
            int cellX = originX + relCellX;
            long seedX = LinearCongruentialGenerator.next((long)seed, (long)cellX);
            for (int relCellY = 1; relCellY < 11; ++relCellY) {
                int cellY = originY + relCellY;
                long seedXY = LinearCongruentialGenerator.next((long)seedX, (long)cellY);
                for (int relCellZ = 1; relCellZ < 11; ++relCellZ) {
                    int cellZ = originZ + relCellZ;
                    long seedXYZ = LinearCongruentialGenerator.next((long)seedXY, (long)cellZ);
                    this.calculateBias(LevelBiomeSlice.dataArrayIndex(relCellX, relCellY, relCellZ), cellX, cellY, cellZ, seedXYZ);
                }
            }
        }
    }

    private void calculateBias(int cellIndex, int cellX, int cellY, int cellZ, long seed) {
        seed = LinearCongruentialGenerator.next((long)seed, (long)cellX);
        seed = LinearCongruentialGenerator.next((long)seed, (long)cellY);
        seed = LinearCongruentialGenerator.next((long)seed, (long)cellZ);
        int gradX = LevelBiomeSlice.getBias(seed);
        seed = LinearCongruentialGenerator.next((long)seed, (long)this.biomeZoomSeed);
        int gradY = LevelBiomeSlice.getBias(seed);
        seed = LinearCongruentialGenerator.next((long)seed, (long)this.biomeZoomSeed);
        int gradZ = LevelBiomeSlice.getBias(seed);
        this.bias.set(cellIndex, gradX, gradY, gradZ);
    }

    private boolean hasUniformNeighbors(int cellX, int cellY, int cellZ) {
        Biome biome = (Biome)this.biomes[LevelBiomeSlice.dataArrayIndex(cellX, cellY, cellZ)].value();
        int cellMinX = cellX - 1;
        int cellMaxX = cellX + 1;
        int cellMinY = cellY - 1;
        int cellMaxY = cellY + 1;
        int cellMinZ = cellZ - 1;
        int cellMaxZ = cellZ + 1;
        for (int adjCellX = cellMinX; adjCellX <= cellMaxX; ++adjCellX) {
            for (int adjCellY = cellMinY; adjCellY <= cellMaxY; ++adjCellY) {
                for (int adjCellZ = cellMinZ; adjCellZ <= cellMaxZ; ++adjCellZ) {
                    if (this.biomes[LevelBiomeSlice.dataArrayIndex(adjCellX, adjCellY, adjCellZ)].value() == biome) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Holder<Biome> getBiome(int blockX, int blockY, int blockZ) {
        int relBlockX = blockX - this.blockX;
        int relBlockY = blockY - this.blockY;
        int relBlockZ = blockZ - this.blockZ;
        int centerIndex = LevelBiomeSlice.dataArrayIndex(QuartPos.fromBlock((int)(relBlockX - 2)), QuartPos.fromBlock((int)(relBlockY - 2)), QuartPos.fromBlock((int)(relBlockZ - 2)));
        if (this.uniform[centerIndex]) {
            return this.biomes[centerIndex];
        }
        return this.getBiomeUsingVoronoi(relBlockX, relBlockY, relBlockZ);
    }

    private Holder<Biome> getBiomeUsingVoronoi(int blockX, int blockY, int blockZ) {
        int x = blockX - 2;
        int y = blockY - 2;
        int z = blockZ - 2;
        int originIntX = QuartPos.fromBlock((int)x);
        int originIntY = QuartPos.fromBlock((int)y);
        int originIntZ = QuartPos.fromBlock((int)z);
        float originFracX = (float)QuartPos.quartLocal((int)x) * 0.25f;
        float originFracY = (float)QuartPos.quartLocal((int)y) * 0.25f;
        float originFracZ = (float)QuartPos.quartLocal((int)z) * 0.25f;
        float closestDistance = Float.POSITIVE_INFINITY;
        int closestArrayIndex = 0;
        for (int index = 0; index < 8; ++index) {
            float distanceZ;
            float distanceY;
            boolean dirX = (index & 4) != 0;
            boolean dirY = (index & 2) != 0;
            boolean dirZ = (index & 1) != 0;
            int cellIntX = originIntX + (dirX ? 1 : 0);
            int cellIntY = originIntY + (dirY ? 1 : 0);
            int cellIntZ = originIntZ + (dirZ ? 1 : 0);
            float cellFracX = originFracX - (dirX ? 1.0f : 0.0f);
            float cellFracY = originFracY - (dirY ? 1.0f : 0.0f);
            float cellFracZ = originFracZ - (dirZ ? 1.0f : 0.0f);
            int biasIndex = LevelBiomeSlice.dataArrayIndex(cellIntX, cellIntY, cellIntZ);
            float biasX = LevelBiomeSlice.biasToVector(this.bias.getX(biasIndex));
            float biasY = LevelBiomeSlice.biasToVector(this.bias.getY(biasIndex));
            float biasZ = LevelBiomeSlice.biasToVector(this.bias.getZ(biasIndex));
            float distanceX = Mth.square((float)(cellFracX + biasX));
            float distance = distanceX + (distanceY = Mth.square((float)(cellFracY + biasY))) + (distanceZ = Mth.square((float)(cellFracZ + biasZ)));
            if (!(closestDistance > distance)) continue;
            closestArrayIndex = biasIndex;
            closestDistance = distance;
        }
        return this.biomes[closestArrayIndex];
    }

    private static int dataArrayIndex(int cellX, int cellY, int cellZ) {
        return cellX * 12 * 12 + cellY * 12 + cellZ;
    }

    private static float biasToVector(int bias) {
        return (float)bias * 9.765625E-4f * 0.9f;
    }

    private static int getBias(long l) {
        return (int)((l >> 24 & 0x3FFL) - 512L);
    }

    public static class BiasMap {
        private final short[] data = new short[5184];

        public void set(int index, int x, int y, int z) {
            this.data[index * 3 + 0] = (short)x;
            this.data[index * 3 + 1] = (short)y;
            this.data[index * 3 + 2] = (short)z;
        }

        public int getX(int index) {
            return this.data[index * 3 + 0];
        }

        public int getY(int index) {
            return this.data[index * 3 + 1];
        }

        public int getZ(int index) {
            return this.data[index * 3 + 2];
        }
    }
}

