/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.gui.hooks.console;

import net.caffeinemc.mods.sodium.client.gui.console.ConsoleHooks;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.util.profiling.Profiler;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public class GameRendererMixin {
    @Shadow
    @Final
    Minecraft minecraft;
    @Shadow
    @Final
    private RenderBuffers renderBuffers;
    @Shadow
    @Final
    private GuiRenderState guiRenderState;
    @Unique
    private static boolean HAS_RENDERED_OVERLAY_ONCE = false;

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/render/GuiRenderer;render(Lcom/mojang/blaze3d/buffers/GpuBufferSlice;)V")})
    private void onRender(DeltaTracker deltaTracker, boolean bl, CallbackInfo ci) {
        if (Minecraft.getInstance().getOverlay() != null && !HAS_RENDERED_OVERLAY_ONCE) {
            return;
        }
        Profiler.get().push("sodium_console_overlay");
        GuiGraphics drawContext = new GuiGraphics(this.minecraft, this.guiRenderState);
        ConsoleHooks.render(drawContext, GLFW.glfwGetTime());
        Profiler.get().pop();
        HAS_RENDERED_OVERLAY_ONCE = true;
    }
}

