/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.render.model.block;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.caffeinemc.mods.sodium.api.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.client.model.quad.BakedQuadView;
import net.caffeinemc.mods.sodium.client.render.immediate.model.BakedModelEncoder;
import net.caffeinemc.mods.sodium.client.util.DirectionUtil;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.neoforged.neoforge.client.RenderTypeHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelBlockRenderer.class})
public class ModelBlockRendererMixin {
    @Unique
    private static final ThreadLocal<RandomSource> RANDOM = ThreadLocal.withInitial(() -> new SingleThreadedRandomSource(42L));
    @Unique
    private static final ThreadLocal<List<BlockModelPart>> LIST = ThreadLocal.withInitial(() -> new ObjectArrayList());

    @Unique
    private static void renderQuads(PoseStack.Pose matrices, VertexBufferWriter writer, int defaultColor, List<BakedQuad> quads, int light, int overlay) {
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad bakedQuad = quads.get(i);
            if (bakedQuad.vertices().length < 32) continue;
            BakedQuadView quad = (BakedQuadView)bakedQuad;
            int color = quad.hasColor() ? defaultColor : -1;
            BakedModelEncoder.writeQuadVertices(writer, matrices, quad, color, light, overlay, false);
            if (quad.getSprite() == null) continue;
            SpriteUtil.INSTANCE.markSpriteActive(quad.getSprite());
        }
    }

    @Inject(method={"renderModel(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/client/renderer/block/model/BlockStateModel;FFFIILnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderFast(PoseStack.Pose entry, MultiBufferSource bufferSource, BlockStateModel bakedModel, float red, float green, float blue, int light, int overlay, BlockAndTintGetter level, BlockPos pos, BlockState state, CallbackInfo ci) {
        RandomSource random = RANDOM.get();
        red = Mth.clamp((float)red, (float)0.0f, (float)1.0f);
        green = Mth.clamp((float)green, (float)0.0f, (float)1.0f);
        blue = Mth.clamp((float)blue, (float)0.0f, (float)1.0f);
        int defaultColor = ColorABGR.pack(red, green, blue, 1.0f);
        random.setSeed(42L);
        List<BlockModelPart> list = LIST.get();
        list.clear();
        bakedModel.collectParts(level, pos, state, random, list);
        for (BlockModelPart part : list) {
            VertexBufferWriter writer = VertexBufferWriter.of(bufferSource.getBuffer(RenderTypeHelper.getEntityRenderType((ChunkSectionLayer)part.getRenderType(state))));
            if (writer == null) {
                return;
            }
            for (Direction direction : DirectionUtil.ALL_DIRECTIONS) {
                List quads = part.getQuads(direction);
                if (quads.isEmpty()) continue;
                ModelBlockRendererMixin.renderQuads(entry, writer, defaultColor, quads, light, overlay);
            }
            List quads = part.getQuads(null);
            if (quads.isEmpty()) continue;
            ModelBlockRendererMixin.renderQuads(entry, writer, defaultColor, quads, light, overlay);
        }
        ci.cancel();
    }
}

