/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.render.model.item;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.caffeinemc.mods.sodium.api.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.client.model.quad.BakedQuadView;
import net.caffeinemc.mods.sodium.client.render.immediate.model.BakedModelEncoder;
import net.caffeinemc.mods.sodium.client.render.vertex.VertexConsumerUtils;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    @Unique
    private static final ThreadLocal<RandomSource> random = ThreadLocal.withInitial(() -> new SingleThreadedRandomSource(42L));

    @Shadow
    private static int getLayerColorSafe(int[] is, int i) {
        throw new AssertionError((Object)"Not shadowed");
    }

    @WrapOperation(method={"renderItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/ItemRenderer;renderQuadList(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Ljava/util/List;[III)V")})
    private static void renderModelFast(PoseStack poseStack, VertexConsumer vertexConsumer, List<BakedQuad> quads, int[] colors, int light, int overlay, Operation<Void> original) {
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog(vertexConsumer);
        if (writer == null) {
            original.call(new Object[]{poseStack, vertexConsumer, quads, colors, light, overlay});
            return;
        }
        if (!quads.isEmpty()) {
            ItemRendererMixin.renderBakedItemQuads(poseStack.last(), writer, quads, colors, light, overlay);
        }
    }

    @Unique
    private static void renderBakedItemQuads(PoseStack.Pose matrices, VertexBufferWriter writer, List<BakedQuad> quads, int[] colors, int light, int overlay) {
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad bakedQuad = quads.get(i);
            if (bakedQuad.vertices().length < 32) continue;
            BakedQuadView quad = (BakedQuadView)bakedQuad;
            int color = -1;
            if (bakedQuad.isTinted()) {
                color = ColorARGB.toABGR(ItemRendererMixin.getLayerColorSafe(colors, bakedQuad.tintIndex()));
            }
            BakedModelEncoder.writeQuadVertices(writer, matrices, quad, color, light, overlay, BakedModelEncoder.shouldMultiplyAlpha());
            if (quad.getSprite() == null) continue;
            SpriteUtil.INSTANCE.markSpriteActive(quad.getSprite());
        }
    }
}

