/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.workarounds.context_creation;

import com.mojang.blaze3d.TracyFrameCapture;
import com.mojang.blaze3d.shaders.ShaderType;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.BiFunction;
import net.caffeinemc.mods.sodium.client.compatibility.checks.ModuleScanner;
import net.caffeinemc.mods.sodium.client.compatibility.checks.PostLaunchChecks;
import net.caffeinemc.mods.sodium.client.compatibility.environment.GlContextInfo;
import net.caffeinemc.mods.sodium.client.platform.NativeWindowHandle;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.glfw.GLFWNativeWin32;
import org.lwjgl.opengl.WGL;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderSystem.class})
public class RenderSystemMixin {
    @Shadow
    @Final
    static Logger LOGGER;
    @Unique
    private static long wglPrevContext;

    @Inject(method={"initRenderer"}, at={@At(value="RETURN")})
    private static void postContextReady(long window, int i, boolean bl, BiFunction<ResourceLocation, ShaderType, String> biFunction, boolean bl2, CallbackInfo ci) {
        GlContextInfo context = GlContextInfo.create();
        LOGGER.info("OpenGL Vendor: {}", (Object)context.vendor());
        LOGGER.info("OpenGL Renderer: {}", (Object)context.renderer());
        LOGGER.info("OpenGL Version: {}", (Object)context.version());
        wglPrevContext = Util.getPlatform() == Util.OS.WINDOWS ? WGL.wglGetCurrentContext() : 0L;
        NativeWindowHandle handle = () -> GLFWNativeWin32.glfwGetWin32Window((long)window);
        PostLaunchChecks.onContextInitialized((NativeWindowHandle)handle, (GlContextInfo)context);
        ModuleScanner.checkModules((NativeWindowHandle)handle);
    }

    @Inject(method={"flipFrame"}, at={@At(value="RETURN")})
    private static void preSwapBuffers(long window, TracyFrameCapture tracyFrameCapture, CallbackInfo ci) {
        if (wglPrevContext == 0L) {
            return;
        }
        long context = WGL.wglGetCurrentContext();
        if (wglPrevContext == context) {
            return;
        }
        LOGGER.warn("The OpenGL context appears to have been suddenly replaced! Something has likely just injected into the game process.");
        ModuleScanner.checkModules(() -> GLFWNativeWin32.glfwGetWin32Window((long)window));
        wglPrevContext = context;
    }
}

