/*
 * Decompiled with CFR 0.152.
 */
package team.creative.playerrevive.cap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.playerrevive.PlayerRevive;
import team.creative.playerrevive.api.CombatTrackerClone;
import team.creative.playerrevive.api.IBleeding;
import team.creative.playerrevive.packet.HelperPacket;

public class Bleeding
implements IBleeding {
    private boolean bleeding;
    private float progress;
    private int timeLeft;
    private int downedTime;
    private DamageSource lastSource;
    private CombatTrackerClone trackerClone;
    private boolean itemConsumed = false;
    public final List<Player> revivingPlayers = new ArrayList<Player>();

    @Override
    public void tick(Player player) {
        if (player.getPose() != Pose.SWIMMING) {
            player.setForcedPose(Pose.SWIMMING);
        }
        Iterator<Player> iterator = this.revivingPlayers.iterator();
        while (iterator.hasNext()) {
            Player helper = iterator.next();
            if (!((double)helper.distanceTo((Entity)player) > PlayerRevive.CONFIG.revive.maxDistance)) continue;
            PlayerRevive.NETWORK.sendToClient((CreativePacket)new HelperPacket(null, false), (ServerPlayer)helper);
            iterator.remove();
        }
        if (this.revivingPlayers.isEmpty() || !PlayerRevive.CONFIG.revive.haltBleedTime) {
            --this.timeLeft;
        }
        if (this.revivingPlayers.isEmpty() && PlayerRevive.CONFIG.revive.resetProgress) {
            this.progress = 0.0f;
        }
        this.progress += (float)this.revivingPlayers.size() * PlayerRevive.CONFIG.revive.progressPerPlayer;
        ++this.downedTime;
        if (PlayerRevive.CONFIG.revive.exhaustion > 0.0f) {
            for (int i = 0; i < this.revivingPlayers.size(); ++i) {
                this.revivingPlayers.get(i).causeFoodExhaustion(PlayerRevive.CONFIG.revive.exhaustion);
            }
        }
    }

    @Override
    public void forceBledOut() {
        this.bleeding = true;
        this.timeLeft = 0;
    }

    @Override
    public int downedTime() {
        return this.downedTime;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public boolean revived() {
        return this.progress >= PlayerRevive.CONFIG.revive.requiredReviveProgress;
    }

    @Override
    public boolean bledOut() {
        return this.bleeding && this.timeLeft <= 0;
    }

    public void serialize(ValueOutput output) {
        output.putInt("timeLeft", this.timeLeft);
        output.putFloat("progress", this.progress);
        output.putBoolean("bleeding", this.bleeding);
        output.putBoolean("consumed", this.itemConsumed);
    }

    public void deserialize(ValueInput input) {
        this.timeLeft = input.getIntOr("timeLeft", 0);
        this.progress = input.getFloatOr("progress", 0.0f);
        this.bleeding = input.getBooleanOr("bleeding", false);
        this.itemConsumed = input.getBooleanOr("consumed", false);
    }

    @Override
    public boolean isBleeding() {
        return this.bleeding;
    }

    @Override
    public void knockOut(Player player, DamageSource source) {
        this.bleeding = true;
        this.progress = 0.0f;
        this.downedTime = 0;
        this.timeLeft = PlayerRevive.CONFIG.bleeding.bleedTime;
        this.lastSource = source;
        this.trackerClone = new CombatTrackerClone(player.getCombatTracker());
    }

    @Override
    public void revive() {
        this.bleeding = false;
        this.progress = 0.0f;
        this.timeLeft = 0;
        this.downedTime = 0;
        this.lastSource = null;
        this.trackerClone = null;
        this.itemConsumed = false;
    }

    @Override
    public int timeLeft() {
        return this.timeLeft;
    }

    @Override
    public List<Player> revivingPlayers() {
        return this.revivingPlayers;
    }

    @Override
    public CombatTrackerClone getTrackerClone() {
        return this.trackerClone;
    }

    @Override
    public DamageSource getSource(RegistryAccess access) {
        if (this.lastSource != null) {
            return this.lastSource;
        }
        return new DamageSource((Holder)access.lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(PlayerRevive.BLED_TO_DEATH));
    }

    @Override
    public boolean isItemConsumed() {
        return this.itemConsumed;
    }

    @Override
    public void setItemConsumed() {
        this.itemConsumed = true;
    }
}

