/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.capabilities;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.refractionapi.refraction.capabilities.Data;
import net.refractionapi.refraction.helper.misc.GenericBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Provider<E extends Data<E>>
implements ICapabilityProvider,
INBTSerializable<CompoundTag>,
GenericBuilder<E> {
    private E data = null;
    private final LazyOptional<E> optional = LazyOptional.of(this::createData);

    protected abstract Capability<E> getData();

    private E createData() {
        return (E)(this.data == null ? (this.data = (Data)this.build()) : this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == this.getData() ? this.optional.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ((Data)this.createData()).saveNBTData(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ((Data)this.createData()).loadNBTData(nbt);
    }
}

