/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.client;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.refractionapi.refraction.Refraction;
import net.refractionapi.refraction.debug.RDebugRenderer;
import net.refractionapi.refraction.feature.channel.TwoWayIntermediary;
import net.refractionapi.refraction.feature.cutscenes.client.ClientCutsceneData;
import net.refractionapi.refraction.feature.data.ClientSyncer;
import net.refractionapi.refraction.feature.data.SerializableHandler;
import net.refractionapi.refraction.feature.examples.interaction.ExampleInteractionScreen;
import net.refractionapi.refraction.feature.interaction.NPCInteraction;
import net.refractionapi.refraction.feature.quest.client.ClientQuestInfo;
import net.refractionapi.refraction.feature.screen.ClientScreenHandler;
import net.refractionapi.refraction.feature.screen.ScreenBuilder;
import net.refractionapi.refraction.feature.sound.TrackingSound;
import net.refractionapi.refraction.helper.math.EasingFunctions;
import net.refractionapi.refraction.util.Keybindings;

public class ClientData {
    public static boolean canMove = true;
    public static boolean canRotateCamera = true;
    public static int startFOV = -1;
    public static double currentFOV = -1.0;
    public static int endFOV = -1;
    public static int transitionTicksFOV = -1;
    public static int progressTrackerFOV = 0;
    public static EasingFunctions easingFunctionFOV = EasingFunctions.LINEAR;
    public static float startZRot = -1.0f;
    public static float currentZRot = -1.0f;
    public static float endZRot = -1.0f;
    public static int transitionTicksZRot = -1;
    public static int progressTrackerZRot = 0;
    public static EasingFunctions easingFunctionZRot = EasingFunctions.LINEAR;
    public static ClientScreenHandler screenHandler = new ClientScreenHandler();

    public static void trackingSound(int entityId, SoundEvent soundEvent, boolean looping, int ticks) {
        LivingEntity livingEntity = (LivingEntity)Minecraft.m_91087_().f_91073_.m_6815_(entityId);
        if (livingEntity != null) {
            TrackingSound sound = new TrackingSound(soundEvent, livingEntity, looping, ticks);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    public static void playLocalSound(ResourceLocation resourceLocation) {
        SoundEvent event = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(resourceLocation);
        if (event == null) {
            return;
        }
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new EntityBoundSoundInstance(event, SoundSource.AMBIENT, 1.0f, 1.0f, (Entity)Minecraft.m_91087_().f_91074_, RandomSource.m_216327_().m_188505_()));
    }

    public static <T extends Screen> T createScreen(ScreenBuilder<?> builder, Object ... args) {
        Class<? extends Screen> screenClass = ClientScreenHandler.getScreen(builder);
        if (screenClass == null) {
            return null;
        }
        try {
            return (T)screenClass.getConstructor(SerializableHandler.formClassArray(args)).newInstance(args);
        }
        catch (Exception e) {
            Refraction.LOGGER.error("Failed to create screen", (Throwable)e);
            return null;
        }
    }

    public static Player getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static LivingEntity getEntity(int id) {
        LivingEntity livingEntity;
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(id);
        return entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null;
    }

    public static Entity getEntityRaw(int id) {
        return Minecraft.m_91087_().f_91073_.m_6815_(id);
    }

    public static void handleInteraction(Supplier<NPCInteraction> interaction, CompoundTag tag) {
        String stage = tag.m_128461_("stage");
        boolean close = tag.m_128471_("close");
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof ExampleInteractionScreen) {
            ExampleInteractionScreen screen2 = (ExampleInteractionScreen)screen;
            if (!stage.isEmpty()) {
                screen2.switchStage(stage);
            }
            if (close) {
                screen2.m_7379_();
            }
            return;
        }
        Minecraft.m_91087_().m_91152_((Screen)new ExampleInteractionScreen(interaction.get()));
    }

    public static void load() {
        Keybindings.init();
        RDebugRenderer.init();
        ClientScreenHandler.init();
    }

    public static void reset() {
        canMove = true;
        canRotateCamera = true;
        startFOV = -1;
        currentFOV = -1.0;
        endFOV = -1;
        transitionTicksFOV = -1;
        progressTrackerFOV = 0;
        easingFunctionFOV = EasingFunctions.LINEAR;
        startZRot = -1.0f;
        currentZRot = -1.0f;
        endZRot = -1.0f;
        transitionTicksZRot = -1;
        progressTrackerZRot = 0;
        easingFunctionZRot = EasingFunctions.LINEAR;
        ClientCutsceneData.reset();
        ClientQuestInfo.reset();
        ClientSyncer.SERIALIZERS.clear();
        TwoWayIntermediary.instance(false).reset();
    }
}

