/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.client.screen;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.refractionapi.refraction.config.RRuntimeConfig;
import net.refractionapi.refraction.feature.algorithm.MazeGenerator;
import net.refractionapi.refraction.feature.examples.screen.ExampleScreenRegistry;
import net.refractionapi.refraction.feature.screen.ServerScreen;

public class RDashboardServer
extends ServerScreen {
    public RDashboardServer(ServerPlayer player) {
        super(ExampleScreenRegistry.DASHBOARD, player);
    }

    @Override
    public boolean stillValid() {
        return RRuntimeConfig.debugTools && this.getPlayer().m_20310_(2);
    }

    @Override
    public void handle(CompoundTag tag) {
        if (tag.m_128461_("type").equals("maze")) {
            this.createMaze(tag);
        }
    }

    private void createMaze(CompoundTag tag) {
        int size = tag.m_128451_("size");
        int wallHeight = tag.m_128451_("wallHeight");
        int wallThickness = tag.m_128451_("wallThickness");
        int centerSize = tag.m_128451_("centerSize");
        int[] start = tag.m_128465_("start");
        BlockPos startBlock = new BlockPos(start[0], start[1], start[2]);
        Direction startDirection = Direction.m_122402_((String)tag.m_128461_("startDirection").toUpperCase());
        Block wallBlock = this.getBlock(tag.m_128461_("wallBlock"));
        Block wallOuterBlock = this.getBlock(tag.m_128461_("wallOuterBlock"));
        Block floorBlock = this.getBlock(tag.m_128461_("floorBlock"));
        Block ceilingBlock = this.getBlock(tag.m_128461_("ceilingBlock"));
        MazeGenerator generator = new MazeGenerator((Level)this.getPlayer().m_284548_());
        generator.setCeilingBlock(ceilingBlock.m_49966_());
        generator.setFloorBlock(floorBlock.m_49966_());
        generator.setWallBlock(wallBlock.m_49966_());
        generator.setWallOuterBlock(wallOuterBlock.m_49966_());
        generator.setWallHeight(wallHeight);
        generator.setWallThickness(wallThickness);
        generator.setCenterSize(centerSize);
        generator.setMazeSize(size);
        generator.setStart(startBlock, startDirection);
        generator.generate();
    }

    private Block getBlock(String name) {
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)name));
        return block == null ? Blocks.f_50016_ : block;
    }
}

