/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.data;

import java.util.HashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.refractionapi.refraction.helper.clazz.RModRegistrar;
import net.refractionapi.refraction.init.ModSpec;
import net.refractionapi.refraction.mixininterfaces.IServerPlayer;

public abstract class TData {
    public final ModSpec id;
    private static final HashMap<ModSpec, TData> data = new HashMap();
    protected Player player;

    public TData(ModSpec id) {
        this.id = id;
        data.put(this.id, this);
    }

    public TData(ModSpec id, Player player) {
        this.id = id;
        this.player = player;
    }

    public abstract TData create(ModSpec var1, Player var2);

    public static <T extends TData> T get(Player player, String fromMod) {
        TData tData;
        if (!(player instanceof ServerPlayer)) {
            throw new UnsupportedOperationException("Can't retrieve TData on client!");
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (serverPlayer instanceof IServerPlayer) {
            IServerPlayer iServerPlayer = (IServerPlayer)serverPlayer;
            tData = iServerPlayer.get(data.get(RModRegistrar.getSpec(fromMod)));
        } else {
            tData = null;
        }
        return (T)tData;
    }

    public static <T extends TData> T get(Player player) {
        return TData.get(player, RModRegistrar.getCallerModID());
    }

    public static <T extends TData> T get(Player player, Class<T> clazz) {
        return TData.get(player, RModRegistrar.getCallerModID());
    }
}

