/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.debug;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.refractionapi.refraction.Refraction;
import net.refractionapi.refraction.debug.RDebugRenderers;
import net.refractionapi.refraction.debug.debuggers.AABBRenderer;
import net.refractionapi.refraction.debug.debuggers.PathfindingRenderer;
import net.refractionapi.refraction.debug.debuggers.RAABBRenderer;
import net.refractionapi.refraction.debug.debuggers.TraceEntitiesRenderer;
import net.refractionapi.refraction.feature.channel.NamedAPI;
import net.refractionapi.refraction.helper.vec3.RAAB;
import org.joml.Matrix4f;

public abstract class RDebugRenderer {
    protected final Minecraft minecraft = Minecraft.m_91087_();
    protected static final HashMap<String, RDebugRenderer> renderers = new HashMap();
    public static final Set<String> enabled = new HashSet<String>();
    protected final String id;
    public static final NamedAPI api = NamedAPI.create(RDebugRenderers.API_ID).configure(channel -> channel.registerListener("route", (plr, buf) -> {
        String id1 = buf.m_130277_();
        RDebugRenderer.route(id1, buf);
        return 1;
    })).initOnOpen();
    public static AABBRenderer aabbRenderer;
    public static RAABBRenderer raabbRenderer;
    public static PathfindingRenderer pathfindingRenderer;
    public static TraceEntitiesRenderer traceEntitiesRenderer;

    public RDebugRenderer(String id) {
        this.id = id;
        if (renderers.containsKey(id)) {
            Refraction.LOGGER.warn("Renderer already exists {}, overwriting!", (Object)id);
        }
        renderers.put(id, this);
    }

    protected abstract void render(PoseStack var1, MultiBufferSource var2);

    public void renderGUI() {
    }

    protected void tick(boolean post) {
    }

    protected abstract void fromPacket(FriendlyByteBuf var1);

    protected void renderLineBox(AABB aabb, float red, float green, float blue, float alpha, PoseStack stack, MultiBufferSource source) {
        LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)source.m_6299_((RenderType)RenderType.f_110371_), (AABB)aabb, (float)red, (float)green, (float)blue, (float)alpha);
    }

    protected void renderLineBox(RAAB raab, float red, float green, float blue, float alpha, PoseStack stack, MultiBufferSource source) {
        stack.m_85836_();
        Vec3 bottomLeft = raab.positions[0][0];
        Vec3 bottomRight = raab.positions[0][1];
        Vec3 topRight = raab.positions[0][2];
        Vec3 topLeft = raab.positions[0][3];
        Vec3 bottomLeft2 = raab.positions[1][0];
        Vec3 bottomRight2 = raab.positions[1][1];
        Vec3 topRight2 = raab.positions[1][2];
        Vec3 topLeft2 = raab.positions[1][3];
        this.renderLine(bottomLeft, bottomRight, red, green, blue, alpha, 1.0f, stack, source);
        this.renderLine(bottomRight, topRight, red, green, blue, alpha, 1.0f, stack, source);
        this.renderLine(topRight, topLeft, red, green, blue, alpha, 1.0f, stack, source);
        this.renderLine(topLeft, bottomLeft, red, green, blue, alpha, 1.0f, stack, source);
        this.renderLine(bottomLeft2, bottomRight2, red, green, blue, alpha, 1.0f, stack, source);
        this.renderLine(bottomRight2, topRight2, red, green, blue, alpha, 1.0f, stack, source);
        this.renderLine(topRight2, topLeft2, red, green, blue, alpha, 1.0f, stack, source);
        this.renderLine(topLeft2, bottomLeft2, red, green, blue, alpha, 1.0f, stack, source);
        this.renderLine(bottomLeft, bottomLeft2, red, green, blue, alpha, 1.0f, stack, source);
        this.renderLine(bottomRight, bottomRight2, red, green, blue, alpha, 1.0f, stack, source);
        this.renderLine(topRight, topRight2, red, green, blue, alpha, 1.0f, stack, source);
        this.renderLine(topLeft, topLeft2, red, green, blue, alpha, 1.0f, stack, source);
        this.renderText("bottomLeft", bottomLeft, stack, source);
        this.renderText("bottomRight", bottomRight.m_82490_(2.0), stack, source);
        this.renderText("topRight", topRight.m_82490_(2.0), stack, source);
        this.renderText("topLeft", topLeft.m_82490_(2.0), stack, source);
        this.renderText("center", raab.m_82399_().m_82490_(2.0), stack, source);
        stack.m_85849_();
    }

    protected void renderBox(AABB aabb, float red, float green, float blue, float alpha, PoseStack stack, MultiBufferSource source) {
        DebugRenderer.m_269311_((PoseStack)stack, (MultiBufferSource)source, (AABB)this.applyTransformation(aabb), (float)red, (float)green, (float)blue, (float)alpha);
    }

    protected void renderLine(Vec3 start, Vec3 end, float red, float green, float blue, float alpha, float lineWidth, PoseStack stack, MultiBufferSource source) {
        stack.m_85836_();
        RenderSystem.lineWidth((float)lineWidth);
        VertexConsumer builder = source.m_6299_((RenderType)RenderType.f_110371_);
        builder.m_252986_(stack.m_85850_().m_252922_(), (float)start.f_82479_, (float)start.f_82480_, (float)start.f_82481_).m_85950_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(stack.m_85850_().m_252922_(), (float)end.f_82479_, (float)end.f_82480_, (float)end.f_82481_).m_85950_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        RenderSystem.lineWidth((float)1.0f);
        stack.m_85849_();
    }

    protected void renderCircle(Vec3 center, float xRot, float yRot, float radius, float width, int color, PoseStack stack, MultiBufferSource source) {
        stack.m_85836_();
        stack.m_85837_(center.f_82479_, center.f_82480_, center.f_82481_);
        stack.m_252781_(Axis.f_252529_.m_252977_(xRot));
        stack.m_252781_(Axis.f_252403_.m_252977_(yRot));
        VertexConsumer builder = source.m_6299_(RenderType.m_269399_((double)width));
        for (int i = 0; i < 20; ++i) {
            this.renderCircleVertex(i, stack.m_85850_().m_252922_(), center.f_82479_, center.f_82480_, center.f_82481_, builder, center, radius, color);
        }
        this.renderCircleVertex(0, stack.m_85850_().m_252922_(), center.f_82479_, center.f_82480_, center.f_82481_, builder, center, radius, color);
        stack.m_85849_();
    }

    protected void renderCircleVertex(int index, Matrix4f pose, double xOffset, double yOffset, double zOffset, VertexConsumer consumer, Vec3 circleCenter, float radius, int color) {
        float f = (float)index * 0.31415927f;
        Vec3 vec3 = circleCenter.m_82520_((double)radius * Math.cos(f), 0.0, (double)radius * Math.sin(f));
        consumer.m_252986_(pose, (float)(vec3.f_82479_ - xOffset), (float)(vec3.f_82480_ - yOffset), (float)(vec3.f_82481_ - zOffset)).m_193479_(color).m_5752_();
    }

    protected void renderLine(BlockPos start, BlockPos end, float red, float green, float blue, float alpha, float lineWidth, PoseStack stack, MultiBufferSource source) {
        this.renderLine(start.m_252807_(), end.m_252807_(), red, green, blue, alpha, lineWidth, stack, source);
    }

    protected void renderText(String string, Vec3 vec3, PoseStack stack, MultiBufferSource source) {
        DebugRenderer.m_269271_((PoseStack)stack, (MultiBufferSource)source, (String)string, (double)((float)vec3.f_82479_), (double)((float)vec3.f_82480_), (double)((float)vec3.f_82481_), (int)-1);
    }

    protected AABB applyTransformation(AABB aabb) {
        Vec3 camera = this.cameraPosition();
        return new AABB(aabb.f_82288_ - camera.f_82479_ - (double)0.51f, aabb.f_82289_ - camera.f_82480_ - (double)0.51f, aabb.f_82290_ - camera.f_82481_ - (double)0.51f, aabb.f_82291_ - camera.f_82479_ + (double)0.51f, aabb.f_82292_ - camera.f_82480_ + (double)0.51f, aabb.f_82293_ - camera.f_82481_ + (double)0.51f);
    }

    protected float distanceToCamera(BlockPos pos) {
        Vec3 camPos = this.cameraPosition();
        return (float)(Math.abs((double)pos.m_123341_() - camPos.f_82479_) + Math.abs((double)pos.m_123342_() - camPos.f_82480_) + Math.abs((double)pos.m_123343_() - camPos.f_82481_));
    }

    protected Vec3 cameraPosition() {
        return Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
    }

    public boolean isEnabled() {
        return RDebugRenderer.isEnabled(this.id);
    }

    public static boolean isEnabled(String id) {
        return enabled.contains(id);
    }

    public static void toggle(String id) {
        if (enabled.contains(id)) {
            enabled.remove(id);
        } else {
            enabled.add(id);
        }
    }

    public static void renderAll(PoseStack poseStack, MultiBufferSource multiBufferSource) {
        renderers.values().forEach(renderer -> {
            if (renderer.isEnabled()) {
                renderer.render(poseStack, multiBufferSource);
            }
        });
    }

    public static void tickAll(boolean post) {
        renderers.values().forEach(renderer -> {
            if (renderer.isEnabled()) {
                renderer.tick(post);
            }
        });
    }

    public static Set<String> getRenderers() {
        return renderers.keySet();
    }

    public static RDebugRenderer getRenderer(String id) {
        return renderers.get(id);
    }

    public static void route(String id, FriendlyByteBuf buf) {
        RDebugRenderer renderer = renderers.get(id);
        if (renderer != null) {
            renderer.fromPacket(buf);
        } else {
            Refraction.LOGGER.warn("Router not found {}", (Object)id);
        }
    }

    public static void init() {
        aabbRenderer = new AABBRenderer();
        raabbRenderer = new RAABBRenderer();
        pathfindingRenderer = new PathfindingRenderer();
        traceEntitiesRenderer = new TraceEntitiesRenderer();
    }
}

