/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.debug;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.AABB;
import net.refractionapi.refraction.Refraction;
import net.refractionapi.refraction.config.RRuntimeConfig;
import net.refractionapi.refraction.config.RServerConfig;
import net.refractionapi.refraction.debug.IRDebugRenderers;
import net.refractionapi.refraction.debug.RDebugEmpty;
import net.refractionapi.refraction.feature.channel.NamedAPI;
import net.refractionapi.refraction.helper.vec3.RAAB;
import net.refractionapi.refraction.mixininterfaces.IPath;

public class RDebugRenderers
implements IRDebugRenderers {
    private static IRDebugRenderers instance;
    private static final RDebugEmpty empty;
    public static final ResourceLocation API_ID;
    private static final NamedAPI api;

    private RDebugRenderers() {
    }

    @Override
    public void renderAABB(AABB aabb, int r, int g, int b, int time) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        BlockPos corner1 = BlockPos.m_274561_((double)aabb.f_82288_, (double)aabb.f_82289_, (double)aabb.f_82290_);
        BlockPos corner2 = BlockPos.m_274561_((double)aabb.f_82291_, (double)aabb.f_82292_, (double)aabb.f_82293_);
        buf.m_130064_(corner1);
        buf.m_130064_(corner2);
        buf.writeInt(r);
        buf.writeInt(g);
        buf.writeInt(b);
        buf.writeInt(time);
        this.send("aabb", buf);
    }

    @Override
    public void renderRAAB(RAAB aabb, int r, int g, int b, int time) {
        CompoundTag tag = new CompoundTag();
    }

    @Override
    public void renderPath(int entityId, Path path, float maxDistance) {
        if (path == null) {
            return;
        }
        if (path instanceof IPath) {
            IPath iPath = (IPath)path;
            iPath.debug(iPath.getNodes().toArray(new Node[0]), iPath.getNodes().toArray(new Node[0]), iPath.getNodes().stream().map(node -> new Target(node.f_77271_, node.f_77272_, node.f_77273_)).collect(Collectors.toSet()));
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(entityId);
        buf.writeFloat(maxDistance);
        path.m_164704_(buf);
        this.send("pathfinding", buf);
    }

    @Override
    public void send(String id, FriendlyByteBuf buf) {
        if (api.channel() == null || api.channel().isClosed()) {
            return;
        }
        api.channel().send("route", (FriendlyByteBuf send) -> {
            send.m_130070_(id);
            send.writeBytes((ByteBuf)buf);
        });
    }

    public static IRDebugRenderers instance() {
        IRDebugRenderers iRDebugRenderers;
        if (RRuntimeConfig.debugTools) {
            if (instance == null) {
                instance = new RDebugRenderers();
                iRDebugRenderers = instance;
            } else {
                iRDebugRenderers = instance;
            }
        } else {
            iRDebugRenderers = empty;
        }
        return iRDebugRenderers;
    }

    public static void init() {
    }

    static {
        empty = new RDebugEmpty();
        API_ID = Refraction.id("debug");
        api = NamedAPI.create(API_ID).configure(channel -> channel.canSendTo(RServerConfig::isPermitted)).initOnServerStart();
    }
}

